/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.jetbrains.annotations.Nullable;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigEntryListWidget
extends AbstractSelectionList<TConfigEntryForList> {
    public TConfigEntryListWidget(int width, int height, int y, int x, int itemHeight, TConfigEntry ... entries) {
        super(Minecraft.getInstance(), width, height, y, y + height, itemHeight);
        for (TConfigEntry option : entries) {
            if (option == null || option.getWidget(0, 0, 0, 0) == null) continue;
            this.addEntry(option);
        }
        this.setX(x);
    }

    private int getX() {
        return this.x0;
    }

    private void setX(int x) {
        this.x0 = x;
        this.x1 = x + this.width;
    }

    public int getRowWidth() {
        return Math.min(this.width - 14, super.getRowWidth());
    }

    protected int getScrollbarPosition() {
        return this.getX() == 0 ? super.getScrollbarPosition() : this.getX() + this.getRowWidth() + 4;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected boolean isValidMouseClick(int button) {
        return true;
    }

    public void setSelected(@Nullable TConfigEntryForList entry) {
    }

    public static abstract class TConfigEntryForList
    extends AbstractSelectionList.Entry<TConfigEntryForList> {
        @Nullable
        protected AbstractWidget lastWidgetRendered = null;

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.lastWidgetRendered = this.getWidget(x, y, entryWidth, entryHeight);
            if (this.lastWidgetRendered != null) {
                this.lastWidgetRendered.render(context, mouseX, mouseY, tickDelta);
            }
        }

        public abstract AbstractWidget getWidget(int var1, int var2, int var3, int var4);

        private boolean ignoreMouseAt(double mouseX, double mouseY) {
            return this.lastWidgetRendered == null || !this.lastWidgetRendered.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.ignoreMouseAt(mouseX, mouseY)) {
                return false;
            }
            return this.lastWidgetRendered.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.ignoreMouseAt(mouseX, mouseY)) {
                return false;
            }
            return this.lastWidgetRendered.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (this.ignoreMouseAt(mouseX, mouseY)) {
                return false;
            }
            return this.lastWidgetRendered.mouseReleased(mouseX, mouseY, button);
        }

        public void setFocused(boolean focused) {
            if (this.lastWidgetRendered == null) {
                return;
            }
            this.lastWidgetRendered.setFocused(focused);
        }
    }
}

