/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import java.util.Optional;
import java.util.Properties;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3879;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.ETFException;
import traben.entity_texture_features.config.ETFConfig;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.texture_handlers.ETFSprite;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFTexture {
    public static final String PATCH_NAMESPACE_PREFIX = "etf_patched_";
    public final class_2960 thisIdentifier;
    public TextureReturnState currentTextureState = TextureReturnState.NORMAL;
    public String eSuffix = null;
    private class_2960 thisIdentifier_Patched = null;
    private class_2960 emissiveIdentifier = null;
    private class_2960 emissiveBlinkIdentifier = null;
    private class_2960 emissiveBlink2Identifier = null;
    private class_2960 enchantIdentifier = null;
    private class_2960 enchantBlinkIdentifier = null;
    private class_2960 enchantBlink2Identifier = null;
    private class_2960 blinkIdentifier = null;
    private class_2960 blink2Identifier = null;
    private class_2960 blinkIdentifier_Patched = null;
    private class_2960 blink2Identifier_Patched = null;
    private Integer blinkLength;
    private Integer blinkFrequency;
    private boolean isBuilt;
    private ETFSprite atlasSprite;
    private boolean hasBeenReRegistered;
    private Boolean resourceExists;
    private boolean guiBlink;
    private boolean hasPatched;

    public ETFTexture(class_2960 variantIdentifier) {
        this.blinkLength = ETF.config().getConfig().blinkLength;
        this.blinkFrequency = ETF.config().getConfig().blinkFrequency;
        this.isBuilt = false;
        this.atlasSprite = null;
        this.hasBeenReRegistered = false;
        this.resourceExists = null;
        this.guiBlink = false;
        this.hasPatched = false;
        if (variantIdentifier == null) {
            ETFUtils2.logError("ETFTexture had a null identifier this should NOT happen");
            this.thisIdentifier = null;
            return;
        }
        this.thisIdentifier = variantIdentifier;
        this.setupBlinking();
        this.setupEmissives();
        this.setupEnchants();
    }

    public static ETFTexture manual(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 blinkIdentifier, @Nullable class_2960 blink2Identifier, @Nullable class_2960 emissiveIdentifier, @Nullable class_2960 blinkEmissiveIdentifier, @Nullable class_2960 blink2EmissiveIdentifier, @Nullable class_2960 enchantIdentifier, @Nullable class_2960 blinkenchantIdentifier, @Nullable class_2960 blink2enchantIdentifier, @Nullable class_2960 patchIdentifier, @Nullable class_2960 blinkpatchIdentifier, @Nullable class_2960 blink2patchIdentifier) {
        return new ETFTexture(modifiedSkinIdentifier, blinkIdentifier, blink2Identifier, emissiveIdentifier, blinkEmissiveIdentifier, blink2EmissiveIdentifier, enchantIdentifier, blinkenchantIdentifier, blink2enchantIdentifier, patchIdentifier, blinkpatchIdentifier, blink2patchIdentifier);
    }

    public static ETFTexture manual(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 emissiveIdentifier, @Nullable class_2960 enchantIdentifier) {
        return new ETFTexture(modifiedSkinIdentifier, null, null, emissiveIdentifier, null, null, enchantIdentifier, null, null, null, null, null);
    }

    private ETFTexture(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 blinkIdentifier, @Nullable class_2960 blink2Identifier, @Nullable class_2960 emissiveIdentifier, @Nullable class_2960 blinkEmissiveIdentifier, @Nullable class_2960 blink2EmissiveIdentifier, @Nullable class_2960 enchantIdentifier, @Nullable class_2960 blinkenchantIdentifier, @Nullable class_2960 blink2enchantIdentifier, @Nullable class_2960 patchIdentifier, @Nullable class_2960 blinkpatchIdentifier, @Nullable class_2960 blink2patchIdentifier) {
        this.blinkLength = ETF.config().getConfig().blinkLength;
        this.blinkFrequency = ETF.config().getConfig().blinkFrequency;
        this.isBuilt = false;
        this.atlasSprite = null;
        this.hasBeenReRegistered = false;
        this.resourceExists = null;
        this.guiBlink = false;
        this.hasPatched = false;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.blinkIdentifier = blinkIdentifier;
        this.blink2Identifier = blink2Identifier;
        this.emissiveIdentifier = emissiveIdentifier;
        this.emissiveBlinkIdentifier = blinkEmissiveIdentifier;
        this.emissiveBlink2Identifier = blink2EmissiveIdentifier;
        this.thisIdentifier_Patched = patchIdentifier;
        this.blinkIdentifier_Patched = blinkpatchIdentifier;
        this.blink2Identifier_Patched = blink2patchIdentifier;
        this.enchantIdentifier = enchantIdentifier;
        this.enchantBlinkIdentifier = blinkenchantIdentifier;
        this.enchantBlink2Identifier = blink2enchantIdentifier;
        boolean bl = this.hasPatched = this.thisIdentifier_Patched != null;
        if (this.hasPatched) {
            ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.thisIdentifier_Patched, (Object)this);
            if (this.blinkIdentifier_Patched != null) {
                ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.blinkIdentifier_Patched, (Object)this);
            }
            if (this.blink2Identifier_Patched != null) {
                ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.blink2Identifier_Patched, (Object)this);
            }
        }
        ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.thisIdentifier, (Object)this);
        if (blinkIdentifier != null) {
            ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)blinkIdentifier, (Object)this);
        }
        if (blink2Identifier != null) {
            ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)blink2Identifier, (Object)this);
        }
    }

    private ETFTexture(@NotNull class_2960 modifiedSkinIdentifier, @Nullable class_2960 emissiveIdentifier) {
        this.blinkLength = ETF.config().getConfig().blinkLength;
        this.blinkFrequency = ETF.config().getConfig().blinkFrequency;
        this.isBuilt = false;
        this.atlasSprite = null;
        this.hasBeenReRegistered = false;
        this.resourceExists = null;
        this.guiBlink = false;
        this.hasPatched = false;
        this.thisIdentifier = modifiedSkinIdentifier;
        this.emissiveIdentifier = emissiveIdentifier;
    }

    public static ETFTexture ofUnmodifiable(@NotNull class_2960 identifier, @Nullable class_2960 emissiveIdentifier) {
        return new ETFTexture(identifier, emissiveIdentifier);
    }

    public static void patchTextureToRemoveZFightingWithOtherTexture(class_1011 baseImage, class_1011 otherImage) throws IndexOutOfBoundsException {
        try {
            if (otherImage.method_4307() == baseImage.method_4307() && otherImage.method_4323() == baseImage.method_4323()) {
                for (int x = 0; x < baseImage.method_4307(); ++x) {
                    for (int y = 0; y < baseImage.method_4323(); ++y) {
                        if (otherImage.method_4311(x, y) == 0) continue;
                        ETFUtils2.setPixel(baseImage, x, y, 0);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ETFException("additional texture is not the correct size, ETF has crashed in the patching stage");
        }
    }

    private static boolean doesAnimaticaVersionExist(class_2960 identifier) {
        if (identifier == null) {
            return false;
        }
        String idString = identifier.toString();
        if (idString.endsWith("-anim")) {
            return true;
        }
        return class_310.method_1551().method_1531().method_34590(ETFUtils2.res(idString + "-anim"), null) != null;
    }

    private void setupBlinking() {
        class_2960 propertyIdentifier;
        Properties blinkingProps;
        if (!ETF.config().getConfig().enableBlinking) {
            return;
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        Optional vanillaR1 = resourceManager.method_14486(this.thisIdentifier);
        if (vanillaR1.isEmpty()) {
            return;
        }
        class_2960 possibleBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink.png");
        Optional blinkR1 = resourceManager.method_14486(possibleBlinkIdentifier);
        if (blinkR1.isEmpty()) {
            return;
        }
        String blink1PackName = ((class_3298)blinkR1.get()).method_14480();
        if (!blink1PackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(blink1PackName, ((class_3298)vanillaR1.get()).method_14480()))) {
            return;
        }
        this.blinkIdentifier = possibleBlinkIdentifier;
        class_2960 possibleBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2.png");
        Optional blinkR2 = resourceManager.method_14486(possibleBlink2Identifier);
        if (blinkR2.isPresent() && blink1PackName.equals(((class_3298)blinkR2.get()).method_14480())) {
            this.blink2Identifier = possibleBlink2Identifier;
        }
        if ((blinkingProps = ETFUtils2.readAndReturnPropertiesElseNull(propertyIdentifier = ETFUtils2.replaceIdentifier(possibleBlinkIdentifier, ".png", ".properties"))) == null) {
            return;
        }
        Optional propertyResource = resourceManager.method_14486(propertyIdentifier);
        if (propertyResource.isEmpty() || !((class_3298)propertyResource.get()).method_14480().equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(((class_3298)propertyResource.get()).method_14480(), blink1PackName))) {
            return;
        }
        this.blinkLength = blinkingProps.containsKey("blinkLength") ? Integer.parseInt(blinkingProps.getProperty("blinkLength").replaceAll("\\D", "")) : ETF.config().getConfig().blinkLength;
        this.blinkFrequency = blinkingProps.containsKey("blinkFrequency") ? Integer.parseInt(blinkingProps.getProperty("blinkFrequency").replaceAll("\\D", "")) : ETF.config().getConfig().blinkFrequency;
    }

    public boolean exists() {
        if (this.resourceExists == null) {
            this.resourceExists = class_310.method_1551().method_1478().method_14486(this.thisIdentifier).isPresent();
        }
        return this.isBuilt || this.resourceExists != false;
    }

    private void setupEmissives() {
        class_3300 resourceManager = class_310.method_1551().method_1478();
        for (String suffix : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
            String emissivePack;
            class_2960 emissiveId;
            Optional emissiveResource;
            Optional<class_3298> baseResource = this.getResourceOrModifyForTrims(resourceManager);
            if (baseResource.isEmpty() || (emissiveResource = resourceManager.method_14486(emissiveId = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", suffix + ".png"))).isEmpty() || !(emissivePack = ((class_3298)emissiveResource.get()).method_14480()).equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(emissivePack, baseResource.get().method_14480()))) continue;
            this.emissiveIdentifier = emissiveId;
            this.eSuffix = suffix;
            class_2960 blinkId = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink" + suffix + ".png");
            Optional blinkResource = resourceManager.method_14486(blinkId);
            if (!blinkResource.isPresent() || !emissivePack.equals(((class_3298)blinkResource.get()).method_14480())) break;
            this.emissiveBlinkIdentifier = blinkId;
            class_2960 blink2Id = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2" + suffix + ".png");
            Optional blink2Resource = resourceManager.method_14486(blink2Id);
            if (!blink2Resource.isPresent() || !emissivePack.equals(((class_3298)blink2Resource.get()).method_14480())) break;
            this.emissiveBlink2Identifier = blink2Id;
            break;
        }
    }

    private void setupEnchants() {
        if (!ETF.config().getConfig().enableEnchantedTextures) {
            return;
        }
        class_3300 resourceManager = class_310.method_1551().method_1478();
        String enchantSuffix = "_enchant";
        Optional<class_3298> vanillaR1 = this.getResourceOrModifyForTrims(resourceManager);
        if (vanillaR1.isEmpty()) {
            return;
        }
        class_2960 possibleEnchantIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", enchantSuffix + ".png");
        Optional enchantR1 = resourceManager.method_14486(possibleEnchantIdentifier);
        if (enchantR1.isEmpty()) {
            return;
        }
        String enchantPackName = ((class_3298)enchantR1.get()).method_14480();
        if (!enchantPackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(enchantPackName, vanillaR1.get().method_14480()))) {
            return;
        }
        this.enchantIdentifier = possibleEnchantIdentifier;
        class_2960 possibleEnchantBlinkIdentifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink" + enchantSuffix + ".png");
        Optional enchantBlinkR1 = resourceManager.method_14486(possibleEnchantBlinkIdentifier);
        if (enchantBlinkR1.isEmpty()) {
            return;
        }
        String enchantBlinkPackName = ((class_3298)enchantBlinkR1.get()).method_14480();
        if (!enchantBlinkPackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(enchantBlinkPackName, vanillaR1.get().method_14480()))) {
            return;
        }
        this.enchantBlinkIdentifier = possibleEnchantBlinkIdentifier;
        class_2960 possibleEnchantBlink2Identifier = ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_blink2" + enchantSuffix + ".png");
        Optional enchantBlink2R1 = resourceManager.method_14486(possibleEnchantBlink2Identifier);
        if (enchantBlink2R1.isEmpty()) {
            return;
        }
        String enchantBlink2PackName = ((class_3298)enchantBlink2R1.get()).method_14480();
        if (enchantBlink2PackName.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(enchantBlink2PackName, vanillaR1.get().method_14480()))) {
            this.enchantBlink2Identifier = possibleEnchantBlink2Identifier;
        }
    }

    private Optional<class_3298> getResourceOrModifyForTrims(class_3300 resourceManager) {
        Optional<class_3298> vanillaR1 = resourceManager.method_14486(this.thisIdentifier);
        if (vanillaR1.isEmpty() && (this.thisIdentifier.method_12832().contains("textures/trims/models/armor/") || this.thisIdentifier.method_12832().contains("textures/trims/entity/"))) {
            vanillaR1 = resourceManager.method_14486(ETFUtils2.res(this.thisIdentifier.method_12836(), this.thisIdentifier.method_12832().replaceAll("_(.*?)(?=\\.png)", "")));
            class_3262 pack = vanillaR1.map(class_3298::method_45304).orElseGet(() -> class_310.method_1551().method_45573());
            vanillaR1 = Optional.of(new class_3298(pack, null));
        }
        return vanillaR1;
    }

    @NotNull
    public class_2960 getTextureIdentifier(@Nullable ETFEntityRenderState entity) {
        this.currentTextureState = this.canPatch() ? TextureReturnState.NORMAL_PATCHED : TextureReturnState.NORMAL;
        return this.getBlinkingIdentifier(entity);
    }

    @NotNull
    private class_2960 getBlinkingIdentifier(@Nullable ETFEntityRenderState state) {
        if (!this.doesBlink() || state == null || !(state.entity() instanceof class_1309)) {
            return this.identifierOfCurrentState();
        }
        ETFEntity entity = state.entity();
        if (this.guiBlink) {
            this.setBlink(Math.abs((int)System.currentTimeMillis() / 20 % 50000), 0);
        } else if (((class_1309)entity).method_41328(class_4050.field_18078)) {
            this.modifyTextureState(TextureReturnState.APPLY_BLINK);
        } else if (((class_1309)entity).method_6059(class_1294.field_5919)) {
            this.modifyTextureState(this.doesBlink2() ? TextureReturnState.APPLY_BLINK2 : TextureReturnState.APPLY_BLINK);
        } else {
            this.setBlink(((class_1309)entity).field_6012, Math.abs(state.uuid().hashCode()));
        }
        return this.identifierOfCurrentState();
    }

    private void setBlink(int currentTime, int hash) {
        int uuidHash = hash % (this.blinkFrequency * 2) + 20 + this.blinkFrequency;
        int timeModulated = Math.abs(currentTime % uuidHash);
        if (timeModulated <= this.blinkLength + this.blinkLength) {
            if (this.doesBlink2()) {
                if ((double)timeModulated >= (double)this.blinkLength.intValue() / 1.5 && timeModulated <= this.blinkLength + 1 + this.blinkLength / 3) {
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK);
                } else {
                    this.modifyTextureState(TextureReturnState.APPLY_BLINK2);
                }
            } else {
                this.modifyTextureState(TextureReturnState.APPLY_BLINK);
            }
        }
    }

    public void setGUIBlink() {
        this.blinkFrequency = 100;
        this.blinkLength = 40;
        this.guiBlink = true;
    }

    public boolean isEmissive() {
        return this.emissiveIdentifier != null;
    }

    public boolean isEnchanted() {
        return this.enchantIdentifier != null;
    }

    public boolean canPatch() {
        return ETFRenderContext.isAllowedToPatch() && this.thisIdentifier_Patched != null;
    }

    public boolean doesBlink() {
        return this.blinkIdentifier != null;
    }

    @NotNull
    public ETFSprite getPaintingSprite(@NotNull class_1058 originalSprite, @Nullable class_2960 originalID) {
        if (this.atlasSprite == null) {
            this.atlasSprite = new ETFSprite(originalSprite, this, this.thisIdentifier.equals((Object)originalID));
        }
        return this.atlasSprite;
    }

    public boolean doesBlink2() {
        return this.blink2Identifier != null;
    }

    public String toString() {
        return "[" + this.thisIdentifier.toString() + ", emissive=" + this.isEmissive() + ", blinks=" + this.doesBlink() + "]";
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_630 modelPart) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, modelPart, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_630 modelPart, ETFConfig.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_4588 vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, null, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            ETFRenderContext.startSpecialRenderOverlayPhase();
            modelPart.method_22698(matrixStack, vertexC, 0xF000F2, class_4608.field_21444);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_3879 model) {
        this.renderEmissive(matrixStack, vertexConsumerProvider, model, ETFManager.getEmissiveMode());
    }

    public void renderEmissive(class_4587 matrixStack, class_4597 vertexConsumerProvider, class_3879 model, ETFConfig.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_4588 vertexC = this.getEmissiveVertexConsumer(vertexConsumerProvider, model, modeToUsePossiblyManuallyChosen);
        if (vertexC != null) {
            ETFRenderContext.startSpecialRenderOverlayPhase();
            model.method_60879(matrixStack, vertexC, 0xF000F2, class_4608.field_21444);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    @Nullable
    public class_4588 getEmissiveVertexConsumer(class_4597 vertexConsumerProvider, @Nullable class_3879 model, ETFConfig.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_1921 type = this.getEmissiveRenderLayer(model, modeToUsePossiblyManuallyChosen);
        if (type == null) {
            return null;
        }
        return vertexConsumerProvider.getBuffer(type);
    }

    @Nullable
    public class_1921 getEmissiveRenderLayer(@Nullable class_3879 model) {
        return this.getEmissiveRenderLayer(model, ETFManager.getEmissiveMode());
    }

    @Nullable
    public class_1921 getEmissiveRenderLayer(@Nullable class_3879 model, ETFConfig.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        ETFRenderContext.preventRenderLayerTextureModify();
        class_1921 type = this.getEmissiveVertexConsumerWrapped(model, modeToUsePossiblyManuallyChosen);
        ETFRenderContext.allowRenderLayerTextureModify();
        return type;
    }

    @Nullable
    private class_1921 getEmissiveVertexConsumerWrapped(@Nullable class_3879 model, ETFConfig.EmissiveRenderModes modeToUsePossiblyManuallyChosen) {
        class_2960 emissiveToUse;
        if (this.isEmissive() && (emissiveToUse = this.getEmissiveIdentifierOfCurrentState()) != null) {
            if (modeToUsePossiblyManuallyChosen == ETFConfig.EmissiveRenderModes.BRIGHT) {
                return class_1921.method_23592((class_2960)emissiveToUse, (boolean)true);
            }
            if (model == null) {
                return class_1921.method_23578((class_2960)emissiveToUse);
            }
            return model.method_23500(emissiveToUse);
        }
        return null;
    }

    private void modifyTextureState(TextureReturnState givenState) {
        switch (givenState.ordinal()) {
            case 7: {
                this.currentTextureState = this.currentTextureState == TextureReturnState.NORMAL_PATCHED ? TextureReturnState.BLINK_PATCHED : TextureReturnState.BLINK;
                break;
            }
            case 8: {
                this.currentTextureState = switch (this.currentTextureState.ordinal()) {
                    case 1, 3 -> TextureReturnState.BLINK2_PATCHED;
                    default -> TextureReturnState.BLINK2;
                };
            }
        }
    }

    @NotNull
    private class_2960 identifierOfCurrentState() {
        return switch (this.currentTextureState.ordinal()) {
            case 0 -> this.thisIdentifier;
            case 1 -> this.thisIdentifier_Patched;
            case 2 -> this.blinkIdentifier;
            case 3 -> this.blinkIdentifier_Patched;
            case 4 -> this.blink2Identifier;
            case 5 -> this.blink2Identifier_Patched;
            default -> this.thisIdentifier;
        };
    }

    @Nullable
    public class_2960 getEmissiveIdentifierOfCurrentState() {
        return switch (this.currentTextureState.ordinal()) {
            case 0, 1 -> this.emissiveIdentifier;
            case 2, 3 -> this.emissiveBlinkIdentifier;
            case 4, 5 -> this.emissiveBlink2Identifier;
            default -> this.emissiveIdentifier;
        };
    }

    @Nullable
    public class_2960 getEnchantIdentifierOfCurrentState() {
        return switch (this.currentTextureState.ordinal()) {
            case 0, 1 -> this.enchantIdentifier;
            case 2, 3 -> this.enchantBlinkIdentifier;
            case 4, 5 -> this.enchantBlink2Identifier;
            default -> this.enchantIdentifier;
        };
    }

    public void assertPatchedTextures() {
        if (!this.isEmissive() || this.hasPatched) {
            return;
        }
        this.hasPatched = true;
        class_3300 files = class_310.method_1551().method_1478();
        if ((ETF.isThisModLoaded("iris") || ETF.isThisModLoaded("oculus")) && (files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_s.png")).isPresent() || files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", "_n.png")).isPresent())) {
            return;
        }
        if (ETF.isThisModLoaded("animatica") && (ETFTexture.doesAnimaticaVersionExist(this.thisIdentifier) || ETFTexture.doesAnimaticaVersionExist(this.emissiveIdentifier)) || ETF.isThisModLoaded("moremcmeta") && (files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.mcmeta")).isPresent() || files.method_14486(ETFUtils2.replaceIdentifier(this.thisIdentifier, ".png", ".png.moremcmeta")).isPresent())) {
            return;
        }
        class_1011 newBaseTexture = ETFUtils2.getNativeImageElseNull(this.thisIdentifier);
        class_1011 newBlinkTexture = ETFUtils2.getNativeImageElseNull(this.blinkIdentifier);
        class_1011 newBlink2Texture = ETFUtils2.getNativeImageElseNull(this.blink2Identifier);
        boolean didPatch = false;
        if (this.emissiveIdentifier != null) {
            class_1011 emissiveImage = ETFUtils2.getNativeImageElseNull(this.emissiveIdentifier);
            try {
                ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBaseTexture, emissiveImage);
                didPatch = true;
                if (this.doesBlink() && this.emissiveBlinkIdentifier != null) {
                    class_1011 emissiveBlinkImage = ETFUtils2.getNativeImageElseNull(this.emissiveBlinkIdentifier);
                    ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlinkTexture, emissiveBlinkImage);
                    if (this.doesBlink2() && this.emissiveBlink2Identifier != null) {
                        class_1011 emissiveBlink2Image = ETFUtils2.getNativeImageElseNull(this.emissiveBlink2Identifier);
                        ETFTexture.patchTextureToRemoveZFightingWithOtherTexture(newBlink2Texture, emissiveBlink2Image);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (didPatch) {
                this.thisIdentifier_Patched = ETFUtils2.res(PATCH_NAMESPACE_PREFIX + this.thisIdentifier.method_12836(), this.thisIdentifier.method_12832());
                ETFUtils2.registerNativeImageToIdentifier(newBaseTexture, this.thisIdentifier_Patched);
                ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.thisIdentifier_Patched, (Object)this);
                if (this.doesBlink()) {
                    this.blinkIdentifier_Patched = ETFUtils2.res(PATCH_NAMESPACE_PREFIX + this.blinkIdentifier.method_12836(), this.blinkIdentifier.method_12832());
                    ETFUtils2.registerNativeImageToIdentifier(newBlinkTexture, this.blinkIdentifier_Patched);
                    ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.blinkIdentifier_Patched, (Object)this);
                    if (this.doesBlink2()) {
                        this.blink2Identifier_Patched = ETFUtils2.res(PATCH_NAMESPACE_PREFIX + this.blink2Identifier.method_12836(), this.blink2Identifier.method_12832());
                        ETFUtils2.registerNativeImageToIdentifier(newBlink2Texture, this.blink2Identifier_Patched);
                        ETFManager.getInstance().ETF_TEXTURE_CACHE.put((Object)this.blink2Identifier_Patched, (Object)this);
                    }
                }
            }
        }
    }

    public static enum TextureReturnState {
        NORMAL,
        NORMAL_PATCHED,
        BLINK,
        BLINK_PATCHED,
        BLINK2,
        BLINK2_PATCHED,
        APPLY_PATCH,
        APPLY_BLINK,
        APPLY_BLINK2;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "normal";
                case 2 -> "blink";
                case 4 -> "blink2";
                case 1 -> "normal_patched";
                case 3 -> "blink_patched";
                case 5 -> "blink2_patched";
                case 7 -> "apply_blink";
                case 8 -> "apply_blink2";
                case 6 -> "apply_patch";
            };
        }
    }
}

