/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Properties;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.WoolCarpetBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFEntity;

public class ColorProperty
extends StringArrayOrRegexProperty {
    protected ColorProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        super(RandomProperty.readPropertiesOrThrow(properties, propertyNum, "colors", "collarColors"));
    }

    public static ColorProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new ColorProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return true;
    }

    @Override
    @Nullable
    protected String getValueFromEntity(ETFEntityRenderState state) {
        if (state != null) {
            Shulker shulker;
            DyeColor str;
            ETFEntity entity = state.entity();
            if (entity instanceof Llama) {
                BlockItem blockItem;
                Item item;
                Llama llama = (Llama)entity;
                if (llama.getBodyArmorItem().is(ItemTags.WOOL_CARPETS) && (item = llama.getBodyArmorItem().getItem()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof WoolCarpetBlock) {
                    WoolCarpetBlock woolCarpetBlock = (WoolCarpetBlock)item;
                    str = woolCarpetBlock.getColor();
                } else {
                    str = null;
                }
                if (str != null) {
                    return str.getName();
                }
            }
            if (entity instanceof Cat) {
                Cat cat = (Cat)entity;
                return cat.getCollarColor().getName();
            }
            if (entity instanceof Shulker && (str = (shulker = (Shulker)entity).getColor()) != null) {
                return str.getName();
            }
            ETFEntity eTFEntity = entity;
            Objects.requireNonNull(eTFEntity);
            ETFEntity eTFEntity2 = eTFEntity;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Wolf.class, Sheep.class, TropicalFish.class}, (Object)eTFEntity2, n)) {
                case 0 -> {
                    Wolf wolf = (Wolf)eTFEntity2;
                    yield wolf.getCollarColor().getName();
                }
                case 1 -> {
                    Sheep sheep = (Sheep)eTFEntity2;
                    yield sheep.getColor().getName();
                }
                case 2 -> {
                    TropicalFish fishy = (TropicalFish)eTFEntity2;
                    yield fishy.getBaseColor().getName();
                }
                default -> null;
            };
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"colors", "collarColors"};
    }
}

