/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFSprite {
    public final boolean isETFAltered;
    private final TextureAtlasSprite sprite;
    private final TextureAtlasSprite emissiveSprite;

    public ETFSprite(@NotNull TextureAtlasSprite originalSprite, @NotNull ETFTexture etfTexture, boolean isNotVariant) {
        Optional resource;
        ResourceLocation emissiveId;
        SpriteContents contents;
        if (isNotVariant) {
            this.sprite = originalSprite;
            this.isETFAltered = false;
        } else {
            ResourceLocation variantId = etfTexture.getTextureIdentifier(null);
            Optional resource2 = Minecraft.m_91087_().m_91098_().m_213713_(variantId);
            if (resource2.isPresent()) {
                TextureAtlasSprite possibleVariant = null;
                contents = ETFSprite.load(ETFUtils2.res(String.valueOf(variantId) + "-etf_sprite"), (Resource)resource2.get());
                try {
                    if (contents != null) {
                        possibleVariant = new TextureAtlasSprite(variantId, contents, contents.m_246492_(), contents.m_245330_(), 0, 0);
                    }
                }
                finally {
                    if (contents != null) {
                        contents.close();
                    }
                }
                this.sprite = Objects.requireNonNullElse(possibleVariant, originalSprite);
                this.isETFAltered = possibleVariant != null;
            } else {
                this.sprite = originalSprite;
                this.isETFAltered = false;
            }
        }
        TextureAtlasSprite possibleEmissive = null;
        if (etfTexture.eSuffix != null && (emissiveId = etfTexture.getEmissiveIdentifierOfCurrentState()) != null && (resource = Minecraft.m_91087_().m_91098_().m_213713_(emissiveId)).isPresent()) {
            contents = ETFSprite.load(ETFUtils2.res(String.valueOf(emissiveId) + "-etf_sprite"), (Resource)resource.get());
            try {
                if (contents != null) {
                    possibleEmissive = new TextureAtlasSprite(emissiveId, contents, contents.m_246492_(), contents.m_245330_(), 0, 0);
                }
            }
            finally {
                if (contents != null) {
                    contents.close();
                }
            }
        }
        this.emissiveSprite = possibleEmissive;
    }

    @Nullable
    public static SpriteContents load(ResourceLocation id, Resource resource) {
        NativeImage nativeImage;
        ResourceMetadata animationResourceMetadata;
        try {
            animationResourceMetadata = resource.m_215509_();
        }
        catch (Exception var8) {
            return null;
        }
        try (InputStream inputStream = resource.m_215507_();){
            nativeImage = NativeImage.m_85058_((InputStream)inputStream);
        }
        catch (IOException var10) {
            return null;
        }
        FrameSize spriteDimensions = new FrameSize(nativeImage.m_84982_(), nativeImage.m_85084_());
        if (Mth.m_264612_((int)nativeImage.m_84982_(), (int)spriteDimensions.f_244129_()) && Mth.m_264612_((int)nativeImage.m_85084_(), (int)spriteDimensions.f_244503_())) {
            return new SpriteContents(id, spriteDimensions, nativeImage, animationResourceMetadata);
        }
        nativeImage.close();
        return null;
    }

    @NotNull
    public TextureAtlasSprite getEmissive() {
        return this.emissiveSprite;
    }

    public boolean isEmissive() {
        return this.emissiveSprite != null;
    }

    @NotNull
    public TextureAtlasSprite getSpriteVariant() {
        return this.sprite;
    }
}

