/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import com.demonwav.mcdev.annotations.Translatable;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import traben.entity_texture_features.ETF;
import traben.tconfig.gui.TConfigEntryListWidget;
import traben.tconfig.gui.TConfigScreen;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigScreenList
extends TConfigScreen {
    private final TConfigEntry[] options;
    private final Align align;
    protected boolean fullWidthBackgroundEvenIfSmaller = false;
    private Renderable renderFeature = null;
    private TConfigEntryListWidget list;
    private final EditBox search;

    public TConfigScreenList(@Translatable String title, Screen parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges, Align align) {
        super(title, parent, true);
        this.options = options;
        this.parent = parent;
        this.resetDefaultValuesRunnable = resetValuesToDefault;
        this.undoChangesRunnable = undoChanges;
        this.align = align;
        if (options.length > 12) {
            this.search = new EditBox(Minecraft.m_91087_().f_91062_, 4, 0, 120, 20, (Component)Component.m_237113_((String)""));
            this.search.m_94151_(this::updateSearch);
            this.search.m_257771_(ETF.getTextFromTranslation("config.entity_features.search"));
        } else {
            this.search = null;
        }
    }

    public TConfigScreenList(@Translatable String title, Screen parent, TConfigEntry[] options, Runnable resetValuesToDefault, Runnable undoChanges) {
        this(title, parent, options, resetValuesToDefault, undoChanges, Align.CENTER);
    }

    public void setRenderFeature(Renderable renderFeature) {
        this.renderFeature = renderFeature;
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        if (this.renderFeature != null) {
            this.renderFeature.render(context, mouseX, mouseY);
        }
    }

    public void setWidgetBackgroundToFullWidth() {
        this.fullWidthBackgroundEvenIfSmaller = true;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        if (this.search != null) {
            int y = (int)((double)this.f_96544_ * 0.15) - 24;
            int width = (int)((double)this.f_96543_ * 0.2);
            this.search.m_253211_(y);
            this.search.m_93674_(width);
            this.m_142416_((GuiEventListener)this.search);
        }
        this.initList(this.options);
    }

    private void updateSearch(String searchText) {
        assert (this.search != null);
        this.m_169411_((GuiEventListener)this.list);
        ArrayList list = new ArrayList();
        if (searchText.isBlank()) {
            this.initList(this.options);
        } else {
            Arrays.stream(this.options).filter(it -> it.getText().getString().contains(searchText)).forEach(list::add);
            this.initList(list.toArray(new TConfigEntry[0]));
        }
    }

    private void initList(TConfigEntry[] subList) {
        int width;
        this.list = (TConfigEntryListWidget)this.m_142416_((GuiEventListener)new TConfigEntryListWidget(width, (int)((double)this.f_96544_ * 0.7), (int)((double)this.f_96544_ * 0.15), switch (this.align) {
            case Align.LEFT -> {
                width = (int)((double)this.f_96543_ * 0.3);
                yield (int)((double)this.f_96543_ * 0.1);
            }
            case Align.RIGHT -> {
                width = (int)((double)this.f_96543_ * 0.3);
                yield (int)((double)this.f_96543_ * 0.6);
            }
            default -> {
                width = this.f_96543_;
                yield 0;
            }
        }, 24, subList));
    }

    public static interface Renderable {
        public void render(GuiGraphics var1, int var2, int var3);
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

