/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.renderer.feature;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.MushroomCowMushroomLayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

@Mixin(value={MushroomCowMushroomLayer.class})
public abstract class MixinMooshroomMushroomFeatureRenderer {
    @Unique
    private static final ResourceLocation RED_SHROOM = ETFUtils2.res("textures/entity/cow/red_mushroom.png");
    @Unique
    private static final ResourceLocation BROWN_SHROOM = ETFUtils2.res("textures/entity/cow/brown_mushroom.png");
    @Unique
    private static final ModelPart[] entity_texture_features$shroomAsEntityModel = MixinMooshroomMushroomFeatureRenderer.entity_texture_features$getModelData();
    @Unique
    private static ResourceLocation entity_texture_features$redEmissive = null;
    @Unique
    private static ResourceLocation entity_texture_features$brownEmissive = null;

    @Unique
    private static ModelPart[] entity_texture_features$getModelData() {
        CubeDeformation dilation = new CubeDeformation(0.0f);
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("shroom1", CubeListBuilder.create().texOffs(32, 16).addBox(0.0f, 0.0f, 8.0f, 16.0f, 16.0f, 0.0f, dilation), PartPose.ZERO);
        modelPartData.addOrReplaceChild("shroom2", CubeListBuilder.create().texOffs(32, 16).addBox(8.0f, 0.0f, 0.0f, 0.0f, 16.0f, 16.0f, dilation), PartPose.ZERO);
        ModelPart shroom1 = modelData.getRoot().getChild("shroom1").bake(32, 16);
        ModelPart shroom2 = modelData.getRoot().getChild("shroom2").bake(32, 16);
        return new ModelPart[]{shroom1, shroom2};
    }

    @Unique
    @Nullable
    private static Boolean entity_texture_features$returnRedTrueBrownFalseVanillaNull(BlockState mushroomState) {
        if (ETF.config().getConfig().enableCustomTextures) {
            if (mushroomState.is(Blocks.RED_MUSHROOM)) {
                if (ETFManager.getInstance().mooshroomRedCustomShroomExists == null) {
                    ETFManager.getInstance().mooshroomRedCustomShroomExists = Minecraft.getInstance().getResourceManager().getResource(RED_SHROOM).isPresent() ? MixinMooshroomMushroomFeatureRenderer.entity_texture_features$prepareMushroomTextures(true) : Boolean.valueOf(false);
                }
                return ETFManager.getInstance().mooshroomRedCustomShroomExists;
            }
            if (mushroomState.is(Blocks.BROWN_MUSHROOM)) {
                if (ETFManager.getInstance().mooshroomBrownCustomShroomExists == null) {
                    ETFManager.getInstance().mooshroomBrownCustomShroomExists = Minecraft.getInstance().getResourceManager().getResource(BROWN_SHROOM).isPresent() ? MixinMooshroomMushroomFeatureRenderer.entity_texture_features$prepareMushroomTextures(false) : Boolean.valueOf(false);
                }
                return ETFManager.getInstance().mooshroomBrownCustomShroomExists;
            }
        }
        return null;
    }

    @Unique
    @NotNull
    private static Boolean entity_texture_features$prepareMushroomTextures(boolean isRed) {
        Boolean bool = MixinMooshroomMushroomFeatureRenderer.entity_texture_features$prepareMushroomTextures(isRed, false);
        return bool != null && bool != false;
    }

    @Unique
    @Nullable
    private static Boolean entity_texture_features$prepareMushroomTextures(boolean isRed, boolean doingEmissive) {
        NativeImage originalImagePreFlip;
        ResourceLocation idOfOriginal = isRed ? RED_SHROOM : BROWN_SHROOM;
        String suffix = null;
        if (doingEmissive) {
            boolean found = false;
            for (String str : ETFManager.getInstance().EMISSIVE_SUFFIX_LIST) {
                ResourceLocation test = ETFUtils2.res(idOfOriginal.toString().replace(".png", str + ".png"));
                if (!Minecraft.getInstance().getResourceManager().getResource(test).isPresent()) continue;
                suffix = str;
                idOfOriginal = test;
                found = true;
                break;
            }
            if (!found) {
                return null;
            }
        }
        if ((originalImagePreFlip = ETFUtils2.getNativeImageElseNull(idOfOriginal)) != null) {
            try {
                ResourceLocation idOfNew;
                NativeImage newImage;
                try (NativeImage flippedOriginalImage = ETFUtils2.emptyNativeImage(originalImagePreFlip.getWidth(), originalImagePreFlip.getHeight());){
                    int y;
                    int x;
                    for (x = 0; x < flippedOriginalImage.getWidth(); ++x) {
                        for (y = 0; y < flippedOriginalImage.getHeight(); ++y) {
                            ETFUtils2.setPixel(flippedOriginalImage, x, y, ETFUtils2.getPixel(originalImagePreFlip, x, originalImagePreFlip.getHeight() - 1 - y));
                        }
                    }
                    newImage = ETFUtils2.emptyNativeImage(flippedOriginalImage.getWidth() * 2, flippedOriginalImage.getHeight());
                    for (x = 0; x < newImage.getWidth(); ++x) {
                        for (y = 0; y < newImage.getHeight(); ++y) {
                            if (x < flippedOriginalImage.getWidth()) {
                                ETFUtils2.setPixel(newImage, x, y, ETFUtils2.getPixel(flippedOriginalImage, x, y));
                                continue;
                            }
                            ETFUtils2.setPixel(newImage, x, y, ETFUtils2.getPixel(flippedOriginalImage, flippedOriginalImage.getWidth() - 1 - (x - flippedOriginalImage.getWidth()), y));
                        }
                    }
                }
                ResourceLocation resourceLocation = idOfNew = isRed ? ETFUtils2.res("etf", "red_shroom_alt.png") : ETFUtils2.res("etf", "brown_shroom_alt.png");
                if (doingEmissive && suffix != null) {
                    ResourceLocation emissive = ETFUtils2.res(idOfNew.toString().replace(".png", suffix + ".png"));
                    ETFUtils2.registerNativeImageToIdentifier(newImage, emissive);
                    if (isRed) {
                        entity_texture_features$redEmissive = emissive;
                    } else {
                        entity_texture_features$brownEmissive = emissive;
                    }
                } else {
                    ETFUtils2.registerNativeImageToIdentifier(newImage, idOfNew);
                }
                if (!doingEmissive) {
                    MixinMooshroomMushroomFeatureRenderer.entity_texture_features$prepareMushroomTextures(isRed, true);
                    if (isRed) {
                        ETFManager.getInstance().redMooshroomAlt = ETFTexture.ofUnmodifiable(idOfNew, entity_texture_features$redEmissive);
                    } else {
                        ETFManager.getInstance().brownMooshroomAlt = ETFTexture.ofUnmodifiable(idOfNew, entity_texture_features$brownEmissive);
                    }
                }
                return isRed;
            }
            catch (Exception e) {
                ETFUtils2.logError("Mooshroom custom mushroom texture could not be loaded. " + String.valueOf(e));
            }
        }
        return null;
    }

    @Inject(method={"renderMushroomBlock(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IZLnet/minecraft/world/level/block/state/BlockState;ILnet/minecraft/client/resources/model/BakedModel;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void etf$injected(PoseStack matrices, MultiBufferSource vertexConsumers, int light, boolean renderAsModel, BlockState mushroomState, int overlay, BakedModel mushroomModel, CallbackInfo ci) {
        Boolean shroomType = MixinMooshroomMushroomFeatureRenderer.entity_texture_features$returnRedTrueBrownFalseVanillaNull(mushroomState);
        if (shroomType != null) {
            ETFTexture thisTexture;
            ETFTexture eTFTexture = thisTexture = shroomType != false ? ETFManager.getInstance().redMooshroomAlt : ETFManager.getInstance().brownMooshroomAlt;
            if (thisTexture != null) {
                for (ModelPart model : entity_texture_features$shroomAsEntityModel) {
                    VertexConsumer texturedConsumer = vertexConsumers.getBuffer(RenderType.entityCutout((ResourceLocation)thisTexture.thisIdentifier));
                    model.render(matrices, texturedConsumer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    thisTexture.renderEmissive(matrices, vertexConsumers, model);
                }
                ci.cancel();
            }
        }
    }
}

