/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.texture_handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.texture_handlers.ETFTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFArmorHandler {
    private ETFTexture trimTexture = null;

    public void start() {
        ETFRenderContext.allowTexturePatching();
    }

    public void end() {
        ETFRenderContext.preventTexturePatching();
    }

    public void renderTrimEmissive(PoseStack matrices, MultiBufferSource vertexConsumers, Model model) {
        ResourceLocation emissive;
        if (this.trimTexture != null && ETF.config().getConfig().canDoEmissiveTextures() && (emissive = this.trimTexture.getEmissiveIdentifierOfCurrentState()) != null) {
            ETFRenderContext.startSpecialRenderOverlayPhase();
            VertexConsumer textureVert = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)emissive));
            matrices.scale(1.001f, 1.001f, 1.001f);
            model.renderToBuffer(matrices, textureVert, 0xF000F2, OverlayTexture.NO_OVERLAY);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
        this.trimTexture = null;
    }

    public void setTrim(ResourceLocation trimBaseId) {
        if (ETF.config().getConfig().enableArmorAndTrims) {
            ResourceLocation trimMaterialIdentifier = ETFUtils2.res(trimBaseId.getNamespace(), "textures/" + trimBaseId.getPath() + ".png");
            ETFTexture trim = ETFManager.getInstance().getETFTextureNoVariation(trimMaterialIdentifier);
            if (trim.isEmissive()) {
                this.trimTexture = trim;
            }
        }
    }
}

