/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFUtils2;

public class BiomeTagProperty
extends RandomProperty {
    private final String input;
    private final List<class_2960> tagsList;
    private final boolean print;

    protected BiomeTagProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        this.input = RandomProperty.readPropertiesOrThrow(properties, propertyNum, "biomeTag", "biomeTags");
        this.print = this.input.startsWith("print:");
        this.tagsList = Arrays.stream(this.input.replaceFirst("^print:", "").split("\\s+")).map(ETFUtils2::res).collect(Collectors.toCollection(ArrayList::new));
    }

    public static BiomeTagProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new BiomeTagProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    protected boolean testEntityInternal(ETFEntityRenderState entity) {
        if (entity == null) {
            return this.fail();
        }
        class_1937 level = entity.world();
        if (level == null) {
            return this.fail();
        }
        class_6880 biome = level.method_23753(entity.blockPos());
        if (biome == null) {
            return this.fail();
        }
        Stream tagStream = biome.method_40228();
        return tagStream.map(tag -> {
            class_2960 loc = tag.comp_327();
            if (this.print) {
                ETFUtils2.logMessage("BiomeTagProperty: " + this.input + " found tag: " + String.valueOf(loc));
            }
            return loc;
        }).anyMatch(this.tagsList::contains);
    }

    private boolean fail() {
        if (this.print) {
            ETFUtils2.logMessage("BiomeTagProperty: " + this.input + " failed to read entity");
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"biomeTag", "biomeTags"};
    }

    @Override
    protected String getPrintableRuleInfo() {
        return "biomeTag=" + this.input;
    }
}

