/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.mixin.mixins.entity.renderer.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.stream.Stream;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ParrotOnShoulderLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ParrotRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.features.state.HoldsETFRenderState;
import traben.entity_texture_features.utils.ETFEntity;

@Mixin(value={ParrotOnShoulderLayer.class})
public abstract class MixinShoulderParrotFeatureRenderer
extends RenderLayer<PlayerRenderState, PlayerModel> {
    @Unique
    private ETFEntityRenderState etf$heldEntity = null;
    @Shadow
    @Final
    private ParrotRenderState parrotState;

    public MixinShoulderParrotFeatureRenderer(RenderLayerParent<PlayerRenderState, PlayerModel> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="HEAD")})
    private void etf$alterEntityLeft(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, PlayerRenderState playerRenderState, float f, float g, CallbackInfo ci) {
        ETFEntity eTFEntity;
        this.etf$heldEntity = ETFRenderContext.getCurrentEntityState();
        if (this.etf$heldEntity != null && (eTFEntity = this.etf$heldEntity.entity()) instanceof Player) {
            Player playerEntity = (Player)eTFEntity;
            this.etf$setParrotAsCurrentEntity(playerEntity, playerEntity.getShoulderEntityLeft());
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/layers/ParrotOnShoulderLayer;renderOnShoulder(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;Lnet/minecraft/world/entity/animal/Parrot$Variant;FFZ)V", shift=At.Shift.AFTER, ordinal=0)})
    private void etf$alterEntityRight(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, PlayerRenderState playerRenderState, float f, float g, CallbackInfo ci) {
        ETFEntity eTFEntity;
        this.etf$heldEntity = ETFRenderContext.getCurrentEntityState();
        if (this.etf$heldEntity != null && (eTFEntity = this.etf$heldEntity.entity()) instanceof Player) {
            Player playerEntity = (Player)eTFEntity;
            this.etf$setParrotAsCurrentEntity(playerEntity, playerEntity.getShoulderEntityRight());
        }
    }

    @Unique
    private void etf$setParrotAsCurrentEntity(Player playerEntity, CompoundTag nbtCompound) {
        if (nbtCompound != null) {
            try {
                Parrot optionalEntity = (Parrot)EntityType.PARROT.create(playerEntity.level(), EntitySpawnReason.COMMAND);
                if (optionalEntity instanceof Parrot) {
                    Parrot parrot = optionalEntity;
                    ValueInput valueInput = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)HolderLookup.Provider.create(Stream.empty()), (CompoundTag)nbtCompound);
                    optionalEntity.load(valueInput);
                    ETFRenderContext.setCurrentEntity(ETFEntityRenderState.forEntity((ETFEntity)parrot));
                    ((HoldsETFRenderState)this.parrotState).etf$initState((ETFEntity)parrot);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Inject(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, at={@At(value="RETURN")})
    private void etf$resetEntity(CallbackInfo ci) {
        if (this.etf$heldEntity != null) {
            ETFRenderContext.setCurrentEntity(this.etf$heldEntity);
        }
        this.etf$heldEntity = null;
    }
}

