/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens.skin;

import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.mixin.mixins.accessor.TooltipAccessor;
import traben.tconfig.gui.TConfigScreen;

public abstract class ETFScreenOldCompat
extends TConfigScreen {
    protected ETFScreenOldCompat(String title, Screen parent, boolean showBackButton) {
        super(title, parent, showBackButton);
    }

    public static void renderGUITexture(GuiGraphics context, ResourceLocation texture, double x1, double y1, double x2, double y2) {
        context.blit(RenderType::guiTextured, texture, (int)x1, (int)y1, 0.0f, 0.0f, (int)(x2 - x1), (int)(y2 - y1), 1, 1, 1, 1, ARGB.color((int)255, (int)255, (int)255, (int)255));
    }

    public static String booleanAsOnOff(boolean bool) {
        return CommonComponents.optionStatus((boolean)bool).getString();
    }

    public Button getETFButton(int x, int y, int width, int height, Component buttonText, Button.OnPress onPress) {
        return this.getETFButton(x, y, width, height, buttonText, onPress, Component.nullToEmpty((String)""));
    }

    public Button getETFButton(int x, int y, int width, int height, Component buttonText, Button.OnPress onPress, Component toolTipText) {
        int nudgeLeftEdge;
        if (width > 384) {
            nudgeLeftEdge = (width - 384) / 2;
            width = 384;
        } else {
            nudgeLeftEdge = 0;
        }
        boolean tooltipIsEmpty = toolTipText.getString().isBlank();
        if (tooltipIsEmpty) {
            return Button.builder((Component)buttonText, (Button.OnPress)onPress).bounds(x + nudgeLeftEdge, y, width, height).build();
        }
        Tooltip bob = Tooltip.create((Component)toolTipText);
        if (!ETF.isThisModLoaded("adaptive-tooltips")) {
            String[] strings = toolTipText.getString().split("\n");
            ArrayList<FormattedCharSequence> texts = new ArrayList<FormattedCharSequence>();
            for (String str : strings) {
                texts.add(Component.nullToEmpty((String)str).getVisualOrderText());
            }
            ((TooltipAccessor)bob).setCachedTooltip(texts);
        }
        return Button.builder((Component)buttonText, (Button.OnPress)onPress).bounds(x + nudgeLeftEdge, y, width, height).tooltip(bob).build();
    }
}

