/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.player;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import traben.entity_texture_features.ETF;
import traben.entity_texture_features.config.screens.skin.ETFConfigScreenSkinTool;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.player.ETFPlayerSkinHolder;
import traben.entity_texture_features.features.player.ETFPlayerTexture;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFPlayerFeatureRenderer<T extends AvatarRenderState, M extends PlayerModel>
extends RenderLayer<T, M> {
    protected static final ModelPart villagerNose = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).getRoot().getChild("nose").bake(64, 64);
    protected static final ModelPart textureNose = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).getRoot().getChild("textureNose").bake(8, 8);
    protected static final ModelPart jacket = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).getRoot().getChild("jacket").bake(64, 64);
    protected static final ModelPart fatJacket = ETFPlayerFeatureRenderer.getModelData(new CubeDeformation(0.0f)).getRoot().getChild("fatJacket").bake(64, 64);
    private static final ResourceLocation VILLAGER_TEXTURE = ETFUtils2.res("textures/entity/villager/villager.png");
    protected final ETFPlayerSkinHolder skinHolder;

    public ETFPlayerFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
        ETFPlayerSkinHolder holder;
        this.skinHolder = context instanceof ETFPlayerSkinHolder ? (holder = (ETFPlayerSkinHolder)context) : null;
    }

    public static MeshDefinition getModelData(CubeDeformation dilation) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        modelPartData.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 12.5f, -2.0f, 8.0f, 12.0f, 4.0f, dilation.extend(0.25f)), PartPose.ZERO);
        modelPartData.addOrReplaceChild("fatJacket", CubeListBuilder.create().texOffs(16, 32).addBox(-4.0f, 12.5f, -2.0f, 8.0f, 12.0f, 4.0f, dilation.extend(0.25f).extend(0.5f)), PartPose.ZERO);
        modelPartData.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        modelPartData.addOrReplaceChild("textureNose", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -8.0f, -8.0f, 0.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        return modelData;
    }

    public static void renderSkullFeatures(PoseStack matrixStack, SubmitNodeCollector vertexConsumerProvider, int light, SkullModelBase skullModel, ETFPlayerTexture playerTexture, float yaw) {
        ETFRenderContext.preventRenderLayerTextureModify();
        ETFRenderContext.startSpecialRenderOverlayPhase();
        if (playerTexture.hasVillagerNose || playerTexture.texturedNoseIdentifier != null) {
            ETFPlayerFeatureRenderer.villagerNose.yRot = yaw * ((float)Math.PI / 180);
            ETFPlayerFeatureRenderer.villagerNose.xRot = 0.0f;
            ETFPlayerFeatureRenderer.villagerNose.y = 0.0f;
            ETFPlayerFeatureRenderer.textureNose.yRot = yaw * ((float)Math.PI / 180);
            ETFPlayerFeatureRenderer.textureNose.xRot = 0.0f;
            ETFPlayerFeatureRenderer.textureNose.y = 0.0f;
            ETFPlayerFeatureRenderer.renderNose(matrixStack, vertexConsumerProvider, light, playerTexture);
        }
        ETFPlayerFeatureRenderer.renderEnchanted(matrixStack, vertexConsumerProvider, light, playerTexture, (Model)skullModel);
        ETFRenderContext.endSpecialRenderOverlayPhase();
        ETFRenderContext.allowRenderLayerTextureModify();
    }

    private static void renderEnchanted(PoseStack matrixStack, SubmitNodeCollector submit, int light, ETFPlayerTexture playerTexture, Model model) {
        if (playerTexture.hasEnchant && playerTexture.baseEnchantIdentifier != null && playerTexture.etfTextureOfFinalBaseSkin != null) {
            ETFUtils2.submitEnchantedModelPart(matrixStack, submit, light, model.root(), playerTexture.baseEnchantIdentifier);
        }
    }

    private static void renderNose(PoseStack matrixStack, SubmitNodeCollector submit, int light, ETFPlayerTexture playerTexture) {
        if (playerTexture.hasVillagerNose) {
            if (playerTexture.noseType == ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED || playerTexture.noseType == ETFConfigScreenSkinTool.NoseType.VILLAGER_TEXTURED_REMOVE) {
                RenderType type = RenderType.entityTranslucent((ResourceLocation)playerTexture.etfTextureOfFinalBaseSkin.getTextureIdentifier(null));
                submit.submitModelPart(villagerNose, matrixStack, type, light, OverlayTexture.NO_OVERLAY, null);
                RenderType emissive = playerTexture.etfTextureOfFinalBaseSkin.getEmissiveRenderLayer(null);
                if (emissive != null) {
                    submit.submitModelPart(villagerNose, matrixStack, emissive, 0xF000F2, OverlayTexture.NO_OVERLAY, null);
                }
            } else {
                submit.submitModelPart(villagerNose, matrixStack, RenderType.entitySolid((ResourceLocation)VILLAGER_TEXTURE), light, OverlayTexture.NO_OVERLAY, null);
            }
        } else if (playerTexture.texturedNoseIdentifier != null) {
            ETFUtils2.submitModelPart(matrixStack, submit, light, textureNose, playerTexture.texturedNoseIdentifier, playerTexture.texturedNoseIdentifierEmissive, playerTexture.texturedNoseIdentifierEnchanted);
        }
    }

    public void submit(PoseStack matrices, SubmitNodeCollector submit, int light, T entityRenderState, float f, float g) {
        if (ETF.config().getConfig().skinFeaturesEnabled && this.skinHolder != null) {
            ETFRenderContext.preventRenderLayerTextureModify();
            ETFPlayerTexture playerTexture = this.skinHolder.etf$getETFPlayerTexture();
            if (playerTexture != null && playerTexture.hasFeatures) {
                this.renderFeatures(matrices, submit, entityRenderState, light, (PlayerModel)this.getParentModel(), playerTexture);
            }
            ETFRenderContext.allowRenderLayerTextureModify();
        }
    }

    public void renderFeatures(PoseStack matrixStack, SubmitNodeCollector vertexConsumerProvider, T entityRenderState, int light, M model, ETFPlayerTexture playerTexture) {
        if (playerTexture.canUseFeaturesForThisPlayer()) {
            ETFRenderContext.startSpecialRenderOverlayPhase();
            if (playerTexture.hasVillagerNose || playerTexture.texturedNoseIdentifier != null) {
                PartPose head = ((PlayerModel)model).head.storePose();
                villagerNose.loadPose(head);
                textureNose.loadPose(head);
                ETFPlayerFeatureRenderer.renderNose(matrixStack, vertexConsumerProvider, light, playerTexture);
            }
            this.renderCoat(matrixStack, vertexConsumerProvider, entityRenderState, light, playerTexture, model);
            ETFRenderContext.endSpecialRenderOverlayPhase();
        }
    }

    private void renderCoat(PoseStack matrixStack, SubmitNodeCollector submit, T entityRenderState, int light, ETFPlayerTexture playerTexture, M model) {
        ItemStack armour = playerTexture.player.etf$getInventory().getItem(EquipmentSlot.LEGS.getIndex(36));
        if (playerTexture.coatIdentifier != null && ((AvatarRenderState)entityRenderState).showJacket && !armour.is(ItemTags.LEG_ARMOR)) {
            ModelPart part = playerTexture.hasFatCoat ? fatJacket : jacket;
            part.loadPose(((PlayerModel)model).jacket.storePose());
            ETFUtils2.submitModelPart(matrixStack, submit, light, part, playerTexture.coatIdentifier, playerTexture.coatEmissiveIdentifier, playerTexture.coatEnchantedIdentifier);
        }
    }
}

