/*
 * Decompiled with CFR 0.152.
 */
package traben.tconfig.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import org.jetbrains.annotations.Nullable;
import traben.tconfig.gui.entries.TConfigEntry;

public class TConfigEntryListWidget
extends AbstractSelectionList<TConfigEntryForList> {
    protected boolean fullWidthBackgroundEvenIfSmaller = false;

    public TConfigEntryListWidget(int width, int height, int y, int x, int itemHeight, TConfigEntry ... entries) {
        super(Minecraft.getInstance(), width, height, y, itemHeight);
        for (TConfigEntry option : entries) {
            if (option == null || option.getWidget(0, 0, 0, 0) == null) continue;
            this.addEntry(option);
        }
        this.setX(x);
    }

    public int getRowWidth() {
        return Math.min(this.width - 14, super.getRowWidth());
    }

    protected int scrollBarX() {
        return this.getX() == 0 ? super.scrollBarX() : this.getX() + this.getRowWidth() + 4;
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }

    protected boolean isValidClickButton(MouseButtonInfo mouseButtonInfo) {
        return true;
    }

    public void setSelected(@Nullable TConfigEntryForList entry) {
    }

    public void setWidgetBackgroundToFullWidth() {
        this.fullWidthBackgroundEvenIfSmaller = true;
    }

    protected void renderListBackground(GuiGraphics context) {
        if (this.fullWidthBackgroundEvenIfSmaller) {
            int x = this.getX();
            int width = this.getWidth();
            this.setX(0);
            assert (Minecraft.getInstance().screen != null);
            this.setWidth(Minecraft.getInstance().screen.width);
            super.renderListBackground(context);
            this.setX(x);
            this.setWidth(width);
        } else {
            super.renderListBackground(context);
        }
    }

    protected void renderListSeparators(GuiGraphics context) {
        if (this.fullWidthBackgroundEvenIfSmaller) {
            int x = this.getX();
            int width = this.getWidth();
            this.setX(0);
            assert (Minecraft.getInstance().screen != null);
            this.setWidth(Minecraft.getInstance().screen.width);
            super.renderListSeparators(context);
            this.setX(x);
            this.setWidth(width);
        } else {
            super.renderListSeparators(context);
        }
    }

    public static abstract class TConfigEntryForList
    extends AbstractSelectionList.Entry<TConfigEntryForList> {
        @Nullable
        protected AbstractWidget lastWidgetRendered = null;

        public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
            this.lastWidgetRendered = this.getWidget(this.getContentX(), this.getContentY(), this.getContentWidth(), this.getContentHeight());
            if (this.lastWidgetRendered != null) {
                this.lastWidgetRendered.render(guiGraphics, i, j, f);
            }
        }

        public abstract AbstractWidget getWidget(int var1, int var2, int var3, int var4);

        private boolean ignoreMouseAt(double mouseX, double mouseY) {
            return this.lastWidgetRendered == null || !this.lastWidgetRendered.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
            if (this.ignoreMouseAt(mouseButtonEvent.x(), mouseButtonEvent.y())) {
                return false;
            }
            return this.lastWidgetRendered.mouseClicked(mouseButtonEvent, bl);
        }

        public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double d, double e) {
            if (this.ignoreMouseAt(mouseButtonEvent.x(), mouseButtonEvent.y())) {
                return false;
            }
            return this.lastWidgetRendered.mouseDragged(mouseButtonEvent, d, e);
        }

        public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
            if (this.ignoreMouseAt(mouseButtonEvent.x(), mouseButtonEvent.y())) {
                return false;
            }
            return this.lastWidgetRendered.mouseReleased(mouseButtonEvent);
        }

        public void setFocused(boolean focused) {
            if (this.lastWidgetRendered == null) {
                return;
            }
            this.lastWidgetRendered.setFocused(focused);
        }
    }
}

