/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.lifesteal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Lifesteal
extends JavaPlugin
implements Listener {
    private FileConfiguration dataConfig;
    private File dataFile;
    private final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private final Map<UUID, UUID> pendingRequests = new HashMap<UUID, UUID>();
    private final Map<UUID, Trade> activeTrades = new HashMap<UUID, Trade>();
    private final Map<UUID, Long> giveCooldowns = new HashMap<UUID, Long>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.setupDataFile();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, this::saveAllPlayerData, 6000L, 6000L);
        Bukkit.getOnlinePlayers().forEach(this::updatePlayerMaxHealth);
    }

    private void setupDataFile() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            this.dataFile.getParentFile().mkdirs();
            this.saveResource("data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        if (this.dataConfig.contains("players")) {
            for (String key : this.dataConfig.getConfigurationSection("players").getKeys(false)) {
                UUID uuid = UUID.fromString(key);
                int hearts = this.dataConfig.getInt("players." + key + ".hearts");
                int withdrawn = this.dataConfig.getInt("players." + key + ".withdrawn", 0);
                int consumed = this.dataConfig.getInt("players." + key + ".consumed", 0);
                this.playerDataMap.put(uuid, new PlayerData(hearts, withdrawn, consumed));
            }
        }
    }

    private void saveAllPlayerData() {
        for (Map.Entry<UUID, PlayerData> entry : this.playerDataMap.entrySet()) {
            this.dataConfig.set("players." + entry.getKey().toString() + ".hearts", (Object)entry.getValue().hearts);
            this.dataConfig.set("players." + entry.getKey().toString() + ".withdrawn", (Object)entry.getValue().withdrawn);
            this.dataConfig.set("players." + entry.getKey().toString() + ".consumed", (Object)entry.getValue().consumed);
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save player data: " + e.getMessage());
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.playerDataMap.containsKey(uuid)) {
            this.playerDataMap.put(uuid, new PlayerData(this.getConfig().getInt("default-hearts", 10), 0, 0));
        }
        this.updatePlayerMaxHealth(player);
    }

    private void updatePlayerMaxHealth(Player player) {
        UUID uuid = player.getUniqueId();
        if (!this.playerDataMap.containsKey(uuid)) {
            return;
        }
        int hearts = this.playerDataMap.get((Object)uuid).hearts;
        double maxHealth = (double)hearts * 2.0;
        Objects.requireNonNull(player.getAttribute(Attribute.MAX_HEALTH)).setBaseValue(maxHealth);
        if (player.getHealth() > maxHealth) {
            player.setHealth(maxHealth);
        }
    }

    private ItemStack createHeartItem() {
        ItemStack heart = new ItemStack(Material.ENCHANTED_GOLDEN_APPLE);
        ItemMeta meta = heart.getItemMeta();
        meta.setDisplayName(String.valueOf(ChatColor.RED) + "Heart");
        meta.setLore(Arrays.asList(String.valueOf(ChatColor.GRAY) + "Right or left-click to consume", String.valueOf(ChatColor.GRAY) + "Max health increased by 1"));
        meta.addEnchant(Enchantment.UNBREAKING, 1, true);
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        pdc.set(new NamespacedKey((Plugin)this, "lifesteal_heart"), PersistentDataType.INTEGER, (Object)1);
        heart.setItemMeta(meta);
        return heart;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || item.getType() != Material.ENCHANTED_GOLDEN_APPLE) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        if (!pdc.has(new NamespacedKey((Plugin)this, "lifesteal_heart"), PersistentDataType.INTEGER)) {
            return;
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        int maxHearts = this.getConfig().getInt("max-hearts", 20);
        if (data.hearts >= maxHearts) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You've reached the maximum heart limit!");
            return;
        }
        ++data.hearts;
        ++data.consumed;
        item.setAmount(item.getAmount() - 1);
        player.getWorld().spawnParticle(Particle.HEART, player.getLocation().add(0.0, 1.0, 0.0), 10);
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Your max health has increased!");
        this.updatePlayerMaxHealth(player);
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.ENCHANTED_GOLDEN_APPLE) {
            event.setCancelled(true);
            this.onPlayerInteract(new PlayerInteractEvent(player, Action.RIGHT_CLICK_AIR, item, null, null));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        boolean isVoidDeath;
        Player player = event.getEntity();
        UUID uuid = player.getUniqueId();
        PlayerData data = this.playerDataMap.get(uuid);
        List enabledWorlds = this.getConfig().getStringList("enabled-worlds");
        if (!enabledWorlds.isEmpty() && !enabledWorlds.contains(player.getWorld().getName())) {
            return;
        }
        String loseHeartsSetting = this.getConfig().getString("lose-hearts", "pvp");
        boolean shouldLoseHeart = false;
        if (loseHeartsSetting.equalsIgnoreCase("true")) {
            shouldLoseHeart = true;
        } else if (loseHeartsSetting.equalsIgnoreCase("pvp") && player.getKiller() != null) {
            shouldLoseHeart = true;
        }
        boolean bl = isVoidDeath = player.getLocation().getY() < -64.0;
        if (shouldLoseHeart && !isVoidDeath && data.hearts > 1) {
            --data.hearts;
            if (player.getKiller() != null) {
                ItemStack heart = this.createHeartItem();
                player.getWorld().dropItemNaturally(player.getLocation(), heart);
                player.sendMessage(String.valueOf(ChatColor.RED) + "You lost a heart!");
            }
            if (data.hearts < 1) {
                player.sendMessage(String.valueOf(ChatColor.DARK_RED) + "You've been eliminated!");
                Bukkit.getScheduler().runTask((Plugin)this, () -> {
                    player.setGameMode(GameMode.SPECTATOR);
                    player.playSound(player.getLocation(), Sound.ENTITY_WITHER_DEATH, 1.0f, 1.0f);
                });
            }
            this.updatePlayerMaxHealth(player);
        }
    }

    @EventHandler
    public void onPrepareItemCraft(PrepareItemCraftEvent event) {
        for (ItemStack item : event.getInventory().getContents()) {
            if (item == null || item.getType() != Material.ENCHANTED_GOLDEN_APPLE) continue;
            event.getInventory().setResult(null);
            break;
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        for (ItemStack item : event.getInventory().getContents()) {
            if (item == null || item.getType() != Material.ENCHANTED_GOLDEN_APPLE) continue;
            event.setResult(null);
            break;
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        List<ItemStack> ownOffer;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        if (inv.getSize() != 54 || !event.getView().getTitle().startsWith("Trade with ")) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot >= 54) {
            return;
        }
        Trade trade = null;
        for (Map.Entry<UUID, Trade> entry : this.activeTrades.entrySet()) {
            if (entry.getValue().initInv != inv && entry.getValue().partInv != inv) continue;
            trade = entry.getValue();
            break;
        }
        if (trade == null) {
            return;
        }
        UUID pUUID = player.getUniqueId();
        boolean isInitiator = pUUID.equals(trade.initiator);
        List<Integer> ownSlots = isInitiator ? trade.initSlots : trade.partSlots;
        List<Integer> otherSlots = isInitiator ? trade.partSlots : trade.initSlots;
        List<ItemStack> list = ownOffer = isInitiator ? trade.initOffer : trade.partOffer;
        if (slot == 0) {
            this.cancelTrade(trade, player.getName() + " declined the trade.");
            return;
        }
        if (slot == 8) {
            if (isInitiator) {
                trade.initAccepted = true;
            } else {
                trade.partAccepted = true;
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You accepted the trade. Waiting for " + (isInitiator ? trade.partName : trade.initName));
            trade.updateInventories();
            if (trade.initAccepted && trade.partAccepted) {
                this.completeTrade(trade);
            }
            return;
        }
        if (!ownSlots.contains(slot)) {
            if (otherSlots.contains(slot)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You can't take other player's items!");
            }
            return;
        }
        ItemStack cursor = event.getCursor();
        ItemStack current = event.getCurrentItem();
        int index = ownSlots.indexOf(slot);
        boolean changed = false;
        if (cursor == null || cursor.getType() == Material.AIR) {
            if (current != null && current.getType() != Material.AIR) {
                player.setItemOnCursor(current.clone());
                ownOffer.set(index, null);
                changed = true;
            }
        } else if (current == null || current.getType() == Material.AIR) {
            ItemStack toPlace = cursor.clone();
            ownOffer.set(index, toPlace);
            player.setItemOnCursor(null);
            changed = true;
        } else {
            ItemStack temp = current.clone();
            ownOffer.set(index, cursor.clone());
            player.setItemOnCursor(temp);
            changed = true;
        }
        if (changed) {
            if (isInitiator) {
                trade.initAccepted = false;
            } else {
                trade.partAccepted = false;
            }
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your accept status has been reset due to changes.");
            trade.updateInventories();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Inventory inv = event.getInventory();
        if (inv.getSize() != 54 || !event.getView().getTitle().startsWith("Trade with ")) {
            return;
        }
        Trade trade = null;
        for (Map.Entry<UUID, Trade> entry : this.activeTrades.entrySet()) {
            if (entry.getValue().initInv != inv && entry.getValue().partInv != inv) continue;
            trade = entry.getValue();
            break;
        }
        if (trade == null) {
            return;
        }
        UUID key = trade.initiator;
        if (this.activeTrades.containsKey(key)) {
            boolean bothAccepted = trade.initAccepted && trade.partAccepted;
            this.activeTrades.remove(key);
            if (!bothAccepted) {
                Player partP;
                Player initP = Bukkit.getPlayer((UUID)trade.initiator);
                if (initP != null && initP.isOnline() && initP != player) {
                    initP.closeInventory();
                    this.returnItems(trade.initOffer, initP);
                    initP.sendMessage(String.valueOf(ChatColor.RED) + "Trade cancelled.");
                }
                if ((partP = Bukkit.getPlayer((UUID)trade.partner)) != null && partP.isOnline() && partP != player) {
                    partP.closeInventory();
                    this.returnItems(trade.partOffer, partP);
                    partP.sendMessage(String.valueOf(ChatColor.RED) + "Trade cancelled.");
                }
            }
        }
    }

    private void startTrade(Player initP, Player partP) {
        if (this.activeTrades.containsKey(initP.getUniqueId())) {
            initP.sendMessage(String.valueOf(ChatColor.RED) + "You are already in a trade!");
            return;
        }
        Trade trade = new Trade(initP, partP);
        this.activeTrades.put(initP.getUniqueId(), trade);
        initP.openInventory(trade.initInv);
        partP.openInventory(trade.partInv);
        initP.sendMessage(String.valueOf(ChatColor.GREEN) + "Trade started with " + partP.getName());
        partP.sendMessage(String.valueOf(ChatColor.GREEN) + "Trade started with " + initP.getName());
    }

    private void cancelTrade(Trade trade, String reason) {
        Player initP = Bukkit.getPlayer((UUID)trade.initiator);
        Player partP = Bukkit.getPlayer((UUID)trade.partner);
        if (initP != null && initP.isOnline()) {
            initP.closeInventory();
            this.returnItems(trade.initOffer, initP);
        }
        if (partP != null && partP.isOnline()) {
            partP.closeInventory();
            this.returnItems(trade.partOffer, partP);
        }
        this.activeTrades.remove(trade.initiator);
        if (initP != null && initP.isOnline()) {
            initP.sendMessage(String.valueOf(ChatColor.RED) + "Trade cancelled: " + reason);
        }
        if (partP != null && partP.isOnline()) {
            partP.sendMessage(String.valueOf(ChatColor.RED) + "Trade cancelled: " + reason);
        }
    }

    private void completeTrade(Trade trade) {
        Player initP = Bukkit.getPlayer((UUID)trade.initiator);
        Player partP = Bukkit.getPlayer((UUID)trade.partner);
        if (initP == null || !initP.isOnline() || partP == null || !partP.isOnline()) {
            this.cancelTrade(trade, "Player went offline.");
            return;
        }
        ArrayList<ItemStack> toGiveInit = new ArrayList<ItemStack>();
        for (ItemStack is : trade.partOffer) {
            if (is == null) continue;
            toGiveInit.add(is);
        }
        if (!toGiveInit.isEmpty()) {
            ItemStack[] toGiveArray = toGiveInit.toArray(new ItemStack[0]);
            HashMap leftovers = initP.getInventory().addItem(toGiveArray);
            for (ItemStack leftover : leftovers.values()) {
                initP.getWorld().dropItemNaturally(initP.getLocation(), leftover);
            }
        }
        ArrayList<ItemStack> toGivePart = new ArrayList<ItemStack>();
        for (ItemStack is : trade.initOffer) {
            if (is == null) continue;
            toGivePart.add(is);
        }
        if (!toGivePart.isEmpty()) {
            ItemStack[] toGiveArray = toGivePart.toArray(new ItemStack[0]);
            HashMap leftovers = partP.getInventory().addItem(toGiveArray);
            for (ItemStack leftover : leftovers.values()) {
                partP.getWorld().dropItemNaturally(partP.getLocation(), leftover);
            }
        }
        initP.closeInventory();
        partP.closeInventory();
        initP.sendMessage(String.valueOf(ChatColor.GREEN) + "Trade completed successfully!");
        partP.sendMessage(String.valueOf(ChatColor.GREEN) + "Trade completed successfully!");
        this.activeTrades.remove(trade.initiator);
    }

    private void returnItems(List<ItemStack> offer, Player p) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (ItemStack is : offer) {
            if (is == null) continue;
            toReturn.add(is);
        }
        if (!toReturn.isEmpty()) {
            ItemStack[] arr = toReturn.toArray(new ItemStack[0]);
            HashMap rem = p.getInventory().addItem(arr);
            for (ItemStack it : rem.values()) {
                p.getWorld().dropItemNaturally(p.getLocation(), it);
            }
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("withdraw")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                return true;
            }
            Player player = (Player)sender;
            UUID uuid = player.getUniqueId();
            PlayerData data = this.playerDataMap.get(uuid);
            if (data.hearts <= 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "You must keep at least 1 heart!");
                return true;
            }
            int amount = 1;
            if (args.length > 0) {
                try {
                    amount = Integer.parseInt(args[0]);
                    if (amount < 1) {
                        amount = 1;
                    }
                    if (amount > data.hearts - 1) {
                        amount = data.hearts - 1;
                    }
                }
                catch (NumberFormatException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount!");
                    return true;
                }
            }
            data.hearts -= amount;
            data.withdrawn += amount;
            this.updatePlayerMaxHealth(player);
            for (int i = 0; i < amount; ++i) {
                ItemStack heart = this.createHeartItem();
                HashMap remaining = player.getInventory().addItem(new ItemStack[]{heart});
                if (remaining.isEmpty()) continue;
                for (ItemStack item : remaining.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), item);
                }
            }
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "You've withdrawn " + amount + " heart(s)");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("lifesteal")) {
            if (args.length == 0) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal [reload|give|revive|stats|giveheart|trade]");
                return true;
            }
            switch (args[0].toLowerCase()) {
                case "reload": {
                    if (!sender.hasPermission("lifesteal.admin")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this!");
                        return true;
                    }
                    this.reloadConfig();
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Lifesteal config reloaded!");
                    return true;
                }
                case "give": {
                    int amount;
                    if (!sender.hasPermission("lifesteal.admin")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this!");
                        return true;
                    }
                    if (args.length < 3) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal give <player> <amount>");
                        return true;
                    }
                    Player target = Bukkit.getPlayer((String)args[1]);
                    if (target == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                        return true;
                    }
                    try {
                        amount = Integer.parseInt(args[2]);
                        if (amount < 1) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be at least 1!");
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount!");
                        return true;
                    }
                    for (int i = 0; i < amount; ++i) {
                        ItemStack heart = this.createHeartItem();
                        HashMap remaining = target.getInventory().addItem(new ItemStack[]{heart});
                        if (remaining.isEmpty()) continue;
                        for (ItemStack item : remaining.values()) {
                            target.getWorld().dropItemNaturally(target.getLocation(), item);
                        }
                    }
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Given " + amount + " heart(s) to " + target.getName());
                    target.sendMessage(String.valueOf(ChatColor.GREEN) + "You received " + amount + " heart(s) from " + sender.getName());
                    return true;
                }
                case "revive": {
                    int defaultHearts;
                    if (!sender.hasPermission("lifesteal.admin")) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this!");
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal revive <player>");
                        return true;
                    }
                    Player toRevive = Bukkit.getPlayer((String)args[1]);
                    if (toRevive == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                        return true;
                    }
                    if (toRevive.getGameMode() != GameMode.SPECTATOR) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Player is not eliminated!");
                        return true;
                    }
                    this.playerDataMap.get((Object)toRevive.getUniqueId()).hearts = defaultHearts = this.getConfig().getInt("default-hearts", 10);
                    toRevive.setGameMode(GameMode.SURVIVAL);
                    this.updatePlayerMaxHealth(toRevive);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Revived " + toRevive.getName() + " with " + defaultHearts + " hearts");
                    toRevive.sendMessage(String.valueOf(ChatColor.GREEN) + "You've been revived with " + defaultHearts + " hearts!");
                    toRevive.playSound(toRevive.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                    return true;
                }
                case "stats": {
                    Player toCheck;
                    Player player = toCheck = sender instanceof Player ? (Player)sender : null;
                    if (args.length > 1) {
                        if (!sender.hasPermission("lifesteal.admin")) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this!");
                            return true;
                        }
                        toCheck = Bukkit.getPlayer((String)args[1]);
                        if (toCheck == null) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                            return true;
                        }
                    }
                    if (toCheck == null) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Console must specify a player: /lifesteal stats <player>");
                        return true;
                    }
                    PlayerData statsData = this.playerDataMap.get(toCheck.getUniqueId());
                    sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "---- " + toCheck.getName() + "'s Stats ----");
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Current Hearts: " + String.valueOf(ChatColor.WHITE) + statsData.hearts);
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Max Hearts Allowed: " + String.valueOf(ChatColor.WHITE) + this.getConfig().getInt("max-hearts", 20));
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Hearts Consumed: " + String.valueOf(ChatColor.WHITE) + statsData.consumed);
                    sender.sendMessage(String.valueOf(ChatColor.GOLD) + "Hearts Withdrawn: " + String.valueOf(ChatColor.WHITE) + statsData.withdrawn);
                    return true;
                }
                case "giveheart": {
                    int giveAmount;
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                        return true;
                    }
                    Player giver = (Player)sender;
                    UUID giverUUID = giver.getUniqueId();
                    PlayerData giverData = this.playerDataMap.get(giverUUID);
                    Long lastGive = this.giveCooldowns.get(giverUUID);
                    long now = System.currentTimeMillis();
                    long cooldownTime = 30000L;
                    if (lastGive != null && now - lastGive < cooldownTime) {
                        long remaining = (cooldownTime - (now - lastGive)) / 1000L;
                        giver.sendMessage(String.valueOf(ChatColor.RED) + "You are on cooldown for " + remaining + " seconds!");
                        return true;
                    }
                    if (args.length < 3) {
                        giver.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal giveheart <player> <amount>");
                        return true;
                    }
                    Player giveTarget = Bukkit.getPlayer((String)args[1]);
                    if (giveTarget == null || giveTarget.equals((Object)giver)) {
                        giver.sendMessage(String.valueOf(ChatColor.RED) + "Player not found or cannot give to self!");
                        return true;
                    }
                    try {
                        giveAmount = Integer.parseInt(args[2]);
                        if (giveAmount < 1) {
                            giver.sendMessage(String.valueOf(ChatColor.RED) + "Amount must be at least 1!");
                            return true;
                        }
                    }
                    catch (NumberFormatException e) {
                        giver.sendMessage(String.valueOf(ChatColor.RED) + "Invalid amount!");
                        return true;
                    }
                    if (giverData.hearts <= 1 || giverData.hearts - giveAmount < 1) {
                        giver.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough hearts to gift! Must keep at least 1 heart.");
                        return true;
                    }
                    giverData.hearts -= giveAmount;
                    giverData.withdrawn += giveAmount;
                    this.updatePlayerMaxHealth(giver);
                    for (int i = 0; i < giveAmount; ++i) {
                        ItemStack heart = this.createHeartItem();
                        HashMap remaining = giveTarget.getInventory().addItem(new ItemStack[]{heart});
                        if (remaining.isEmpty()) continue;
                        for (ItemStack item : remaining.values()) {
                            giveTarget.getWorld().dropItemNaturally(giveTarget.getLocation(), item);
                        }
                    }
                    this.giveCooldowns.put(giverUUID, now);
                    giver.sendMessage(String.valueOf(ChatColor.GREEN) + "Gifted " + giveAmount + " heart(s) to " + giveTarget.getName() + " (cost: " + giveAmount + " of your hearts)");
                    giveTarget.sendMessage(String.valueOf(ChatColor.GREEN) + "You received " + giveAmount + " heart(s) from " + giver.getName());
                    return true;
                }
                case "trade": {
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal trade <player> or /lifesteal trade accept");
                        return true;
                    }
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command!");
                        return true;
                    }
                    Player trader = (Player)sender;
                    UUID traderUUID = trader.getUniqueId();
                    if (args[1].equalsIgnoreCase("accept")) {
                        UUID requestorUUID = null;
                        for (Map.Entry<UUID, UUID> entry : this.pendingRequests.entrySet()) {
                            if (!entry.getValue().equals(traderUUID)) continue;
                            requestorUUID = entry.getKey();
                            break;
                        }
                        if (requestorUUID == null) {
                            trader.sendMessage(String.valueOf(ChatColor.RED) + "No pending trade request found.");
                            return true;
                        }
                        this.pendingRequests.remove(requestorUUID);
                        Player requestorPlayer = Bukkit.getPlayer(requestorUUID);
                        if (requestorPlayer == null || !requestorPlayer.isOnline()) {
                            trader.sendMessage(String.valueOf(ChatColor.RED) + "The player who requested the trade is no longer online.");
                            return true;
                        }
                        if (this.activeTrades.containsKey(requestorUUID) || this.activeTrades.containsKey(traderUUID)) {
                            trader.sendMessage(String.valueOf(ChatColor.RED) + "One of the players is already in a trade.");
                            requestorPlayer.sendMessage(String.valueOf(ChatColor.RED) + "Trade could not start as one player is already trading.");
                            return true;
                        }
                        this.startTrade(requestorPlayer, trader);
                        return true;
                    }
                    if (args.length < 2) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /lifesteal trade <player>");
                        return true;
                    }
                    Player tradeTarget = Bukkit.getPlayer((String)args[1]);
                    if (tradeTarget == null || tradeTarget.equals((Object)trader)) {
                        trader.sendMessage(String.valueOf(ChatColor.RED) + "Player not found or cannot trade with self!");
                        return true;
                    }
                    if (this.pendingRequests.containsKey(traderUUID)) {
                        trader.sendMessage(String.valueOf(ChatColor.RED) + "You already have a pending trade request.");
                        return true;
                    }
                    boolean targetRequested = false;
                    for (UUID pendingTarget : this.pendingRequests.values()) {
                        if (!pendingTarget.equals(tradeTarget.getUniqueId())) continue;
                        targetRequested = true;
                        break;
                    }
                    if (targetRequested) {
                        trader.sendMessage(String.valueOf(ChatColor.RED) + "That player already has a pending trade request.");
                        return true;
                    }
                    boolean inTrade = false;
                    for (Trade t : this.activeTrades.values()) {
                        if (!t.initiator.equals(traderUUID) && !t.partner.equals(traderUUID)) continue;
                        inTrade = true;
                        break;
                    }
                    if (inTrade) {
                        trader.sendMessage(String.valueOf(ChatColor.RED) + "You or the target is already in a trade.");
                        return true;
                    }
                    this.pendingRequests.put(traderUUID, tradeTarget.getUniqueId());
                    tradeTarget.sendMessage(String.valueOf(ChatColor.YELLOW) + trader.getName() + " wants to trade with you. Type " + String.valueOf(ChatColor.GREEN) + "/lifesteal trade accept" + String.valueOf(ChatColor.YELLOW) + " to accept.");
                    trader.sendMessage(String.valueOf(ChatColor.GREEN) + "Trade request sent to " + tradeTarget.getName() + ". They can accept with /lifesteal trade accept.");
                    return true;
                }
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand. Use: /lifesteal [reload|give|revive|stats|giveheart|trade]");
            return true;
        }
        return false;
    }

    private static class PlayerData {
        int hearts;
        int withdrawn;
        int consumed;

        PlayerData(int hearts, int withdrawn, int consumed) {
            this.hearts = hearts;
            this.withdrawn = withdrawn;
            this.consumed = consumed;
        }
    }

    private static class Trade {
        UUID initiator;
        UUID partner;
        String initName;
        String partName;
        Inventory initInv;
        Inventory partInv;
        List<Integer> initSlots = new ArrayList<Integer>();
        List<Integer> partSlots = new ArrayList<Integer>();
        List<ItemStack> initOffer;
        List<ItemStack> partOffer;
        boolean initAccepted = false;
        boolean partAccepted = false;

        Trade(Player initP, Player partP) {
            int i;
            this.initiator = initP.getUniqueId();
            this.partner = partP.getUniqueId();
            this.initName = initP.getName();
            this.partName = partP.getName();
            this.initInv = Bukkit.createInventory(null, (int)54, (String)("Trade with " + this.partName));
            this.partInv = Bukkit.createInventory(null, (int)54, (String)("Trade with " + this.initName));
            ItemStack declineItem = new ItemStack(Material.RED_CONCRETE);
            ItemMeta declineMeta = declineItem.getItemMeta();
            declineMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Decline");
            declineItem.setItemMeta(declineMeta);
            ItemStack acceptItem = new ItemStack(Material.GREEN_CONCRETE);
            ItemMeta acceptMeta = acceptItem.getItemMeta();
            acceptMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accept");
            acceptItem.setItemMeta(acceptMeta);
            this.initInv.setItem(0, declineItem);
            this.initInv.setItem(8, acceptItem);
            this.partInv.setItem(0, declineItem.clone());
            this.partInv.setItem(8, acceptItem.clone());
            for (i = 9; i <= 26; ++i) {
                this.initSlots.add(i);
            }
            for (i = 36; i <= 53; ++i) {
                this.partSlots.add(i);
            }
            this.initOffer = new ArrayList<Object>(Collections.nCopies(this.initSlots.size(), null));
            this.partOffer = new ArrayList<Object>(Collections.nCopies(this.partSlots.size(), null));
        }

        void updateInventories() {
            int i;
            int i2;
            for (i2 = 0; i2 < this.initSlots.size(); ++i2) {
                this.initInv.setItem(this.initSlots.get(i2).intValue(), this.initOffer.get(i2));
            }
            for (i2 = 0; i2 < this.partSlots.size(); ++i2) {
                this.initInv.setItem(this.partSlots.get(i2).intValue(), this.partOffer.get(i2));
            }
            ItemStack initAccept = this.initInv.getItem(8);
            if (initAccept != null) {
                ItemMeta meta = initAccept.getItemMeta();
                if (this.initAccepted) {
                    meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accepted \u2713");
                } else {
                    meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accept");
                }
                initAccept.setItemMeta(meta);
            }
            for (i = 0; i < this.initSlots.size(); ++i) {
                this.partInv.setItem(this.initSlots.get(i).intValue(), this.initOffer.get(i));
            }
            for (i = 0; i < this.partSlots.size(); ++i) {
                this.partInv.setItem(this.partSlots.get(i).intValue(), this.partOffer.get(i));
            }
            ItemStack partAccept = this.partInv.getItem(8);
            if (partAccept != null) {
                ItemMeta meta = partAccept.getItemMeta();
                if (this.partAccepted) {
                    meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accepted \u2713");
                } else {
                    meta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Accept");
                }
                partAccept.setItemMeta(meta);
            }
        }
    }
}

