/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.PlatformBlock;
import net.kozibrodka.wolves.block.entity.PulleyBlockEntity;
import net.kozibrodka.wolves.entity.MovingAnchorEntity;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class AnchorBlock
extends TemplateBlock
implements BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    public static float anchorBaseHeight = 0.375f;
    public final int anchorLoopTextureIndex = 39;
    private final int anchorBaseTopAndBottomTextureIndex = 40;
    private final int anchorBaseSideTextureIndex = 41;
    public final int anchorRopeTextureIndex = 32;

    public AnchorBlock(Identifier iid) {
        super(iid, class_15.field_983);
        this.method_1587(2.0f);
        this.method_1580(field_1928);
    }

    public int method_1627(int side, int metaData) {
        return side != metaData && side != UnsortedUtils.getOppositeFacing(metaData) ? TextureListener.anchor_side : TextureListener.anchor_top;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        int iFacing = this.getAnchorFacing((class_14)world, i, j, k);
        switch (iFacing) {
            case 0: {
                return class_25.method_94((double)i, (double)((float)j + 1.0f - anchorBaseHeight), (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
            case 1: {
                return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + anchorBaseHeight), (double)((float)k + 1.0f));
            }
            case 2: {
                return class_25.method_94((double)i, (double)j, (double)((float)k + 1.0f - anchorBaseHeight), (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
            case 3: {
                return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + anchorBaseHeight));
            }
            case 4: {
                return class_25.method_94((double)((float)i + 1.0f - anchorBaseHeight), (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + anchorBaseHeight), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
    }

    public void method_1616(class_14 iblockaccess, int i, int j, int k) {
        int iFacing = this.getAnchorFacing(iblockaccess, i, j, k);
        switch (iFacing) {
            case 0: {
                this.method_1578(0.0f, 0.35f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.65f, 1.0f);
                break;
            }
            case 2: {
                this.method_1578(0.0f, 0.0f, 0.35f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.65f);
                break;
            }
            case 4: {
                this.method_1578(0.35f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.0f, 0.0f, 0.65f, 1.0f, 1.0f);
            }
        }
    }

    public void method_1605() {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.375f, 1.0f);
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        int iAnchorFacing = iFacing;
        this.setAnchorFacing(world, i, j, k, iAnchorFacing);
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        boolean bRopeEquipped;
        if (world.field_180) {
            return true;
        }
        class_31 playerEquippedItem = entityPlayer.method_502();
        boolean bl = bRopeEquipped = playerEquippedItem != null && playerEquippedItem.field_753 == ItemListener.ropeItem.field_461;
        if (!bRopeEquipped) {
            this.retractRope(world, i, j, k, entityPlayer);
            return true;
        }
        return false;
    }

    public int getAnchorFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k);
    }

    public void setAnchorFacing(class_18 world, int i, int j, int k, int iFacing) {
        world.method_215(i, j, k, iFacing);
    }

    void retractRope(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        int offsetId;
        for (int offsetY = j - 1; offsetY >= 0 && (offsetId = world.method_1776(i, offsetY, k)) == BlockListener.rope.field_1915; --offsetY) {
            if (world.method_1776(i, offsetY - 1, k) == BlockListener.rope.field_1915) continue;
            this.addRopeToPlayerInventory(world, i, j, k, entityPlayer);
            class_17 targetBlock = BlockListener.rope;
            world.method_150((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), targetBlock.field_1926.method_1978(), (targetBlock.field_1926.method_1976() + 1.0f) / 5.0f, targetBlock.field_1926.method_1977() * 0.8f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, targetBlock.field_1926.method_1978(), i, j, k, (targetBlock.field_1926.method_1976() + 1.0f) / 5.0f, targetBlock.field_1926.method_1977() * 0.8f);
            }
            world.method_229(i, offsetY, k, 0);
            break;
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    private void addRopeToPlayerInventory(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        class_31 ropeStack = new class_31(ItemListener.ropeItem);
        if (entityPlayer.field_519.method_671(ropeStack)) {
            world.method_191((class_57)entityPlayer, "random.pop", 0.2f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.pop", i, j, k, 0.2f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        } else {
            UnsortedUtils.ejectStackWithRandomOffset(world, i, j, k, ropeStack);
        }
    }

    public void notifyAnchorBlockOfAttachedPulleyStateChange(PulleyBlockEntity tileEntityPulley, class_18 world, int i, int j, int k) {
        int movementDirection = 0;
        if (tileEntityPulley.IsRaising()) {
            if (world.method_1776(i, j + 1, k) == BlockListener.rope.field_1915) {
                movementDirection = 1;
            }
        } else if (tileEntityPulley.isLowering() && (world.method_234(i, j - 1, k) || world.method_1776(i, j - 1, k) == BlockListener.platform.field_1915)) {
            movementDirection = -1;
        }
        if (movementDirection != 0) {
            this.convertAnchorToEntity(world, i, j, k, tileEntityPulley, movementDirection);
        }
    }

    private void convertAnchorToEntity(class_18 world, int i, int j, int k, PulleyBlockEntity attachedTileEntityPulley, int movementDirection) {
        BlockPosition pulleyPos = new BlockPosition(attachedTileEntityPulley.field_1239, attachedTileEntityPulley.field_1240, attachedTileEntityPulley.field_1241);
        MovingAnchorEntity entityAnchor = new MovingAnchorEntity(world, (float)i + 0.5f, (float)j + anchorBaseHeight / 2.0f, (float)k + 0.5f, pulleyPos, movementDirection);
        world.method_210((class_57)entityAnchor);
        this.convertConnectedPlatformsToEntities(world, i, j, k, entityAnchor);
        world.method_229(i, j, k, 0);
    }

    private void convertConnectedPlatformsToEntities(class_18 world, int i, int j, int k, MovingAnchorEntity associatedAnchorEntity) {
        int targetY = j - 1;
        int targetId = world.method_1776(i, targetY, k);
        if (targetId == BlockListener.platform.field_1915) {
            ((PlatformBlock)BlockListener.platform).covertToEntitiesFromThisPlatform(world, i, targetY, k, associatedAnchorEntity);
        }
    }

    public boolean renderWorld(class_13 blockRenderManager, class_14 blockView, int x, int y, int z) {
        float f = 0.5f;
        float f1 = 0.5f;
        float f2 = anchorBaseHeight;
        int l = this.getAnchorFacing(blockView, x, y, z);
        switch (l) {
            case 0: {
                this.method_1578(0.5f - f1, 1.0f - f2, 0.5f - f, 0.5f + f1, 1.0f, 0.5f + f);
                break;
            }
            case 1: {
                this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
                break;
            }
            case 2: {
                this.method_1578(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.5f - f1, 0.5f - f, 0.0f, 0.5f + f1, 0.5f + f, f2);
                break;
            }
            case 4: {
                this.method_1578(1.0f - f2, 0.5f - f1, 0.5f - f, 1.0f, 0.5f + f1, 0.5f + f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.5f - f1, 0.5f - f, f2, 0.5f + f1, 0.5f + f);
            }
        }
        blockRenderManager.method_76((class_17)this, x, y, z);
        f = 0.125f;
        f1 = 0.125f;
        f2 = 0.25f;
        this.method_1578(0.5f - f1, anchorBaseHeight, 0.5f - f, 0.5f + f1, anchorBaseHeight + f2, 0.5f + f);
        CustomBlockRendering.renderStandardBlockWithTexture(blockRenderManager, (class_17)this, x, y, z, TextureListener.anchor_button);
        boolean flag = false;
        f = 0.0625f;
        f1 = 0.0625f;
        f2 = anchorBaseHeight;
        if (l == 1) {
            int i1 = blockView.method_1776(x, y + 1, z);
            if (i1 == BlockListener.rope.field_1915 || i1 == BlockListener.pulley.field_1915) {
                this.method_1578(0.5f - f1, f2, 0.5f - f, 0.5f + f1, 1.0f, 0.5f + f);
                flag = true;
            }
        } else if (blockView.method_1776(x, y - 1, z) == BlockListener.rope.field_1915) {
            this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
            flag = true;
        }
        if (flag) {
            CustomBlockRendering.renderStandardBlockWithTexture(blockRenderManager, (class_17)this, x, y, z, TextureListener.rope);
        }
        return true;
    }

    public void renderInventory(class_13 blockRenderManager, int meta) {
        this.method_1605();
        CustomBlockRendering.RenderInvBlockWithMetaData(blockRenderManager, (class_17)this, -0.5f, -0.25f, -0.5f, 1);
        float f = 0.125f;
        float f1 = 0.125f;
        float f2 = 0.25f;
        this.method_1578(0.5f - f1, anchorBaseHeight, 0.5f - f, 0.5f + f1, anchorBaseHeight + f2, 0.5f + f);
        CustomBlockRendering.RenderInvBlockWithTexture(blockRenderManager, (class_17)this, -0.5f, -0.25f, -0.5f, TextureListener.anchor_button);
    }
}

