/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_153;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class DetectorBlock
extends TemplateBlock {
    public DetectorBlock(Identifier identifier, class_15 material) {
        super(identifier, material);
        this.method_1584(true);
        this.method_1587(1.5f);
    }

    public void method_1609(class_18 level, int x, int y, int z, int id) {
        if (this.isObstructed(level, x, y, z)) {
            this.activateDetector(level, x, y, z);
        } else {
            level.method_216(x, y, z, this.field_1915, this.method_1565());
        }
    }

    public int method_1626(class_14 blockView, int x, int y, int z, int l) {
        int facing = this.getFacing(blockView, x, y, z);
        if (l == facing) {
            if (this.isBlockOn(blockView, x, y, z)) {
                return TextureListener.detector_on;
            }
            return TextureListener.detector_off;
        }
        if (l == 1) {
            return TextureListener.detector_top;
        }
        if (l == 0) {
            return TextureListener.detector_bottom;
        }
        return TextureListener.detector_side;
    }

    public int method_1607(int i) {
        if (i == 3) {
            return TextureListener.detector_off;
        }
        if (i == 1) {
            return TextureListener.detector_top;
        }
        if (i == 0) {
            return TextureListener.detector_bottom;
        }
        return TextureListener.detector_side;
    }

    public void method_1602(class_18 level, int x, int y, int z, Random random) {
        if (this.isObstructed(level, x, y, z)) {
            return;
        }
        if (this.getFacing(level, x, y, z) == 1 && this.isDetectingRain(level, x, y + 1, z)) {
            this.activateDetector(level, x, y, z);
            return;
        }
        BlockPosition tempPos = new BlockPosition(x, y, z);
        tempPos.AddFacingAsOffset(this.getFacing(level, x, y, z));
        List list = level.method_175(class_57.class, class_25.method_94((double)tempPos.i, (double)tempPos.j, (double)tempPos.k, (double)(1 + tempPos.i), (double)(1 + tempPos.j), (double)(1 + tempPos.k)));
        if (list == null) {
            this.deactivateDetector(level, x, y, z);
            return;
        }
        if (list.size() == 0) {
            this.deactivateDetector(level, x, y, z);
            return;
        }
        for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
            class_57 targetEntity = (class_57)list.get(listIndex);
            if (targetEntity == null) continue;
            this.activateDetector(level, x, y, z);
            return;
        }
    }

    private boolean isDetectingRain(class_18 level, int x, int y, int z) {
        if (!level.method_270()) {
            return false;
        }
        if (!level.method_249(x, y, z)) {
            return false;
        }
        if (level.method_228(x, z) > y) {
            return false;
        }
        class_153 biomeGenBase = level.method_1781().method_1787(x, z);
        if (biomeGenBase.method_793()) {
            return true;
        }
        return biomeGenBase.method_794();
    }

    private void activateDetector(class_18 level, int x, int y, int z) {
        if (this.isBlockOn(level, x, y, z)) {
            level.method_216(x, y, z, BlockListener.detectorBlock.field_1915, this.method_1565());
            return;
        }
        level.method_150((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.75f, 2.0f);
        if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(level, "random.click", x, y, z, 0.75f, 2.0f);
        }
        int metadata = level.method_1778(x, y, z);
        level.method_201(x, y, z, this.field_1915, ++metadata);
        level.method_244(x, y, z, BlockListener.detectorBlock.field_1915);
        level.method_216(x, y, z, BlockListener.detectorBlock.field_1915, this.method_1565());
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    private void deactivateDetector(class_18 level, int x, int y, int z) {
        if (!this.isBlockOn(level, x, y, z)) {
            level.method_216(x, y, z, BlockListener.detectorBlock.field_1915, this.method_1565());
            return;
        }
        int metadata = level.method_1778(x, y, z);
        level.method_201(x, y, z, BlockListener.detectorBlock.field_1915, --metadata);
        level.method_244(x, y, z, BlockListener.detectorBlock.field_1915);
        level.method_216(x, y, z, BlockListener.detectorBlock.field_1915, this.method_1565());
    }

    private boolean isObstructed(class_18 level, int x, int y, int z) {
        BlockPosition tempPos = new BlockPosition(x, y, z);
        tempPos.AddFacingAsOffset(this.getFacing(level, x, y, z));
        return level.method_1776(tempPos.i, tempPos.j, tempPos.k) != 0;
    }

    public int method_1565() {
        return 5;
    }

    public void method_1611(class_18 level, int x, int y, int z) {
        super.method_1611(level, x, y, z);
        level.method_216(x, y, z, BlockListener.detectorBlock.field_1915, this.method_1565());
    }

    public void method_1606(class_18 level, int x, int y, int z, int facing) {
        this.setFacing(level, x, y, z, UnsortedUtils.getOppositeFacing(facing));
    }

    public void method_1614(class_18 level, int x, int y, int z, class_127 entityLiving) {
        this.setFacing(level, x, y, z, UnsortedUtils.ConvertPlacingEntityOrientationToBlockFacing(entityLiving));
    }

    public boolean method_1568(class_14 blockView, int x, int y, int z, int direction) {
        return this.isBlockOn(blockView, x, y, z);
    }

    public boolean method_1570(class_18 world, int i, int j, int i1, int j1) {
        return false;
    }

    public boolean method_1569() {
        return true;
    }

    public int getFacing(class_14 blockView, int i, int j, int k) {
        return (blockView.method_1778(i, j, k) & 0xFFFFFFFE) >> 1;
    }

    public int getFacing(class_18 level, int i, int j, int k) {
        return (level.method_1778(i, j, k) & 0xFFFFFFFE) >> 1;
    }

    public void setFacing(class_18 level, int i, int j, int k, int iFacing) {
        int iMetaData = level.method_1778(i, j, k);
        iMetaData = iMetaData & 1 | iFacing << 1;
        level.method_215(i, j, k, iMetaData);
    }

    public boolean isBlockOn(class_14 blockView, int i, int j, int k) {
        return (blockView.method_1778(i, j, k) & 1) > 0;
    }

    public boolean isBlockOn(class_18 level, int i, int j, int k) {
        return (level.method_1778(i, j, k) & 1) > 0;
    }
}

