/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)
public class HandCrankBlock
extends TemplateBlock
implements MechanicalDevice,
BlockWithInventoryRenderer {
    private static final int handCrankTickRate = 3;
    private static final int handCrankDelayBeforeReset = 15;
    public static float handCrankBaseHeight = 0.25f;

    public HandCrankBlock(Identifier iid) {
        super(iid, class_15.field_993);
        this.method_1587(0.5f);
        this.method_1580(field_1929);
        this.method_1584(true);
    }

    public int method_1565() {
        return 3;
    }

    public int method_1607(int iSide) {
        if (iSide == 1) {
            return TextureListener.handcrack_top;
        }
        if (iSide == 0) {
            return TextureListener.handcrack_bottom;
        }
        return TextureListener.handcrack_side;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + handCrankBaseHeight), (double)((float)k + 1.0f));
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public void method_1616(class_14 iBlockAccess, int i, int j, int k) {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean method_1567(class_18 world, int i, int j, int k) {
        return world.method_1783(i, j - 1, k);
    }

    public void method_1610(class_18 world, int i, int j, int k, class_54 entityplayer) {
        this.method_1608(world, i, j, k, entityplayer);
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        if (world == null) {
            return true;
        }
        int iMetaData = world.method_1778(i, j, k);
        if (iMetaData == 0) {
            if (!this.CheckForOverpower(world, i, j, k)) {
                world.method_215(i, j, k, 1);
                world.method_202(i, j, k, i, j, k);
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.click", 1.0f, 2.0f);
                world.method_244(i, j, k, BlockListener.handCrank.field_1915);
                world.method_216(i, j, k, BlockListener.handCrank.field_1915, this.method_1565());
            } else {
                this.BreakCrankWithDrop(world, i, j, k);
            }
        }
        return true;
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        int iMetaData = world.method_1778(i, j, k);
        if (iMetaData > 0) {
            if (iMetaData < 7) {
                if (iMetaData <= 6) {
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.click", 1.0f, 2.0f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, i, j, k, 1.0f, 2.0f);
                    }
                }
                if (iMetaData <= 5) {
                    world.method_216(i, j, k, BlockListener.handCrank.field_1915, this.method_1565() + iMetaData);
                } else {
                    world.method_216(i, j, k, BlockListener.handCrank.field_1915, 15);
                }
                world.method_215(i, j, k, iMetaData + 1);
                world.method_243(i, j, k);
                world.method_202(i, j, k, i, j, k);
            } else {
                world.method_215(i, j, k, 0);
                world.method_243(i, j, k);
                world.method_202(i, j, k, i, j, k);
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.click", 0.3f, 0.7f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, i, j, k, 0.3f, 0.7f);
                }
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket("random.click", x, y, z, g, h));
            }
        }
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        if (!world.method_1783(i, j - 1, k)) {
            this.method_1592(world, i, j, k, world.method_1778(i, j, k));
            world.method_229(i, j, k, 0);
        }
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return false;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int k) {
        return world.method_1778(i, j, k) > 0;
    }

    public boolean CheckForOverpower(class_18 world, int i, int j, int k) {
        int iNumPotentialDevicesToPower = 0;
        for (int iTempFacing = 2; iTempFacing <= 5; ++iTempFacing) {
            MechanicalDevice tempDevice;
            BlockPosition tempPos = new BlockPosition(i, j, k);
            tempPos.AddFacingAsOffset(iTempFacing);
            int iTempid = world.method_1776(tempPos.i, tempPos.j, tempPos.k);
            class_17 tempBlock = class_17.field_1937[iTempid];
            if (tempBlock == null || !(tempBlock instanceof MechanicalDevice) || !(tempDevice = (MechanicalDevice)tempBlock).CanInputMechanicalPower()) continue;
            ++iNumPotentialDevicesToPower;
        }
        return iNumPotentialDevicesToPower > 1;
    }

    public void BreakCrankWithDrop(class_18 world, int i, int j, int k) {
        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_124.field_377.field_461, 0);
        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_17.field_1948.asItem().field_461, 0);
        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_17.field_1948.asItem().field_461, 0);
        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.gear.field_461, 0);
        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
        world.method_229(i, j, k, 0);
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        float f = 0.5f;
        float f1 = 0.5f;
        float f2 = handCrankBaseHeight;
        this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        f = 0.0625f;
        f1 = 0.0625f;
        f2 = 1.0f;
        this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.handcrack_lever);
    }
}

