/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.loader.api.FabricLoader;
import net.kozibrodka.wolves.api.AffectedByBellows;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.entity.HopperBlockEntity;
import net.kozibrodka.wolves.container.HopperScreenHandler;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.ScreenPacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_13;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_142;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.class_71;
import net.minecraft.class_73;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)
public class HopperBlock
extends TemplateBlockWithEntity
implements MechanicalDevice,
RotatableBlock,
BlockWithInventoryRenderer,
AffectedByBellows {
    private static final int hopperTickRate = 10;
    private static boolean SETTING_TILE = false;
    public static final BooleanProperty POWER = BooleanProperty.of((String)"power");
    public static final BooleanProperty REDOUTPUT = BooleanProperty.of((String)"redoutput");
    public static final IntProperty FULL = IntProperty.of((String)"full", (int)0, (int)18);
    public static final IntProperty FILTER = IntProperty.of((String)"filter", (int)0, (int)6);

    public HopperBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
        this.method_1584(true);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.setDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getDefaultState().with((Property)REDOUTPUT, (Comparable)Boolean.valueOf(false))).with((Property)POWER, (Comparable)Boolean.valueOf(false))).with((Property)FULL, (Comparable)Integer.valueOf(0))).with((Property)FILTER, (Comparable)Integer.valueOf(0)));
    }

    public int method_1565() {
        return 10;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        if (!this.HasFilter(world, i, j, k)) {
            return class_25.method_87((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 0.5f), (double)(k + 1));
        }
        return class_25.method_87((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 0.99f), (double)(k + 1));
    }

    public class_25 method_1622(class_18 world, int i, int j, int k) {
        return class_25.method_87((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 1.0f), (double)(k + 1));
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public int method_1607(int iSide) {
        if (iSide == 0) {
            return TextureListener.hopper_bottom;
        }
        return iSide != 1 ? TextureListener.hopper_side : TextureListener.hopper_top;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        if (this.IsBlockOn(world, i, j, k) != bReceivingPower) {
            world.method_216(i, j, k, this.field_1915, this.method_1565());
        }
        ((HopperBlockEntity)world.method_1777((int)i, (int)j, (int)k)).hopperEjectBlocked = false;
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityplayer) {
        HopperBlockEntity tileEntityHopper = (HopperBlockEntity)world.method_1777(i, j, k);
        ScreenHandlerListener.TempGuiX = i;
        ScreenHandlerListener.TempGuiY = j;
        ScreenHandlerListener.TempGuiZ = k;
        if (world.field_180) {
            PacketHelper.send((class_169)new ScreenPacket("hopper", 0, i, j, k));
        }
        GuiHelper.openGUI((class_54)entityplayer, (Identifier)Identifier.of((String)"wolves:openHopper"), (class_134)tileEntityHopper, (class_71)new HopperScreenHandler((class_134)entityplayer.field_519, tileEntityHopper));
        return true;
    }

    protected class_55 method_1251() {
        return new HopperBlockEntity();
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsBlockOn(world, i, j, k);
        boolean bFull = this.IsHopperFull(world, i, j, k);
        boolean bRedstone = this.IsRedstoneOutputOn(world, i, j, k);
        if (bOn != bReceivingPower) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
            }
            this.EmitHopperParticles(world, i, j, k, random);
            this.SetBlockOn(world, i, j, k, bReceivingPower);
        }
        if (bFull != bRedstone) {
            world.method_150((double)i, (double)j, (double)k, "random.click", 0.25f, 1.2f);
            if (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.click", i, j, k, 0.25f, 1.2f);
            }
            this.SetRedstoneOutputOn(world, i, j, k, bFull);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        if (!SETTING_TILE) {
            InventoryHandler.ejectInventoryContents(world, i, j, k, (class_134)world.method_1777(i, j, k));
        }
        super.method_1630(world, i, j, k);
    }

    public void method_1615(class_18 world, int i, int j, int k, class_57 entity) {
        List collisionList = null;
        if (world.field_180) {
            return;
        }
        boolean bHasFilter = this.HasFilter(world, i, j, k);
        float fHopperHeight = !bHasFilter ? 0.5f : 0.99f;
        collisionList = world.method_175(class_142.class, class_25.method_94((double)i, (double)((float)j + fHopperHeight), (double)k, (double)(i + 1), (double)((float)j + fHopperHeight + 0.05f), (double)(k + 1)));
        if (collisionList != null && collisionList.size() > 0) {
            HopperBlockEntity tileEntityHopper = (HopperBlockEntity)world.method_1777(i, j, k);
            for (int listIndex = 0; listIndex < collisionList.size(); ++listIndex) {
                double fHopperFullBoxTop;
                int iBlockAboveID;
                class_124 targetItem;
                class_142 targetEntityItem = (class_142)collisionList.get(listIndex);
                boolean bSwallowed = false;
                if (!targetEntityItem.field_1630 && tileEntityHopper.CanCurrentFilterProcessItem(targetItem = class_124.field_468[targetEntityItem.field_564.field_753])) {
                    int iFilterType = tileEntityHopper.GetFilterType();
                    int iTargetItemID = class_124.field_468[targetEntityItem.field_564.field_753].field_461;
                    if (iFilterType == 4 && iTargetItemID == class_17.field_1827.asItem().field_461) {
                        class_31 sandItemInstance = new class_31(class_17.field_1826.asItem().field_461, targetEntityItem.field_564.field_751, 0);
                        int iSandSwallowed = 0;
                        if (InventoryHandler.addItemWithinSlotBounds(tileEntityHopper, sandItemInstance, 0, 17)) {
                            iSandSwallowed = targetEntityItem.field_564.field_751;
                            targetEntityItem.method_1386();
                            bSwallowed = true;
                        } else {
                            iSandSwallowed = targetEntityItem.field_564.field_751 - sandItemInstance.field_751;
                            targetEntityItem.field_564.field_751 -= iSandSwallowed;
                        }
                        if (iSandSwallowed > 0) {
                            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.pop", 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                            if (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                                this.voicePacket(world, "random.pop", i, j, k, 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                            }
                            class_31 flintItemInstance = new class_31(class_124.field_442.field_461, iSandSwallowed, 0);
                            class_142 flintEntityitem = new class_142(world, targetEntityItem.field_1600, targetEntityItem.field_1601, targetEntityItem.field_1602, flintItemInstance);
                            flintEntityitem.field_566 = 10;
                            world.method_210((class_57)flintEntityitem);
                        }
                    } else if (InventoryHandler.addItemWithinSlotBounds(tileEntityHopper, targetEntityItem.field_564, 0, 17)) {
                        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.pop", 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        if (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                            this.voicePacket(world, "random.pop", i, j, k, 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        }
                        targetEntityItem.method_1386();
                        bSwallowed = true;
                    }
                }
                if (!bHasFilter || bSwallowed || (iBlockAboveID = world.method_1776(i, j + 1, k)) != class_17.field_1822.field_1915 && iBlockAboveID != class_17.field_1823.field_1915 || !(targetEntityItem.field_1610.field_130 < (fHopperFullBoxTop = (double)j + 1.05))) continue;
                double offset = fHopperFullBoxTop - targetEntityItem.field_1610.field_130;
                targetEntityItem.method_1340(targetEntityItem.field_1600, targetEntityItem.field_1601 + offset, targetEntityItem.field_1602);
            }
        }
    }

    public boolean isEmittingRedstonePower(class_14 iBlockAccess, int i, int j, int k, int l) {
        switch (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType()) {
            case CLIENT: {
                return this.powerClient(iBlockAccess, i, j, k, l);
            }
            case SERVER: {
                return this.powerServer(iBlockAccess, i, j, k, l);
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean powerClient(class_14 iBlockAccess, int i, int j, int k, int l) {
        class_18 level = ((Minecraft)net.fabricmc.loader.FabricLoader.INSTANCE.getGameInstance()).field_2804;
        return this.IsRedstoneOutputOn(level, i, j, k);
    }

    @Environment(value=EnvType.SERVER)
    public boolean powerServer(class_14 iBlockAccess, int i, int j, int k, int l) {
        class_73 level = ((MinecraftServer)FabricLoader.getInstance().getGameInstance()).method_2157(0);
        return this.IsRedstoneOutputOn((class_18)level, i, j, k);
    }

    public boolean method_1570(class_18 world, int i, int j, int i1, int j1) {
        return false;
    }

    public boolean method_1569() {
        return true;
    }

    public boolean IsBlockOn(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.hopper.field_1915) {
            return (Boolean)world.getBlockState(i, j, k).get((Property)POWER);
        }
        return false;
    }

    public void SetBlockOn(class_18 world, int i, int j, int k, boolean bOn) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)POWER, (Comparable)Boolean.valueOf(bOn)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    public boolean IsHopperFull(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.hopper.field_1915) {
            return (Integer)world.getBlockState(i, j, k).get((Property)FULL) == 18;
        }
        return false;
    }

    public void SetHopperFull(class_18 world, int i, int j, int k, int bOn) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)FULL, (Comparable)Integer.valueOf(bOn)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    public boolean IsRedstoneOutputOn(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.hopper.field_1915) {
            return (Boolean)world.getBlockState(i, j, k).get((Property)REDOUTPUT);
        }
        return false;
    }

    public void SetRedstoneOutputOn(class_18 world, int i, int j, int k, boolean bOn) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)REDOUTPUT, (Comparable)Boolean.valueOf(bOn)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    public boolean HasFilter(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.hopper.field_1915) {
            return (Integer)world.getBlockState(i, j, k).get((Property)FILTER) > 0;
        }
        return false;
    }

    public void SetHasFilter(class_18 world, int i, int j, int k, int bOn) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)FILTER, (Comparable)Integer.valueOf(bOn)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    void EmitHopperParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    public void BreakHopper(class_18 world, int i, int j, int k) {
        int iTemp;
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, BlockListener.omniSlab.asItem().field_461, 1);
        }
        for (iTemp = 0; iTemp < 1; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.gear.field_461, 0);
        }
        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 1.0f, 1.25f);
        if (net.fabricmc.loader.FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
        }
        world.method_229(i, j, k, 0);
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        UnsortedUtils.DestroyHorizontallyAttachedAxles(world, i, j, k);
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            class_17 targetBlock;
            MechanicalDevice device;
            AxleBlock axleBlock;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int blockId = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (!(blockId == BlockListener.axleBlock.field_1915 ? (axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) && axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) > 0 : blockId == BlockListener.handCrank.field_1915 && (device = (MechanicalDevice)(targetBlock = class_17.field_1937[blockId])).IsOutputtingMechanicalPower(world, targetPos.i, targetPos.j, targetPos.k))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        int i1;
        int l;
        this.method_1578(0.0f, 0.25f, 0.0f, 0.125f, 1.0f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.25f, 0.875f, 0.875f, 1.0f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.875f, 0.25f, 0.125f, 1.0f, 1.0f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.125f, 0.25f, 0.0f, 1.0f, 1.0f, 0.125f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.125f, 0.25f, 0.125f, 0.875f, 0.375f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.25f, 0.6875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        HopperBlockEntity fctileentityhopper = (HopperBlockEntity)tileView.method_1777(x, y, z);
        Minecraft mc = (Minecraft)net.fabricmc.loader.FabricLoader.INSTANCE.getGameInstance();
        if (mc.field_2804.field_180) {
            l = fctileentityhopper.clientOccupiedSlots;
            i1 = fctileentityhopper.clientFilterType;
        } else {
            l = InventoryHandler.getOccupiedSlotCountWithinBounds(fctileentityhopper, 0, 17);
            i1 = fctileentityhopper.GetFilterType();
        }
        if (l > 0) {
            float f = (float)l / 18.0f;
            float f1 = 0.375f;
            float f2 = f1 + 0.0625f + (0.875f - (f1 + 0.0625f)) * f;
            this.method_1578(0.125f, f1, 0.125f, 0.875f, f2, 0.875f);
            CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, TextureListener.filler);
        }
        if (i1 > 0) {
            int byte0 = 0;
            if (i1 == 1) {
                byte0 = TextureListener.hopper_ladder;
            } else if (i1 == 2) {
                byte0 = TextureListener.hopper_trapdoor;
            } else if (i1 == 3) {
                byte0 = TextureListener.hopper_grate;
            } else if (i1 == 4) {
                byte0 = TextureListener.hopper_wicker;
            } else if (i1 == 5) {
                byte0 = TextureListener.hopper_rollers;
            } else if (i1 == 6) {
                byte0 = TextureListener.hopper_soulsand;
            }
            this.method_1578(0.125f, 0.875f, 0.125f, 0.875f, 0.9375f, 0.875f);
            CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, byte0);
        }
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1578(0.0f, 0.25f, 0.0f, 0.125f, 1.0f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0f, 0.25f, 0.875f, 0.875f, 1.0f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.875f, 0.25f, 0.125f, 1.0f, 1.0f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.125f, 0.25f, 0.0f, 1.0f, 1.0f, 0.125f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.125f, 0.25f, 0.125f, 0.875f, 0.375f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.3125f, 0.0f, 0.3125f, 0.6875f, 0.25f, 0.6875f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void affectBlock(class_18 world, int i, int j, int k, BlockPosition tempTargetPos, int facing) {
        for (int l = 0; l < 2; ++l) {
            tempTargetPos.AddFacingAsOffset(facing);
            if (world.method_234(tempTargetPos.i, tempTargetPos.j, tempTargetPos.k)) continue;
            return;
        }
        class_55 tileEntityHopper = world.method_1777(i, j, k);
        if (tileEntityHopper == null) {
            return;
        }
        if (!(tileEntityHopper instanceof HopperBlockEntity)) {
            return;
        }
        if (((HopperBlockEntity)tileEntityHopper).GetFilterType() != 6) {
            return;
        }
        ((HopperBlockEntity)tileEntityHopper).method_950(18, new class_31(ItemListener.soulFilter, 1));
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        builder.add(new Property[]{REDOUTPUT});
        builder.add(new Property[]{POWER});
        builder.add(new Property[]{FULL});
        builder.add(new Property[]{FILTER});
    }
}

