/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.entity;

import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.EntityListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_26;
import net.minecraft.class_385;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.EntitySpawnDataProvider;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;

@HasTrackingParameters(trackingDistance=160, updatePeriod=2)
public class WaterWheelEntity
extends class_57
implements EntitySpawnDataProvider {
    public static final float fWaterWheelHeight = 4.8f;
    public static final float fWaterWheelWidth = 4.8f;
    public static final float fWaterWheelDepth = 0.8f;
    public static final int iWaterWheelMaxDamage = 40;
    public static final float fWaterWheelRotationPerTick = 0.25f;
    public static final int iWaterWheelTicksPerFullUpdate = 20;
    public int iWaterWheelCurrentDamage;
    public int iWaterWheelTimeSinceHit;
    public int iWaterWheelRockDirection;
    public float fWaterWheelCurrentRotationSpeed;
    public int iFullUpdateTickCount;
    private float sentRotationSpeed;
    public int waterTick;
    public boolean typechoosen;

    public WaterWheelEntity(class_18 world) {
        super(world);
        this.setProvidingPower(false);
        this.setWheelRotation(0.0f);
        this.iWaterWheelCurrentDamage = 0;
        this.iWaterWheelTimeSinceHit = 0;
        this.iWaterWheelRockDirection = 1;
        this.fWaterWheelCurrentRotationSpeed = 0.0f;
        this.iFullUpdateTickCount = 0;
        this.field_1593 = true;
        this.method_1321(0.5f, 0.5f);
        this.field_1631 = this.field_1633 / 2.0f;
        this.waterTick = 0;
    }

    public WaterWheelEntity(class_18 world, double x, double y, double z, boolean bJAligned) {
        this(world);
        this.method_1340(x, y, z);
        this.setAligned(bJAligned);
    }

    public WaterWheelEntity(class_18 level, Double aDouble, Double aDouble1, Double aDouble2) {
        this(level);
    }

    protected void method_1310() {
        this.field_1616.method_1502(16, (Object)0);
        this.field_1616.method_1502(17, (Object)0);
        this.field_1616.method_1502(18, (Object)0);
    }

    protected void method_1368(class_8 nbttagcompound) {
        nbttagcompound.method_1021("bWaterWheelIAligned", this.getAligned());
        nbttagcompound.method_1014("fRotation", this.getWheelRotation());
        nbttagcompound.method_1021("bProvidingPower", this.getProvidingPower());
    }

    protected void method_1363(class_8 nbttagcompound) {
        this.setAligned(nbttagcompound.method_1035("bWaterWheelIAligned"));
        this.setWheelRotation(nbttagcompound.method_1029("fRotation"));
        this.setProvidingPower(nbttagcompound.method_1035("bProvidingPower"));
    }

    protected boolean method_1358() {
        return false;
    }

    public class_25 method_1379(class_57 entity) {
        return entity.field_1610;
    }

    public class_25 method_1381() {
        return this.field_1610;
    }

    public boolean method_1380() {
        return false;
    }

    public boolean method_1356() {
        return !this.field_1630;
    }

    public boolean method_1355(class_57 entity, int i) {
        if (this.field_1596.field_180 || this.field_1630) {
            return true;
        }
        this.iWaterWheelRockDirection = -this.iWaterWheelRockDirection;
        this.iWaterWheelTimeSinceHit = 10;
        this.method_1336();
        this.iWaterWheelCurrentDamage += i * 5;
        if (this.iWaterWheelCurrentDamage > 40) {
            this.destroyWithDrop();
        }
        return true;
    }

    public void method_1312() {
        this.iWaterWheelRockDirection = -this.iWaterWheelRockDirection;
        this.iWaterWheelTimeSinceHit = 10;
        this.iWaterWheelCurrentDamage += this.iWaterWheelCurrentDamage * 5;
    }

    public void method_1386() {
        int zOffset;
        int xOffset;
        int centerX = (int)(this.field_1600 - 0.5);
        int centerY = (int)(this.field_1601 - 0.5);
        int centerZ = (int)(this.field_1602 - 0.5);
        int centerId = this.field_1596.method_1776(centerX, centerY, centerZ);
        if (centerId == BlockListener.nonCollidingAxleBlock.field_1915) {
            this.field_1596.method_201(centerX, centerY, centerZ, BlockListener.axleBlock.field_1915, this.field_1596.method_1778(centerX, centerY, centerZ));
        }
        if (this.getProvidingPower()) {
            if (centerId == BlockListener.axleBlock.field_1915) {
                ((AxleBlock)BlockListener.axleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            } else if (centerId == BlockListener.nonCollidingAxleBlock.field_1915) {
                ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            }
        }
        if (this.getAligned()) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -2; heightOffset <= 2; ++heightOffset) {
            for (int widthOffset = -2; widthOffset <= 2; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || this.field_1596.method_1776(tempX = centerX + xOffset * widthOffset, tempY = centerY + heightOffset, tempZ = centerZ + zOffset * widthOffset) != BlockListener.collisionBlock.field_1915 && this.field_1596.method_1776(tempX, tempY, tempZ) != BlockListener.obstructionBlock.field_1915) continue;
                this.field_1596.method_229(tempX, tempY, tempZ, 0);
            }
        }
        super.method_1386();
    }

    public void destroyWithDrop() {
        if (!this.field_1630) {
            this.method_1325(ItemListener.waterWheelItem.field_461, 1, 0.0f);
            this.method_1386();
        }
    }

    public void method_1370() {
        if (this.field_1630 || this.field_1596.field_180) {
            return;
        }
        --this.iFullUpdateTickCount;
        if (this.iFullUpdateTickCount <= 0) {
            this.iFullUpdateTickCount = 20;
            int centerX = (int)(this.field_1600 - 0.5);
            int centerY = (int)(this.field_1601 - 0.5);
            int centerZ = (int)(this.field_1602 - 0.5);
            int centerId = this.field_1596.method_1776(centerX, centerY, centerZ);
            if (centerId == BlockListener.axleBlock.field_1915) {
                this.field_1596.method_201(centerX, centerY, centerZ, BlockListener.nonCollidingAxleBlock.field_1915, this.field_1596.method_1778(centerX, centerY, centerZ));
            }
            if (centerId != BlockListener.axleBlock.field_1915 && centerId != BlockListener.nonCollidingAxleBlock.field_1915) {
                this.destroyWithDrop();
                return;
            }
            if (!WaterWheelEntity.validateArea(this.field_1596, centerX, centerY, centerZ, this.getAligned())) {
                this.destroyWithDrop();
                return;
            }
            if (!this.getProvidingPower() && ((AxleBlock)BlockListener.axleBlock).GetPowerLevel((class_14)this.field_1596, centerX, centerY, centerZ) > 0) {
                this.destroyWithDrop();
                return;
            }
            if (!this.getProvidingPower() && ((AxleBlock)BlockListener.nonCollidingAxleBlock).GetPowerLevel((class_14)this.field_1596, centerX, centerY, centerZ) > 0) {
                this.destroyWithDrop();
                return;
            }
            this.fWaterWheelCurrentRotationSpeed = this.ComputeRotation(centerX, centerY, centerZ);
            if (this.fWaterWheelCurrentRotationSpeed > 0.01f || this.fWaterWheelCurrentRotationSpeed < -0.01f) {
                if (!this.getProvidingPower()) {
                    this.setProvidingPower(true);
                    ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 3);
                }
            } else if (this.getProvidingPower()) {
                this.setProvidingPower(false);
                ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            }
        }
        if (this.iWaterWheelTimeSinceHit > 0) {
            --this.iWaterWheelTimeSinceHit;
        }
        if (this.iWaterWheelCurrentDamage > 0) {
            --this.iWaterWheelCurrentDamage;
        }
        this.setWheelRotation(this.getWheelRotation() + this.fWaterWheelCurrentRotationSpeed);
        if (this.getWheelRotation() > 360.0f) {
            this.setWheelRotation(this.getWheelRotation() - 360.0f);
        } else if (this.getWheelRotation() < -360.0f) {
            this.setWheelRotation(this.getWheelRotation() + 360.0f);
        }
    }

    public float method_1366() {
        return 0.0f;
    }

    public void method_1371(double deltaX, double deltaY, double deltaZ) {
        if (!this.field_1630) {
            this.destroyWithDrop();
        }
    }

    public static boolean validateArea(class_18 world, int x, int y, int z, boolean aligned) {
        int zOffset;
        int xOffset;
        if (y + 2 >= 128) {
            return false;
        }
        if (aligned) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -2; heightOffset <= 2; ++heightOffset) {
            for (int widthOffset = -2; widthOffset <= 2; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || WaterWheelEntity.isSuitableBlock(world, tempX = x + xOffset * widthOffset, tempY = y + heightOffset, tempZ = z + zOffset * widthOffset)) continue;
                return false;
            }
        }
        return true;
    }

    public static void placeCollisionBlocks(class_18 world, int x, int y, int z, boolean aligned) {
        int zOffset;
        int xOffset;
        if (y + 2 >= 128) {
            return;
        }
        if (aligned) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -2; heightOffset <= 2; ++heightOffset) {
            for (int widthOffset = -2; widthOffset <= 2; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || world.method_1776(tempX = x + xOffset * widthOffset, tempY = y + heightOffset, tempZ = z + zOffset * widthOffset) != 0) continue;
                world.method_229(tempX, tempY, tempZ, BlockListener.collisionBlock.field_1915);
            }
        }
    }

    public static boolean isSuitableBlock(class_18 world, int x, int y, int z) {
        if (!world.method_234(x, y, z)) {
            int id = world.method_1776(x, y, z);
            return id == class_17.field_1822.field_1915 || id == class_17.field_1823.field_1915 || id == BlockListener.collisionBlock.field_1915;
        }
        return true;
    }

    public float ComputeRotation(int iCenterI, int iCenterJ, int iCenterK) {
        class_385 fluidBlock;
        int kOffset;
        int iOffset;
        float fRotationAmount = 0.0f;
        int iFlowJ = iCenterJ - 2;
        int iFlowid = this.field_1596.method_1776(iCenterI, iFlowJ, iCenterK);
        if (iFlowid == class_17.field_1822.field_1915 || iFlowid == class_17.field_1823.field_1915) {
            class_385 fluidBlock2 = (class_385)class_17.field_1937[iFlowid];
            class_26 flowVector = this.getFlowVector(fluidBlock2, (class_14)this.field_1596, iCenterI, iFlowJ, iCenterK);
            if (this.getAligned()) {
                if (flowVector.field_1587 > (double)0.33f) {
                    fRotationAmount = -0.25f;
                } else if (flowVector.field_1587 < (double)-0.33f) {
                    fRotationAmount = 0.25f;
                }
            } else if (flowVector.field_1585 > (double)0.33f) {
                fRotationAmount = 0.25f;
            } else if (flowVector.field_1585 < (double)-0.33f) {
                fRotationAmount = -0.25f;
            }
        }
        if (this.getAligned()) {
            iOffset = 0;
            kOffset = 2;
        } else {
            iOffset = 2;
            kOffset = 0;
        }
        iFlowid = this.field_1596.method_1776(iCenterI + iOffset, iCenterJ, iCenterK - kOffset);
        if (iFlowid == class_17.field_1822.field_1915 || iFlowid == class_17.field_1823.field_1915) {
            fluidBlock = (class_385)class_17.field_1937[iFlowid];
            fRotationAmount -= 0.25f;
        }
        if ((iFlowid = this.field_1596.method_1776(iCenterI - iOffset, iCenterJ, iCenterK + kOffset)) == class_17.field_1822.field_1915 || iFlowid == class_17.field_1823.field_1915) {
            fluidBlock = (class_385)class_17.field_1937[iFlowid];
            fRotationAmount += 0.25f;
        }
        if (fRotationAmount > 0.25f) {
            fRotationAmount = 0.25f;
        } else if (fRotationAmount <= -0.25f) {
            fRotationAmount = -0.25f;
        }
        return fRotationAmount;
    }

    public class_26 getFlowVector(class_385 fluidBlock, class_14 iblockaccess, int i, int j, int k) {
        class_26 vec3d = class_26.method_1297((double)0.0, (double)0.0, (double)0.0);
        int l = this.getEffectiveFlowDecay(fluidBlock, iblockaccess, i, j, k);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int j1 = i;
            int k1 = j;
            int l1 = k;
            if (i1 == 0) {
                --j1;
            }
            if (i1 == 1) {
                --l1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++l1;
            }
            if ((i2 = this.getEffectiveFlowDecay(fluidBlock, iblockaccess, j1, k1, l1)) < 0) {
                if (iblockaccess.method_1779(j1, k1, l1).method_907() || (i2 = this.getEffectiveFlowDecay(fluidBlock, iblockaccess, j1, k1 - 1, l1)) < 0) continue;
                int j2 = i2 - (l - 8);
                vec3d = vec3d.method_1301((double)((j1 - i) * j2), (double)((k1 - j) * j2), (double)((l1 - k) * j2));
                continue;
            }
            if (i2 < 0) continue;
            int k2 = i2 - l;
            vec3d = vec3d.method_1301((double)((j1 - i) * k2), (double)((k1 - j) * k2), (double)((l1 - k) * k2));
        }
        if (iblockaccess.method_1778(i, j, k) >= 8) {
            boolean flag = false;
            if (flag || fluidBlock.method_1573(iblockaccess, i, j, k - 1, 2)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i, j, k + 1, 3)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i - 1, j, k, 4)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i + 1, j, k, 5)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i, j + 1, k - 1, 2)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i, j + 1, k + 1, 3)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i - 1, j + 1, k, 4)) {
                flag = true;
            }
            if (flag || fluidBlock.method_1573(iblockaccess, i + 1, j + 1, k, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.method_1296().method_1301(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.method_1296();
        return vec3d;
    }

    protected int getEffectiveFlowDecay(class_385 fluidBlock, class_14 iblockaccess, int i, int j, int k) {
        if (iblockaccess.method_1779(i, j, k) != fluidBlock.field_1900) {
            return -1;
        }
        int l = iblockaccess.method_1778(i, j, k);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public boolean method_1323(class_54 entityplayer) {
        if (this.field_1596.field_180) {
            System.out.println("KLIENT: " + this.getAligned());
        } else {
            System.out.println("SERVER: " + this.getAligned());
        }
        return false;
    }

    public Identifier getHandlerIdentifier() {
        return Identifier.of((Namespace)EntityListener.NAMESPACE, (String)"WaterWheel");
    }

    public boolean getAligned() {
        return (this.field_1616.method_1501(16) & 1) != 0;
    }

    public void setAligned(boolean flag) {
        if (flag) {
            this.field_1616.method_1509(16, (Object)1);
        } else {
            this.field_1616.method_1509(16, (Object)0);
        }
    }

    public float getWheelRotation() {
        return Float.intBitsToFloat(this.field_1616.method_1508(17));
    }

    public void setWheelRotation(float age) {
        this.field_1616.method_1509(17, (Object)Float.floatToRawIntBits(age));
    }

    public boolean getProvidingPower() {
        return (this.field_1616.method_1501(18) & 1) != 0;
    }

    public void setProvidingPower(boolean flag) {
        if (flag) {
            this.field_1616.method_1509(18, (Object)1);
        } else {
            this.field_1616.method_1509(18, (Object)0);
        }
    }

    public boolean syncTrackerAtSpawn() {
        return true;
    }
}

