/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.events;

import net.fabricmc.loader.api.FabricLoader;
import net.kozibrodka.wolves.compat.nfc.NFCRecipes;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ConfigListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.recipe.AnvilCraftingManager;
import net.kozibrodka.wolves.recipe.CauldronCraftingManager;
import net.kozibrodka.wolves.recipe.CrucibleCraftingManager;
import net.kozibrodka.wolves.recipe.HopperPurifyingRecipeRegistry;
import net.kozibrodka.wolves.recipe.MillingRecipeRegistry;
import net.kozibrodka.wolves.recipe.SawingRecipeRegistry;
import net.kozibrodka.wolves.recipe.StokedCauldronCraftingManager;
import net.kozibrodka.wolves.recipe.TurntableByproduct;
import net.kozibrodka.wolves.recipe.TurntableInput;
import net.kozibrodka.wolves.recipe.TurntableOutput;
import net.kozibrodka.wolves.recipe.TurntableRecipe;
import net.kozibrodka.wolves.recipe.TurntableRecipeRegistry;
import net.kozibrodka.wolves.recipe.TurntableResult;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_124;
import net.minecraft.class_17;
import net.minecraft.class_3;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.event.recipe.RecipeRegisterEvent;
import net.modificationstation.stationapi.api.recipe.CraftingRegistry;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class RecipeListener {
    static boolean isHarderThanWolvesPresent = FabricLoader.getInstance().isModLoaded("harderthanwolves");
    static boolean isNewFrontierCraftPresent = FabricLoader.getInstance().isModLoaded("nfc");

    @EventListener
    public void registerRecipes(RecipeRegisterEvent event) {
        RecipeListener.addAllModRecipes(event);
    }

    public static void addAllModRecipes(RecipeRegisterEvent event) {
        Identifier type = event.recipeId;
        if (type == RecipeRegisterEvent.Vanilla.CRAFTING_SHAPED.type()) {
            RecipeListener.addBlockRecipes();
            RecipeListener.addItemRecipes();
            RecipeListener.addAlternateVanillaRecipes();
            RecipeListener.addShapedAnvilRecipes();
        }
        if (type == RecipeRegisterEvent.Vanilla.CRAFTING_SHAPELESS.type()) {
            RecipeListener.addDyeRecipes();
            RecipeListener.addShapelessCraftingRecipes();
            RecipeListener.addConversionRecipes();
            RecipeListener.addShapelessAnvilRecipes();
            RecipeListener.addCauldronRecipes();
            RecipeListener.addMillingRecipes();
            RecipeListener.addHopperRecipes();
            RecipeListener.addSawingRecipes();
            RecipeListener.addTurntableRecipes();
            if (isNewFrontierCraftPresent) {
                NFCRecipes.addShapelessCraftingRecipes();
            }
        }
        if (type == RecipeRegisterEvent.Vanilla.SMELTING.type()) {
            RecipeListener.addCrucibleRecipes();
        }
        RecipeListener.addDebugRecipes();
    }

    public static void addAnvilRecipe(class_31 output, Object[] inputs) {
        AnvilCraftingManager.getInstance().addRecipe(output, inputs);
    }

    public static void addShapelessAnvilRecipe(class_31 output, Object[] inputs) {
        AnvilCraftingManager.getInstance().addShapelessRecipe(output, inputs);
    }

    public static void addCauldronRecipe(class_31 output, class_31[] inputs) {
        CauldronCraftingManager.getInstance().addRecipe(output, inputs);
    }

    public static void addStokedCauldronRecipe(class_31 output, class_31[] inputs) {
        StokedCauldronCraftingManager.getInstance().addRecipe(output, inputs);
    }

    public static void addCrucibleRecipe(class_31 output, class_31[] inputs) {
        CrucibleCraftingManager.getInstance().addRecipe(output, inputs);
    }

    private static void addBlockRecipes() {
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.anvil, 1), (Object[])new Object[]{"###", " # ", "###", Character.valueOf('#'), ItemListener.steel});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.lightBulbOff, 1), (Object[])new Object[]{" # ", "#X#", " Y ", Character.valueOf('#'), class_17.field_1834, Character.valueOf('X'), class_124.field_420, Character.valueOf('Y'), class_124.field_403});
        if (!isHarderThanWolvesPresent) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.hibachi), (Object[])new Object[]{"XXX", "#Z#", "#Y#", Character.valueOf('#'), class_17.field_1945, Character.valueOf('X'), ItemListener.concentratedHellfire, Character.valueOf('Y'), class_124.field_403, Character.valueOf('Z'), class_124.field_420});
        }
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.hopper), (Object[])new Object[]{"# #", "XYX", " Z ", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_17.field_1859, Character.valueOf('Z'), BlockListener.corner});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.saw), (Object[])new Object[]{"YYY", "XZX", "#X#", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_124.field_478, Character.valueOf('Z'), ItemListener.belt});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.platform), (Object[])new Object[]{"#X#", " # ", "#X#", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), ItemListener.wicker});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.platform), (Object[])new Object[]{"X#X", " X ", "X#X", Character.valueOf('#'), ItemListener.wicker, Character.valueOf('X'), BlockListener.moulding});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.pulley), (Object[])new Object[]{"#Y#", "XZX", "#Y#", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_124.field_478, Character.valueOf('Z'), class_124.field_403});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.pressurePlateObsidian, 1), (Object[])new Object[]{"##", Character.valueOf('#'), class_17.field_1890});
        if (!isHarderThanWolvesPresent) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.blockDispenser), (Object[])new Object[]{"###", "# #", "YXY", Character.valueOf('#'), class_17.field_1889, Character.valueOf('X'), class_124.field_403, Character.valueOf('Y'), class_17.field_1945});
        }
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.cauldron), (Object[])new Object[]{"#Y#", "#X#", "###", Character.valueOf('#'), class_124.field_478, Character.valueOf('X'), class_124.field_424, Character.valueOf('Y'), class_124.field_450});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.detectorRailWood, 6), (Object[])new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), class_124.field_478, Character.valueOf('R'), class_124.field_403, Character.valueOf('#'), class_17.field_1859});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.detectorRailObsidian, 6), (Object[])new Object[]{"X X", "X#X", "XRX", Character.valueOf('X'), class_124.field_478, Character.valueOf('R'), class_124.field_403, Character.valueOf('#'), BlockListener.pressurePlateObsidian});
        if (!isHarderThanWolvesPresent) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.detectorBlock), (Object[])new Object[]{"X#X", "###", "ZYZ", Character.valueOf('#'), class_17.field_1948, Character.valueOf('X'), new class_31(class_124.field_423, 1, 4), Character.valueOf('Y'), class_124.field_403, Character.valueOf('Z'), class_17.field_1945});
        }
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.handCrank), (Object[])new Object[]{"  Y", " Y ", "#X#", Character.valueOf('#'), class_17.field_1948, Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_124.field_377});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.millStone), (Object[])new Object[]{"YYY", "YYY", "YXY", Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_17.field_1945});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.axleBlock), (Object[])new Object[]{"#", "X", "#", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), ItemListener.ropeItem});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.axleBlock), (Object[])new Object[]{"#", "X", "#", Character.valueOf('#'), BlockListener.moulding, Character.valueOf('X'), ItemListener.ropeItem});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.gearBox), (Object[])new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_124.field_403});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.gearBox), (Object[])new Object[]{"#X#", "XYX", "#X#", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), ItemListener.gear, Character.valueOf('Y'), class_124.field_403});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.turntable), (Object[])new Object[]{"###", "ZXZ", "ZYZ", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), class_124.field_403, Character.valueOf('Y'), ItemListener.gear, Character.valueOf('Z'), class_17.field_1945});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.bellows), (Object[])new Object[]{"###", "XXX", "YZY", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), ItemListener.tannedLeather, Character.valueOf('Y'), ItemListener.gear, Character.valueOf('Z'), ItemListener.belt});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.planter, 1, 1), (Object[])new Object[]{"Y", "X", "#", Character.valueOf('#'), new class_31(BlockListener.planter, 1, 0), Character.valueOf('X'), class_124.field_450, Character.valueOf('Y'), class_17.field_1947});
        if (ConfigListener.wolvesGlass.small_tweaks.wickerBlock.booleanValue()) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31((class_17)BlockListener.blockOfWicker, 1), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemListener.wicker});
        }
        if (ConfigListener.wolvesGlass.small_tweaks.grateBlock.booleanValue()) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31((class_17)BlockListener.blockOfGrates, 1), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), ItemListener.grate});
        }
    }

    private static void addItemRecipes() {
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.bucketCement, 1), (Object[])new Object[]{"#YX", " Z ", Character.valueOf('#'), class_17.field_1905, Character.valueOf('X'), class_17.field_1827, Character.valueOf('Y'), class_124.field_450, Character.valueOf('Z'), class_124.field_449});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.gear, 2), (Object[])new Object[]{" X ", "X#X", " X ", Character.valueOf('#'), class_17.field_1949, Character.valueOf('X'), class_124.field_377});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.ropeItem, 1), (Object[])new Object[]{"##", "##", "##", Character.valueOf('#'), ItemListener.hempFibers});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(BlockListener.anchor), (Object[])new Object[]{" X ", "###", Character.valueOf('#'), class_17.field_1945, Character.valueOf('X'), class_124.field_478});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.waterWheelItem), (Object[])new Object[]{"###", "# #", "###", Character.valueOf('#'), ItemListener.woodBlade});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.windMillBladeItem), (Object[])new Object[]{"###", "###", "XXX", Character.valueOf('#'), ItemListener.hempCloth, Character.valueOf('X'), BlockListener.moulding});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.windMillBladeItem), (Object[])new Object[]{"###", "###", "XXX", Character.valueOf('#'), ItemListener.hempCloth, Character.valueOf('X'), class_17.field_1949});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.windMillItem), (Object[])new Object[]{" # ", "# #", " # ", Character.valueOf('#'), ItemListener.windMillBladeItem});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.hempCloth, 1), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), ItemListener.hempFibers});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.grate, 1), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), class_124.field_377});
        if (!ConfigListener.wolvesGlass.difficulty.wickerWeaving.booleanValue()) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.wicker, 1), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), class_124.field_410});
        }
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.rollersItem, 1), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), BlockListener.moulding});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.strap, 8), (Object[])new Object[]{"#", Character.valueOf('#'), ItemListener.tannedLeather});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.belt, 1), (Object[])new Object[]{" # ", "# #", " # ", Character.valueOf('#'), ItemListener.strap});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.woodBlade, 1), (Object[])new Object[]{"#  ", "#X#", "#  ", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), class_124.field_413});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.woodBlade, 1), (Object[])new Object[]{"#  ", "#X#", "#  ", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), ItemListener.glue});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.haft, 1), (Object[])new Object[]{"Y", "X", "#", Character.valueOf('#'), BlockListener.moulding, Character.valueOf('X'), ItemListener.glue, Character.valueOf('Y'), ItemListener.strap});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.haft, 1), (Object[])new Object[]{"Y", "X", "#", Character.valueOf('#'), BlockListener.moulding, Character.valueOf('X'), class_124.field_413, Character.valueOf('Y'), ItemListener.strap});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.compositeBow, 1), (Object[])new Object[]{"X#Y", "ZX#", "X#Y", Character.valueOf('#'), BlockListener.moulding, Character.valueOf('X'), class_124.field_424, Character.valueOf('Y'), class_124.field_413, Character.valueOf('Z'), class_124.field_384});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.compositeBow, 1), (Object[])new Object[]{"X#Y", "ZX#", "X#Y", Character.valueOf('#'), BlockListener.moulding, Character.valueOf('X'), class_124.field_424, Character.valueOf('Y'), ItemListener.glue, Character.valueOf('Z'), class_124.field_384});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(ItemListener.broadHeadArrow, 4), (Object[])new Object[]{"#", "X", "Y", Character.valueOf('#'), ItemListener.broadHeadArrowhead, Character.valueOf('X'), BlockListener.moulding, Character.valueOf('Y'), class_124.field_385});
        if (ConfigListener.wolvesGlass.difficulty.wickerWeaving.booleanValue()) {
            CraftingRegistry.addShapedRecipe((class_31)new class_31((class_124)ItemListener.wickerWeaving), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), class_124.field_410});
        }
    }

    private static void addDyeRecipes() {
        for (int i = 0; i < 15; ++i) {
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(BlockListener.vase, 1, class_3.method_1((int)i)), (Object[])new Object[]{new class_31(class_124.field_423, 1, i), new class_31(BlockListener.vase, 1, 0)});
        }
        if (ConfigListener.wolvesGlass.small_tweaks.deactivateDung.booleanValue()) {
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(class_17.field_1876, 1, 12), (Object[])new Object[]{new class_31(class_17.field_1831), new class_31(class_17.field_1876, 1, 0)});
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(BlockListener.vase, 1, 12), (Object[])new Object[]{new class_31(class_17.field_1831), new class_31(BlockListener.vase, 1, 0)});
        } else {
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(class_17.field_1876, 1, 12), (Object[])new Object[]{new class_31(ItemListener.dung), new class_31(class_17.field_1876, 1, 0)});
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(BlockListener.vase, 1, 12), (Object[])new Object[]{new class_31(ItemListener.dung), new class_31(BlockListener.vase, 1, 0)});
        }
    }

    private static void addAlternateVanillaRecipes() {
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_17.field_1843, 1), (Object[])new Object[]{"#", "X", Character.valueOf('#'), ItemListener.glue, Character.valueOf('X'), class_17.field_1874});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_17.field_1902, 2), (Object[])new Object[]{"###", Character.valueOf('#'), BlockListener.moulding});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_17.field_1894, 1), (Object[])new Object[]{"# ", "##", Character.valueOf('#'), BlockListener.moulding});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_124.field_447, 1), (Object[])new Object[]{"###", "###", " X ", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1), Character.valueOf('X'), class_124.field_377});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_124.field_448, 1), (Object[])new Object[]{"##", "##", "##", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1)});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_17.field_1913, 2), (Object[])new Object[]{"###", "###", Character.valueOf('#'), new class_31(BlockListener.omniSlab, 1, 1)});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_124.field_426, 1), (Object[])new Object[]{"AAA", "BEB", "CCC", Character.valueOf('A'), class_124.field_425, Character.valueOf('B'), class_124.field_407, Character.valueOf('C'), ItemListener.flour, Character.valueOf('E'), class_124.field_416});
        CraftingRegistry.addShapedRecipe((class_31)new class_31(class_17.field_1891, 4), (Object[])new Object[]{"#", "X", Character.valueOf('#'), ItemListener.netherCoal, Character.valueOf('X'), class_124.field_377});
    }

    private static void addShapelessCraftingRecipes() {
        if (ConfigListener.wolvesGlass.difficulty.wickerWeaving.booleanValue()) {
            CraftingRegistry.addShapelessRecipe((class_31)new class_31(ItemListener.wicker), (Object[])new Object[]{new class_31((class_124)ItemListener.wickerSheet), new class_31(ItemListener.grate)});
        }
    }

    private static void addConversionRecipes() {
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(class_17.field_1949), (Object[])new Object[]{new class_31(BlockListener.omniSlab, 1, 1), new class_31(BlockListener.omniSlab, 1, 1)});
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(class_17.field_1945), (Object[])new Object[]{new class_31(BlockListener.omniSlab, 1, 0), new class_31(BlockListener.omniSlab, 1, 0)});
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(BlockListener.omniSlab, 1, 1), (Object[])new Object[]{new class_31(BlockListener.moulding, 1, 0), new class_31(BlockListener.moulding, 1, 0)});
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(BlockListener.moulding, 1, 0), (Object[])new Object[]{new class_31(BlockListener.corner, 1, 0), new class_31(BlockListener.corner, 1, 0)});
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(class_124.field_384), (Object[])new Object[]{new class_31(ItemListener.hempFibers), new class_31(ItemListener.hempFibers)});
        CraftingRegistry.addShapelessRecipe((class_31)new class_31(ItemListener.steel, 9), (Object[])new Object[]{new class_31((class_17)BlockListener.blockOfSteel)});
    }

    private static void addShapedAnvilRecipes() {
        if (ConfigListener.wolvesGlass.difficulty.difficultSoulforgedSteelRecipes.booleanValue()) {
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedPickAxe, 1), new Object[]{"#####", "  X  ", "  X  ", "  X  ", "  X  ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedShovel, 1), new Object[]{" ### ", " ### ", "  X  ", "  X  ", "  X  ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedHoe, 1), new Object[]{"###  ", "  X  ", "  X  ", "  X  ", "  X  ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedAxe, 1), new Object[]{"#####", "# X #", "  X  ", "  X  ", "  X  ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedSword, 1), new Object[]{"  #  ", "  #  ", "  #  ", " ### ", "  X  ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.armourPlateSteel, 1), new Object[]{"#XXX#", Character.valueOf('#'), ItemListener.strap, Character.valueOf('X'), ItemListener.steel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.helmetSteel, 1), new Object[]{"#####", "#   #", "#XXX#", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.chestPlateSteel, 1), new Object[]{"X   X", "#####", "#####", "#####", "#####", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.leggingsSteel, 1), new Object[]{"#####", "X   X", "X   X", "X   X", "X   X", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.bootsSteel, 1), new Object[]{" # # ", " # # ", " # # ", " # # ", "## ##", Character.valueOf('#'), ItemListener.steel});
        } else {
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedPickAxe, 1), new Object[]{"###", " X ", " X ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedShovel, 1), new Object[]{"#", "X", "X", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedHoe, 1), new Object[]{"##", " X", " X", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedAxe, 1), new Object[]{"###", "#X#", " X ", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.refinedSword, 1), new Object[]{"#", "#", "X", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.armourPlateSteel, 1), new Object[]{"#X#", Character.valueOf('#'), ItemListener.strap, Character.valueOf('X'), ItemListener.steel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.helmetSteel, 1), new Object[]{"###", "#X#", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.chestPlateSteel, 1), new Object[]{"X X", "###", "###", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.leggingsSteel, 1), new Object[]{"###", "X X", "X X", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.armourPlateSteel});
            RecipeListener.addAnvilRecipe(new class_31(ItemListener.bootsSteel, 1), new Object[]{"# #", "# #", Character.valueOf('#'), ItemListener.steel});
        }
        if (ConfigListener.wolvesGlass.small_tweaks.steelBlock.booleanValue()) {
            RecipeListener.addAnvilRecipe(new class_31((class_17)BlockListener.blockOfSteel, 1), new Object[]{"###", "###", "###", Character.valueOf('#'), ItemListener.steel});
        }
        RecipeListener.addAnvilRecipe(new class_31(class_17.field_1855, 48), new Object[]{"#X#", "#X#", "#X#", Character.valueOf('#'), ItemListener.steel, Character.valueOf('X'), ItemListener.haft});
        if (isNewFrontierCraftPresent) {
            NFCRecipes.addAnvilRecipes();
        }
    }

    private static void addShapelessAnvilRecipes() {
        RecipeListener.addShapelessAnvilRecipe(new class_31(ItemListener.broadHeadArrowhead, 4), new Object[]{ItemListener.steel});
        RecipeListener.addShapelessAnvilRecipe(new class_31(BlockListener.omniSlab, 1, 0), new Object[]{class_17.field_1945});
    }

    private static void addCauldronRecipes() {
        RecipeListener.addCauldronRecipe(new class_31(ItemListener.netherCoal, 2), new class_31[]{new class_31(ItemListener.hellfireDust, 4), new class_31(ItemListener.coalDust, 1)});
        RecipeListener.addCauldronRecipe(new class_31(ItemListener.concentratedHellfire, 1), new class_31[]{new class_31(ItemListener.hellfireDust, 8)});
        if (ConfigListener.wolvesGlass.small_tweaks.deactivateDung.booleanValue()) {
            RecipeListener.addCauldronRecipe(new class_31(ItemListener.tannedLeather, 1), new class_31[]{new class_31(class_17.field_1831, 1), new class_31(ItemListener.scouredLeather, 1)});
            RecipeListener.addCauldronRecipe(new class_31(class_17.field_1876, 8, 12), new class_31[]{new class_31(class_17.field_1831, 1), new class_31(class_17.field_1876, 8, 0)});
        } else {
            RecipeListener.addCauldronRecipe(new class_31(ItemListener.tannedLeather, 1), new class_31[]{new class_31(ItemListener.dung, 1), new class_31(ItemListener.scouredLeather, 1)});
            RecipeListener.addCauldronRecipe(new class_31(class_17.field_1876, 8, 12), new class_31[]{new class_31(ItemListener.dung, 1), new class_31(class_17.field_1876, 8, 0)});
        }
        RecipeListener.addCauldronRecipe(new class_31(ItemListener.donut, 4), new class_31[]{new class_31(ItemListener.flour, 1)});
        for (int i = 0; i < 15; ++i) {
            RecipeListener.addCauldronRecipe(new class_31(class_17.field_1876, 8, class_3.method_1((int)i)), new class_31[]{new class_31(class_124.field_423, 1, i), new class_31(class_17.field_1876, 8, 0)});
        }
        RecipeListener.addCauldronRecipe(new class_31(class_17.field_1887), new class_31[]{new class_31(class_17.field_1826, 4), new class_31(class_124.field_386, 5)});
        RecipeListener.addCauldronRecipe(new class_31(class_17.field_1876), new class_31[]{new class_31(class_124.field_384, 4)});
        RecipeListener.addCauldronRecipe(new class_31(class_124.field_423, 1, 2), new class_31[]{new class_31(class_17.field_1870)});
        if (!isHarderThanWolvesPresent) {
            RecipeListener.addCauldronRecipe(new class_31(ItemListener.soulFilter, 1), new class_31[]{new class_31(ItemListener.hempCloth, 2), new class_31(class_17.field_1905, 1)});
        }
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(class_124.field_406, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(ItemListener.tannedLeather, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(ItemListener.scouredLeather, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(ItemListener.belt, 2)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(class_124.field_424, 8)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(ItemListener.strap, 8)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(class_17.field_1876, 16)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(class_124.field_385, 16)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 1), new class_31[]{new class_31(class_124.field_384, 64)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 5), new class_31[]{new class_31(class_124.field_395, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 8), new class_31[]{new class_31(class_124.field_396, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 7), new class_31[]{new class_31(class_124.field_397, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.glue, 4), new class_31[]{new class_31(class_124.field_398, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.tallow, 1), new class_31[]{new class_31(class_124.field_444, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.tallow, 1), new class_31[]{new class_31(class_124.field_443, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.tallow, 1), new class_31[]{new class_31(ItemListener.wolfCooked, 1)});
        RecipeListener.addStokedCauldronRecipe(new class_31(ItemListener.tallow, 1), new class_31[]{new class_31(ItemListener.wolfRaw, 1)});
        if (isNewFrontierCraftPresent) {
            NFCRecipes.addCauldronRecipes();
        }
    }

    private static void addMillingRecipes() {
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemRegistry.INSTANCE.getId((Object)class_124.field_393), new class_31(ItemListener.flour, 1));
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemRegistry.INSTANCE.getId((Object)class_124.field_406), new class_31(ItemListener.scouredLeather, 1));
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemListener.NAMESPACE.id("hemp"), new class_31(ItemListener.hempFibers, 4));
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemRegistry.INSTANCE.getId((Object)class_124.field_410), new class_31(class_124.field_425, 1));
        if (!isHarderThanWolvesPresent) {
            MillingRecipeRegistry.getInstance().addMillingRecipe(BlockRegistry.INSTANCE.getId((Object)class_17.field_1904), new class_31(ItemListener.groundNetherrack, 1));
        }
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemRegistry.INSTANCE.getId((Object)class_124.field_424), new class_31(class_124.field_423, 3, 15));
        MillingRecipeRegistry.getInstance().addMillingRecipe(ItemRegistry.INSTANCE.getId((Object)class_124.field_476), new class_31(ItemListener.coalDust, 1));
        MillingRecipeRegistry.getInstance().addMillingRecipe(BlockRegistry.INSTANCE.getId((Object)class_17.field_1879), new class_31(class_124.field_423, 2, 1));
        MillingRecipeRegistry.getInstance().addMillingRecipe(BlockRegistry.INSTANCE.getId((Object)class_17.field_1878), new class_31(class_124.field_423, 2, 11));
    }

    private static void addTurntableRecipes() {
        TurntableRecipeRegistry.getInstance().addTurntableRecipe(new TurntableRecipe(new TurntableInput(class_17.field_1871, 0), new TurntableResult(new TurntableOutput(BlockListener.unfiredPottery, 8, 0), new TurntableByproduct(class_124.field_409, 1))));
        TurntableRecipeRegistry.getInstance().addTurntableRecipe(new TurntableRecipe(new TurntableInput(BlockListener.unfiredPottery, 0), new TurntableResult(new TurntableOutput(BlockListener.unfiredPottery, 4, 1), new TurntableByproduct(class_124.field_409, 1))));
        TurntableRecipeRegistry.getInstance().addTurntableRecipe(new TurntableRecipe(new TurntableInput(BlockListener.unfiredPottery, 1), new TurntableResult(new TurntableOutput(BlockListener.unfiredPottery, 4, 2), new TurntableByproduct(ItemListener.nothing, 0))));
        TurntableRecipeRegistry.getInstance().addTurntableRecipe(new TurntableRecipe(new TurntableInput(BlockListener.unfiredPottery, 2), new TurntableResult(new TurntableOutput((class_17)BlockListener.obstructionBlock, 4, 0), new TurntableByproduct(class_124.field_409, 2))));
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1903.field_1915, new Integer[][]{{0, 1, 2, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1908.field_1915, new Integer[][]{{0, 1, 2, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1910.field_1915, new Integer[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1911.field_1915, new Integer[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {8, 9, 10, 11}, {12, 13, 14, 15}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1874.field_1915, new Integer[][]{{4, 2, 5, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1843.field_1915, new Integer[][]{{4, 2, 5, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1850.field_1915, new Integer[][]{{4, 2, 5, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1851.field_1915, new Integer[][]{{4, 2, 5, 3}});
        TurntableRecipeRegistry.getInstance().addRotation(class_17.field_1837.field_1915, new Integer[][]{{4, 2, 5, 3}});
    }

    private static void addCrucibleRecipes() {
        if (!isHarderThanWolvesPresent) {
            if (isNewFrontierCraftPresent) {
                NFCRecipes.addCrucibleRecipes();
            } else {
                RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 4), new class_31[]{new class_31(class_124.field_478, 3), new class_31(ItemListener.concentratedHellfire), new class_31(ItemListener.coalDust)});
            }
        }
        if (isNewFrontierCraftPresent) {
            RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 4), new class_31[]{new class_31(class_17.field_1883)});
        } else {
            RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 9), new class_31[]{new class_31(class_17.field_1883)});
        }
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 8), new class_31[]{new class_31(class_124.field_431, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 7), new class_31[]{new class_31(class_124.field_432, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 6), new class_31[]{new class_31(class_124.field_454)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 6), new class_31[]{new class_31(class_17.field_1855, 16)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 5), new class_31[]{new class_31(class_124.field_430, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 5), new class_31[]{new class_31(class_124.field_452)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 5), new class_31[]{new class_31(class_124.field_414)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 5), new class_31[]{new class_31(class_124.field_415)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 4), new class_31[]{new class_31(class_124.field_433, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 4), new class_31[]{new class_31(class_124.field_417)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 4), new class_31[]{new class_31((class_124)class_124.field_457)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_449)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_451)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_450)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_407)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(ItemListener.bucketCement)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_470, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 3), new class_31[]{new class_31(class_124.field_471, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 2), new class_31[]{new class_31(class_124.field_480, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 2), new class_31[]{new class_31(class_124.field_389, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 2), new class_31[]{new class_31((class_124)class_124.field_458)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 1), new class_31[]{new class_31(class_124.field_469, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 1), new class_31[]{new class_31(class_124.field_472, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 1), new class_31[]{new class_31(class_17.field_1842)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 1), new class_31[]{new class_31(BlockListener.detectorRailWood)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_478, 1), new class_31[]{new class_31(BlockListener.detectorRailObsidian)});
        if (isNewFrontierCraftPresent) {
            RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 4), new class_31[]{new class_31(class_17.field_1882)});
        } else {
            RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 9), new class_31[]{new class_31(class_17.field_1882)});
        }
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 9), new class_31[]{new class_31(class_17.field_1882)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 8), new class_31[]{new class_31(class_124.field_439, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 7), new class_31[]{new class_31(class_124.field_440, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 5), new class_31[]{new class_31(class_124.field_438, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 4), new class_31[]{new class_31(class_124.field_441, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 4), new class_31[]{new class_31(class_124.field_419)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 3), new class_31[]{new class_31(class_124.field_382, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 3), new class_31[]{new class_31(class_124.field_383, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 2), new class_31[]{new class_31(class_124.field_380, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 2), new class_31[]{new class_31(class_124.field_391, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 1), new class_31[]{new class_31(class_124.field_381, 1, -1)});
        RecipeListener.addCrucibleRecipe(new class_31(class_124.field_479, 1), new class_31[]{new class_31(class_17.field_1841)});
        if (ConfigListener.wolvesGlass.difficulty.difficultSoulforgedSteelRecipes.booleanValue()) {
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 26), new class_31[]{new class_31(ItemListener.chestPlateSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 29), new class_31[]{new class_31(ItemListener.leggingsSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 18), new class_31[]{new class_31(ItemListener.helmetSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 12), new class_31[]{new class_31(ItemListener.bootsSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 5), new class_31[]{new class_31(ItemListener.refinedPickAxe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 7), new class_31[]{new class_31(ItemListener.refinedAxe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 6), new class_31[]{new class_31(ItemListener.refinedSword, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 3), new class_31[]{new class_31(ItemListener.refinedHoe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 6), new class_31[]{new class_31(ItemListener.refinedShovel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 3), new class_31[]{new class_31(ItemListener.armourPlateSteel)});
        } else {
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 8), new class_31[]{new class_31(ItemListener.chestPlateSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 7), new class_31[]{new class_31(BlockListener.anvil)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 7), new class_31[]{new class_31(ItemListener.leggingsSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 5), new class_31[]{new class_31(ItemListener.helmetSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 5), new class_31[]{new class_31(ItemListener.refinedAxe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 4), new class_31[]{new class_31(ItemListener.bootsSteel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 3), new class_31[]{new class_31(ItemListener.refinedPickAxe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 2), new class_31[]{new class_31(ItemListener.refinedSword, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 2), new class_31[]{new class_31(ItemListener.refinedHoe, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 1), new class_31[]{new class_31(ItemListener.refinedShovel, 1, -1)});
            RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 1), new class_31[]{new class_31(ItemListener.armourPlateSteel)});
        }
        RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 7), new class_31[]{new class_31(BlockListener.anvil)});
        RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 1), new class_31[]{new class_31(ItemListener.broadHeadArrowhead, 4)});
        RecipeListener.addCrucibleRecipe(new class_31(ItemListener.steel, 1), new class_31[]{new class_31(ItemListener.broadHeadArrow, 16)});
    }

    private static void addHopperRecipes() {
        HopperPurifyingRecipeRegistry.getInstance().addHopperHauntingRecipe(ItemListener.NAMESPACE.id("groundNetherrack"), new class_31(ItemListener.hellfireDust, 1));
    }

    private static void addSawingRecipes() {
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(class_17.field_1831, 1, 0), new class_31(class_17.field_1949, 4));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(class_17.field_1831, 1, 1), new class_31(class_17.field_1949, 4));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(class_17.field_1831, 1, 2), new class_31(class_17.field_1949, 4));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(class_17.field_1949, 1), new class_31(BlockListener.omniSlab, 2, 1));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 1), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 3), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 5), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 7), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 9), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.omniSlab, 1, 11), new class_31(BlockListener.moulding, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 0), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 1), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 2), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 3), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 4), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 5), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 6), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 7), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 8), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 9), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 10), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.moulding, 1, 11), new class_31(BlockListener.corner, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 0), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 1), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 2), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 3), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 4), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 5), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 6), new class_31(ItemListener.gear, 2));
        SawingRecipeRegistry.getInstance().addSawingRecipe(new class_31(BlockListener.corner, 1, 7), new class_31(ItemListener.gear, 2));
    }

    private static void addDebugRecipes() {
    }
}

