/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.utils;

import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_142;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;

public class InventoryHandler {
    public static void clearInventoryContents(class_134 inventory) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            class_31 ItemInstance = inventory.method_954(slot);
            if (ItemInstance == null) continue;
            inventory.method_950(slot, null);
        }
    }

    public static void ejectInventoryContents(class_18 world, int x, int y, int z, class_134 inventory) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            class_31 itemStack = inventory.method_954(slot);
            if (itemStack == null) continue;
            float xOffset = world.field_214.nextFloat() * 0.7f + 0.15f;
            float yOffset = world.field_214.nextFloat() * 0.7f + 0.15f;
            float zOffset = world.field_214.nextFloat() * 0.7f + 0.15f;
            while (itemStack.field_751 > 0) {
                int randomStackSize = world.field_214.nextInt(21) + 10;
                if (randomStackSize > itemStack.field_751) {
                    randomStackSize = itemStack.field_751;
                }
                itemStack.field_751 -= randomStackSize;
                class_142 itemEntity = new class_142(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new class_31(itemStack.method_694(), randomStackSize, itemStack.method_722()));
                float randomVelocityFactor = 0.05f;
                itemEntity.field_1603 = (float)world.field_214.nextGaussian() * randomVelocityFactor;
                itemEntity.field_1604 = (float)world.field_214.nextGaussian() * randomVelocityFactor + 0.2f;
                itemEntity.field_1605 = (float)world.field_214.nextGaussian() * randomVelocityFactor;
                itemEntity.field_566 = 10;
                world.method_210((class_57)itemEntity);
            }
        }
    }

    public static void consumeItemsInInventory(class_134 inventory, Identifier itemId, int itemDamage, int itemCount) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            class_124 tempItem;
            Identifier tempIdentifier;
            class_31 tempItemInstance = inventory.method_954(slot);
            if (tempItemInstance == null || (tempIdentifier = ItemRegistry.INSTANCE.getId((Object)(tempItem = tempItemInstance.method_694()))) != itemId || itemDamage != -1 && tempItemInstance.method_722() != itemDamage) continue;
            if (tempItemInstance.field_751 >= itemCount) {
                InventoryHandler.decreaseStackSize(inventory, slot, itemCount);
                return;
            }
            itemCount -= tempItemInstance.field_751;
            inventory.method_950(slot, null);
        }
    }

    public static class_31 decreaseStackSize(class_134 inventory, int slot, int amount) {
        if (inventory.method_954(slot) != null) {
            if (inventory.method_954((int)slot).field_751 <= amount) {
                class_31 itemInstance = inventory.method_954(slot);
                inventory.method_950(slot, null);
                return itemInstance;
            }
            class_31 splitStack = inventory.method_954(slot).method_695(amount);
            if (inventory.method_954((int)slot).field_751 == 0) {
                inventory.method_950(slot, null);
            } else {
                inventory.method_947();
            }
            return splitStack;
        }
        return null;
    }

    public static int getFirstOccupiedStackExcludingItem(class_134 inventory, Identifier excludedItemId) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            if (inventory.method_954(slot) == null || ItemRegistry.INSTANCE.getId((Object)inventory.method_954(slot).method_694()) == excludedItemId) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(class_134 inventory, Identifier itemId) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            if (inventory.method_954(slot) == null || ItemRegistry.INSTANCE.getId((Object)inventory.method_954(slot).method_694()) != itemId) continue;
            return slot;
        }
        return -1;
    }

    public static int itemCountInInventory(class_134 inventory, Identifier itemId, int itemDamage) {
        int itemCount = 0;
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            class_31 tempStack = inventory.method_954(slot);
            if (tempStack == null || ItemRegistry.INSTANCE.getId((Object)tempStack.method_694()) != itemId || itemDamage != -1 && tempStack.method_722() != itemDamage) continue;
            itemCount += inventory.method_954((int)slot).field_751;
        }
        return itemCount;
    }

    public static int getOccupiedStacksCount(class_134 inventory) {
        int count = 0;
        for (int i = 0; i < inventory.method_948(); ++i) {
            if (inventory.method_954(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static boolean addSingleItemToInventory(class_134 inventory, int itemId, int itemDamage) {
        class_31 ItemInstance = new class_31(itemId, 1, itemDamage);
        return InventoryHandler.addItemInstanceToInventory(inventory, ItemInstance);
    }

    public static boolean addItemInstanceToInventory(class_134 inventory, class_31 itemInstance) {
        int slot;
        if (!itemInstance.method_720()) {
            itemInstance.field_751 = InventoryHandler.storePartialItemStack(inventory, itemInstance);
            if (itemInstance.field_751 == 0) {
                return true;
            }
        }
        if ((slot = InventoryHandler.getFirstEmptyStack(inventory)) >= 0) {
            inventory.method_950(slot, itemInstance);
            return true;
        }
        return false;
    }

    private static int getFirstEmptyStack(class_134 inventory) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            if (inventory.method_954(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    private static int storePartialItemStack(class_134 inventory, class_31 itemStack) {
        class_31 tempStack;
        int insertedItems;
        class_124 item = itemStack.method_694();
        int count = itemStack.field_751;
        int slot = InventoryHandler.findValidSlotForItem(inventory, itemStack);
        if (slot < 0) {
            slot = InventoryHandler.getFirstEmptyStack(inventory);
        }
        if (slot < 0) {
            return count;
        }
        if (inventory.method_954(slot) == null) {
            inventory.method_950(slot, new class_31(item, 0, itemStack.method_722()));
        }
        if ((insertedItems = count) > (tempStack = inventory.method_954(slot)).method_709() - tempStack.field_751) {
            insertedItems = tempStack.method_709() - tempStack.field_751;
        }
        if (insertedItems > inventory.method_953() - tempStack.field_751) {
            insertedItems = inventory.method_953() - tempStack.field_751;
        }
        if (insertedItems != 0) {
            count -= insertedItems;
            tempStack.field_751 += insertedItems;
            inventory.method_950(slot, tempStack);
        }
        return count;
    }

    private static int findValidSlotForItem(class_134 inventory, class_31 itemStack) {
        for (int slot = 0; slot < inventory.method_948(); ++slot) {
            class_31 tempStack = inventory.method_954(slot);
            if (tempStack == null || tempStack.field_753 != itemStack.field_753 || !tempStack.method_715() || tempStack.field_751 >= tempStack.method_709() || tempStack.field_751 >= inventory.method_953() || tempStack.method_719() && tempStack.method_722() != itemStack.method_722()) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedSlotCountWithinBounds(class_134 inventory, int minimumSlot, int maximumSlot) {
        int slotCount = 0;
        for (int slot = minimumSlot; slot < inventory.method_948() && slot <= maximumSlot; ++slot) {
            if (inventory.method_954(slot) == null) continue;
            ++slotCount;
        }
        return slotCount;
    }

    public static boolean addItemWithinSlotBounds(class_134 inventory, class_31 itemStack, int minimumSlot, int maximumSlot) {
        int slot;
        if (!itemStack.method_720()) {
            itemStack.field_751 = InventoryHandler.storePartialItemInstanceWithinSlotBounds(inventory, itemStack, minimumSlot, maximumSlot);
            if (itemStack.field_751 == 0) {
                return true;
            }
        }
        if ((slot = InventoryHandler.getFirstEmptySlotWithinBounds(inventory, minimumSlot, maximumSlot)) >= 0) {
            inventory.method_950(slot, itemStack);
            return true;
        }
        return false;
    }

    private static int getFirstEmptySlotWithinBounds(class_134 inventory, int minimumSlot, int maximumSlot) {
        for (int slot = minimumSlot; slot < inventory.method_948() && slot <= maximumSlot; ++slot) {
            if (inventory.method_954(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    private static int storePartialItemInstanceWithinSlotBounds(class_134 inventory, class_31 itemStack, int minimumSlot, int maximumSlot) {
        class_31 tempStack;
        int insertedItems;
        int itemId = itemStack.field_753;
        int count = itemStack.field_751;
        int slot = InventoryHandler.findValidSlotWithinBounds(inventory, itemStack, minimumSlot, maximumSlot);
        if (slot < 0) {
            slot = InventoryHandler.getFirstEmptySlotWithinBounds(inventory, minimumSlot, maximumSlot);
        }
        if (slot < 0) {
            return count;
        }
        if (inventory.method_954(slot) == null) {
            inventory.method_950(slot, new class_31(itemId, 0, itemStack.method_722()));
        }
        if ((insertedItems = count) > (tempStack = inventory.method_954(slot)).method_709() - tempStack.field_751) {
            insertedItems = tempStack.method_709() - tempStack.field_751;
        }
        if (insertedItems > inventory.method_953() - tempStack.field_751) {
            insertedItems = inventory.method_953() - tempStack.field_751;
        }
        if (insertedItems != 0) {
            count -= insertedItems;
            tempStack.field_751 += insertedItems;
            inventory.method_950(slot, tempStack);
        }
        return count;
    }

    private static int findValidSlotWithinBounds(class_134 inventory, class_31 itemInstance, int minimumSlot, int maximumSlot) {
        for (int slot = minimumSlot; slot < inventory.method_948() && slot <= maximumSlot; ++slot) {
            class_31 tempStack = inventory.method_954(slot);
            if (tempStack == null || tempStack.field_753 != itemInstance.field_753 || !tempStack.method_715() || tempStack.field_751 >= tempStack.method_709() || tempStack.field_751 >= inventory.method_953() || tempStack.method_719() && tempStack.method_722() != itemInstance.method_722()) continue;
            return slot;
        }
        return -1;
    }
}

