/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.GearboxBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class AxleBlock
extends TemplateBlock {
    public AxleBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
    }

    public int method_1607(int iSide) {
        if (iSide == 2 || iSide == 3) {
            return TextureListener.axle_side;
        }
        if (iSide == 0 || iSide == 1) {
            return TextureListener.axle_vertical;
        }
        return TextureListener.axle_horizontal;
    }

    public int method_1626(class_14 iblockaccess, int i, int j, int k, int iSide) {
        int iAxis = this.getAxisAlignment(iblockaccess, i, j, k);
        if (iAxis == 0) {
            if (iSide == 0 || iSide == 1) {
                return TextureListener.axle_side;
            }
            return TextureListener.axle_vertical;
        }
        if (iAxis == 1) {
            if (iSide == 2 || iSide == 3) {
                return TextureListener.axle_side;
            }
            if (iSide == 0 || iSide == 1) {
                return TextureListener.axle_vertical;
            }
            return TextureListener.axle_horizontal;
        }
        if (iSide == 4 || iSide == 5) {
            return TextureListener.axle_side;
        }
        return TextureListener.axle_horizontal;
    }

    public int method_1565() {
        return 1;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        this.SetAxisAlignmentBasedOnFacing(world, i, j, k, iFacing);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        this.SetPowerLevel(world, i, j, k, 0);
        world.method_216(i, j, k, BlockListener.axleBlock.field_1915, this.method_1565());
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        this.ValidatePowerLevel(world, i, j, k);
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        int iAxis = this.getAxisAlignment((class_14)world, i, j, k);
        switch (iAxis) {
            case 0: {
                return class_25.method_94((double)((float)i + 0.5f - 0.125f), (double)j, (double)((float)k + 0.5f - 0.125f), (double)((float)i + 0.5f + 0.125f), (double)((float)j + 1.0f), (double)((float)k + 0.5f + 0.125f));
            }
            case 1: {
                return class_25.method_94((double)((float)i + 0.5f - 0.125f), (double)((float)j + 0.5f - 0.125f), (double)k, (double)((float)i + 0.5f + 0.125f), (double)((float)j + 0.5f + 0.125f), (double)((float)k + 1.0f));
            }
        }
        return class_25.method_94((double)i, (double)((float)j + 0.5f - 0.125f), (double)((float)k + 0.5f - 0.125f), (double)((float)i + 1.0f), (double)((float)j + 0.5f + 0.125f), (double)((float)k + 0.5f + 0.125f));
    }

    public void method_1616(class_14 iBlockAccess, int i, int j, int k) {
        int iAxis = this.getAxisAlignment(iBlockAccess, i, j, k);
        switch (iAxis) {
            case 0: {
                this.method_1578(0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f);
                break;
            }
            case 1: {
                this.method_1578(0.375f, 0.375f, 0.0f, 0.625f, 0.625f, 1.0f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.375f, 0.375f, 1.0f, 0.625f, 0.625f);
            }
        }
    }

    public void method_1605() {
        this.method_1578(0.375f, 0.375f, 0.0f, 0.625f, 0.625f, 1.0f);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        this.ValidatePowerLevel(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.GetPowerLevel((class_14)world, i, j, k) > 0) {
            this.EmitAxleParticles(world, i, j, k, random);
        }
    }

    public int getAxisAlignment(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) >> 2;
    }

    public void SetAxisAlignmentBasedOnFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iAxis = switch (iFacing) {
            case 0, 1 -> 0;
            case 2, 3 -> 1;
            default -> 2;
        };
        int iMetaData = world.method_1778(i, j, k) & 3;
        world.method_215(i, j, k, iMetaData |= iAxis << 2);
        world.method_243(i, j, k);
    }

    public int GetPowerLevel(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 3;
    }

    public void SetPowerLevel(class_18 world, int i, int j, int k, int iPowerLevel) {
        if (world.field_180) {
            return;
        }
        int iMetaData = world.method_1778(i, j, k) & 0xC;
        world.method_215(i, j, k, iMetaData |= (iPowerLevel &= 3));
        world.method_243(i, j, k);
    }

    public boolean IsAxleOrientedTowardsFacing(class_14 iBlockAccess, int i, int j, int k, int iFacing) {
        int iAxis = this.getAxisAlignment(iBlockAccess, i, j, k);
        switch (iAxis) {
            case 0: {
                if (iFacing != 0 && iFacing != 1) break;
                return true;
            }
            case 1: {
                if (iFacing != 2 && iFacing != 3) break;
                return true;
            }
            default: {
                if (iFacing != 4 && iFacing != 5) break;
                return true;
            }
        }
        return false;
    }

    public void BreakAxle(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.axleBlock.field_1915 || world.method_1776(i, j, k) == BlockListener.nonCollidingAxleBlock.field_1915) {
            int iTemp;
            for (iTemp = 0; iTemp < 5; ++iTemp) {
                UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.hempFibers.field_461, 0);
            }
            for (iTemp = 0; iTemp < 2; ++iTemp) {
                UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_124.field_377.field_461, 0);
            }
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
            }
            world.method_229(i, j, k, 0);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    private void ValidatePowerLevel(class_18 world, int i, int j, int k) {
        int currentPower = this.GetPowerLevel((class_14)world, i, j, k);
        int axis = this.getAxisAlignment((class_14)world, i, j, k);
        if (currentPower != 3) {
            BlockPosition[] potentialSources = new BlockPosition[]{new BlockPosition(i, j, k), new BlockPosition(i, j, k)};
            switch (axis) {
                case 0: {
                    potentialSources[0].AddFacingAsOffset(0);
                    potentialSources[1].AddFacingAsOffset(1);
                    break;
                }
                case 1: {
                    potentialSources[0].AddFacingAsOffset(2);
                    potentialSources[1].AddFacingAsOffset(3);
                    break;
                }
                default: {
                    potentialSources[0].AddFacingAsOffset(4);
                    potentialSources[1].AddFacingAsOffset(5);
                }
            }
            int maxNeighborPower = 0;
            int greaterPowerNeighbors = 0;
            for (int tempSource = 0; tempSource < 2; ++tempSource) {
                int tempAxis;
                int tempId = world.method_1776(potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
                if (tempId != BlockListener.axleBlock.field_1915 && tempId != BlockListener.nonCollidingAxleBlock.field_1915 || (tempAxis = this.getAxisAlignment((class_14)world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k)) != axis) continue;
                int tempPowerLevel = this.GetPowerLevel((class_14)world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
                if (tempPowerLevel > maxNeighborPower) {
                    maxNeighborPower = tempPowerLevel;
                }
                if (tempPowerLevel <= currentPower) continue;
                ++greaterPowerNeighbors;
            }
            if (greaterPowerNeighbors >= 2) {
                this.BreakAxle(world, i, j, k);
                return;
            }
            int newPower = currentPower;
            if (maxNeighborPower > currentPower) {
                if (maxNeighborPower == 1) {
                    this.BreakAxle(world, i, j, k);
                    return;
                }
                newPower = maxNeighborPower - 1;
            } else {
                newPower = 0;
            }
            if (newPower != currentPower) {
                this.SetPowerLevel(world, i, j, k, newPower);
            }
        }
    }

    private void EmitAxleParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 2; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 0.625f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    public void Overpower(class_18 world, int i, int j, int k) {
        int iCurrentPower = this.GetPowerLevel((class_14)world, i, j, k);
        int iAxis = this.getAxisAlignment((class_14)world, i, j, k);
        BlockPosition[] potentialSources = new BlockPosition[]{new BlockPosition(i, j, k), new BlockPosition(i, j, k)};
        switch (iAxis) {
            case 0: {
                potentialSources[0].AddFacingAsOffset(0);
                potentialSources[1].AddFacingAsOffset(1);
                break;
            }
            case 1: {
                potentialSources[0].AddFacingAsOffset(2);
                potentialSources[1].AddFacingAsOffset(3);
                break;
            }
            default: {
                potentialSources[0].AddFacingAsOffset(4);
                potentialSources[1].AddFacingAsOffset(5);
            }
        }
        for (int tempSource = 0; tempSource < 2; ++tempSource) {
            int iTempid = world.method_1776(potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
            if (iTempid == BlockListener.axleBlock.field_1915 || iTempid == BlockListener.nonCollidingAxleBlock.field_1915) {
                int iTempPowerLevel;
                int iTempAxis = this.getAxisAlignment((class_14)world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
                if (iTempAxis != iAxis || (iTempPowerLevel = this.GetPowerLevel((class_14)world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k)) >= iCurrentPower) continue;
                this.Overpower(world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
                continue;
            }
            if (iTempid != BlockListener.gearBox.field_1915) continue;
            ((GearboxBlock)BlockListener.gearBox).Overpower(world, potentialSources[tempSource].i, potentialSources[tempSource].j, potentialSources[tempSource].k);
        }
    }
}

