/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.kozibrodka.wolves.block.entity.CementBlockEntity;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_55;
import net.minecraft.class_67;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlas;
import net.modificationstation.stationapi.api.client.texture.atlas.Atlases;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class)
public class CementBlock
extends TemplateBlockWithEntity
implements BlockWithWorldRenderer {
    private final int iCementTexture = 15;
    private final int iCementPartiallyDryTexture = 16;
    public static final int iMaxCementSpreadDist = 16;
    public static final int iCementTicksToDry = 12;
    public static final int iCementTicksToPartiallyDry = 8;
    boolean[] tempSpreadToSideFlags;
    int[] tempClosestDownslopeToSideDist;

    public CementBlock(Identifier iid) {
        super(iid, BlockListener.fcCementMaterial);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.method_1587(100.0f);
        this.method_1590(255);
        this.method_1580(class_17.field_1936);
        this.field_1914 = 15;
        this.tempSpreadToSideFlags = new boolean[4];
        this.tempClosestDownslopeToSideDist = new int[4];
        this.method_1584(true);
    }

    public int method_1626(class_14 iblockaccess, int i, int j, int k, int l) {
        if (this.IsCementPartiallyDry(iblockaccess, i, j, k)) {
            return TextureListener.cement_dry;
        }
        return TextureListener.cement;
    }

    protected class_55 method_1251() {
        return new CementBlockEntity();
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1571(int i, boolean flag) {
        return flag && i == 0;
    }

    public boolean method_1573(class_14 iblockaccess, int i, int j, int k, int l) {
        class_15 new_material = iblockaccess.method_1779(i, j, k);
        if (new_material == this.field_1900) {
            return false;
        }
        if (new_material == class_15.field_997) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.method_1573(iblockaccess, i, j, k, l);
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j + 1, k) != this.field_1915) {
            return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 0.5f), (double)(k + 1));
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public int method_1601(int i, Random random) {
        return 0;
    }

    public int method_1603(Random random) {
        return 0;
    }

    public int method_1565() {
        return 20;
    }

    public float method_1604(class_14 iBlockAccess, int i, int j, int k) {
        float f1;
        float f = iBlockAccess.method_1782(i, j, k);
        return f > (f1 = iBlockAccess.method_1782(i, j + 1, k)) ? f : f1;
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        if (world.method_1776(i, j, k) == this.field_1915) {
            world.method_216(i, j, k, this.field_1915, this.method_1565());
            if (world.method_265(i, j, k)) {
                this.SetCementPowered(world, i, j, k, true);
            }
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (!this.IsCementPartiallyDry((class_14)world, i, j, k) && random.nextInt(250) == 0) {
            world.method_150((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "mob.ghast.moan", 0.5f, 2.6f + (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.8f);
        }
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bNewPowerState;
        int cementDist = this.GetCementSpreadDist((class_14)world, i, j, k);
        boolean bOldPowerState = this.IsCementPowered((class_14)world, i, j, k);
        if (bOldPowerState != (bNewPowerState = world.method_265(i, j, k))) {
            this.SetCementPowered(world, i, j, k, bNewPowerState);
        }
        if (cementDist > 0) {
            int newCementDist = -100;
            newCementDist = this.CheckForLesserSpreadDist(world, i - 1, j, k, newCementDist);
            newCementDist = this.CheckForLesserSpreadDist(world, i + 1, j, k, newCementDist);
            newCementDist = this.CheckForLesserSpreadDist(world, i, j, k - 1, newCementDist);
            newCementDist = this.CheckForLesserSpreadDist(world, i, j, k + 1, newCementDist);
            newCementDist = (newCementDist = this.CheckForLesserSpreadDist(world, i, j + 1, k, newCementDist)) < 0 ? -1 : ++newCementDist;
            int cementDistUp = this.GetCementSpreadDist((class_14)world, i, j + 1, k);
            if (cementDistUp >= 0 && cementDistUp < newCementDist) {
                newCementDist = cementDistUp + 1;
            }
            if (newCementDist > 0 && newCementDist < cementDist) {
                cementDist = newCementDist;
                this.SetCementSpreadDist(world, i, j, k, cementDist);
                this.SetCementDryTime(world, i, j, k, 0);
            }
        } else if (cementDist == 0 && bNewPowerState) {
            this.SetCementDryTime(world, i, j, k, 0);
        }
        int iDryTime = this.GetCementDryTime((class_14)world, i, j, k);
        int minDryTime = this.CheckNeighboursCloserToSourceForMinDryTime(world, i, j, k);
        if (minDryTime <= ++iDryTime) {
            iDryTime = minDryTime <= 0 ? 0 : minDryTime - 1;
        }
        if (iDryTime > 12) {
            world.method_229(i, j, k, class_17.field_1945.field_1915);
        } else {
            this.SetCementDryTime(world, i, j, k, iDryTime);
            world.method_216(i, j, k, this.field_1915, this.method_1565());
            if (this.IsBlockOpenToSpread(world, i, j - 1, k)) {
                int targetCementDist = cementDist + 1;
                if (targetCementDist <= 16) {
                    world.method_229(i, j - 1, k, this.field_1915);
                    this.SetCementSpreadDist(world, i, j - 1, k, targetCementDist);
                }
            } else if (cementDist >= 0 && (cementDist == 0 || this.blockBlocksFlow(world, i, j - 1, k))) {
                boolean[] spreadToSideFlags = this.CheckSideBlocksForPotentialSpread(world, i, j, k);
                int spreadDist = cementDist + 1;
                if (spreadDist <= 16) {
                    if (spreadToSideFlags[0]) {
                        this.AttemptToSpreadToBlock(world, i - 1, j, k, spreadDist);
                    }
                    if (spreadToSideFlags[1]) {
                        this.AttemptToSpreadToBlock(world, i + 1, j, k, spreadDist);
                    }
                    if (spreadToSideFlags[2]) {
                        this.AttemptToSpreadToBlock(world, i, j, k - 1, spreadDist);
                    }
                    if (spreadToSideFlags[3]) {
                        this.AttemptToSpreadToBlock(world, i, j, k + 1, spreadDist);
                    }
                }
            }
        }
    }

    public boolean IsCementPowered(class_14 blockAccess, int i, int j, int k) {
        int iMetaData = blockAccess.method_1778(i, j, k);
        return (iMetaData & 1) > 0;
    }

    private void SetCementPowered(class_18 world, int i, int j, int k, boolean bPowered) {
        boolean bOldState = this.IsCementPowered((class_14)world, i, j, k);
        if (bOldState != bPowered) {
            int iMetaData = world.method_1778(i, j, k);
            if (bPowered) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "mob.ghast.scream", 1.0f, world.field_214.nextFloat() * 0.4f + 0.8f);
                iMetaData |= 1;
            } else {
                iMetaData &= 0xFFFFFFFE;
            }
            world.method_215(i, j, k, iMetaData);
            world.method_243(i, j, k);
        }
    }

    public float GetRenderHeight(class_14 blockAccess, int i, int j, int k) {
        float fRenderHeight = 1.0f;
        if (blockAccess.method_1779(i, j, k) == this.field_1900) {
            int dist = this.GetCementSpreadDist(blockAccess, i, j, k);
            fRenderHeight = (float)(dist + 1) / 18.0f;
            fRenderHeight = this.IsCementPartiallyDry(blockAccess, i, j, k) ? (fRenderHeight *= 0.1f) : (fRenderHeight *= 0.5f);
        }
        return fRenderHeight;
    }

    public int GetCementSpreadDist(class_14 blockAccess, int i, int j, int k) {
        if (blockAccess.method_1779(i, j, k) != this.field_1900) {
            return -1;
        }
        CementBlockEntity tileEntity = (CementBlockEntity)blockAccess.method_1777(i, j, k);
        return tileEntity.spreadDist;
    }

    public void SetCementSpreadDist(class_18 world, int i, int j, int k, int iSpreadDist) {
        CementBlockEntity tileEntity = (CementBlockEntity)world.method_1777(i, j, k);
        tileEntity.spreadDist = iSpreadDist;
        world.method_244(i, j, k, this.field_1915);
        world.method_202(i, j, k, i, j, k);
    }

    public boolean IsCementSourceBlock(class_14 blockAccess, int i, int j, int k) {
        return this.GetCementSpreadDist(blockAccess, i, j, k) == 0;
    }

    public int GetCementDryTime(class_14 blockAccess, int i, int j, int k) {
        if (blockAccess.method_1779(i, j, k) != this.field_1900) {
            return 0;
        }
        CementBlockEntity tileEntity = (CementBlockEntity)blockAccess.method_1777(i, j, k);
        return tileEntity.dryTime;
    }

    public void SetCementDryTime(class_18 world, int i, int j, int k, int iDryTime) {
        CementBlockEntity tileEntity = (CementBlockEntity)world.method_1777(i, j, k);
        tileEntity.dryTime = iDryTime;
        world.method_244(i, j, k, this.field_1915);
        world.method_202(i, j, k, i, j, k);
    }

    public boolean IsCementPartiallyDry(class_14 blockAccess, int i, int j, int k) {
        return this.GetCementDryTime(blockAccess, i, j, k) >= 8;
    }

    private int CheckNeighboursCloserToSourceForMinDryTime(class_18 world, int i, int j, int k) {
        int minDryTime = 1000;
        int distToSource = this.GetCementSpreadDist((class_14)world, i, j, k);
        minDryTime = this.GetLesserDryTimeIfCloserToSource(world, i, j + 1, k, distToSource, minDryTime);
        minDryTime = this.GetLesserDryTimeIfCloserToSource(world, i + 1, j, k, distToSource, minDryTime);
        minDryTime = this.GetLesserDryTimeIfCloserToSource(world, i - 1, j, k, distToSource, minDryTime);
        minDryTime = this.GetLesserDryTimeIfCloserToSource(world, i, j, k + 1, distToSource, minDryTime);
        minDryTime = this.GetLesserDryTimeIfCloserToSource(world, i, j, k - 1, distToSource, minDryTime);
        return minDryTime;
    }

    private int GetLesserDryTimeIfCloserToSource(class_18 world, int i, int j, int k, int distToSource, int dryTime) {
        int targetDryTime;
        int targetDistToSource;
        class_15 new_material = world.method_1779(i, j, k);
        if (new_material == this.field_1900 && (targetDistToSource = this.GetCementSpreadDist((class_14)world, i, j, k)) < distToSource && (targetDryTime = this.GetCementDryTime((class_14)world, i, j, k)) < dryTime) {
            return targetDryTime;
        }
        return dryTime;
    }

    private void AttemptToSpreadToBlock(class_18 world, int i, int j, int k, int newSpreadDist) {
        if (this.IsBlockOpenToSpread(world, i, j, k)) {
            int i1 = world.method_1776(i, j, k);
            if (i1 > 0) {
                class_17.field_1937[i1].method_1592(world, i, j, k, world.method_1778(i, j, k));
            }
            world.method_229(i, j, k, this.field_1915);
            this.SetCementSpreadDist(world, i, j, k, newSpreadDist);
        }
    }

    private boolean[] CheckSideBlocksForPotentialSpread(class_18 world, int i, int j, int k) {
        for (int sideNum = 0; sideNum < 4; ++sideNum) {
            int iSide = i;
            int jSide = j;
            int kSide = k;
            switch (sideNum) {
                case 0: {
                    --iSide;
                    break;
                }
                case 1: {
                    ++iSide;
                    break;
                }
                case 2: {
                    --kSide;
                    break;
                }
                default: {
                    ++kSide;
                }
            }
            this.tempSpreadToSideFlags[sideNum] = !this.blockBlocksFlow(world, iSide, jSide, kSide) && (world.method_1779(iSide, jSide, kSide) != this.field_1900 || !this.IsCementSourceBlock((class_14)world, iSide, jSide, kSide));
        }
        return this.tempSpreadToSideFlags;
    }

    private boolean[] CheckSideBlocksForDownslope(class_18 world, int i, int j, int k) {
        int tempSide;
        for (int sideNum = 0; sideNum < 4; ++sideNum) {
            this.tempClosestDownslopeToSideDist[sideNum] = 1000;
            int iSide = i;
            int jSide = j;
            int kSide = k;
            if (sideNum == 0) {
                --iSide;
            } else if (sideNum == 1) {
                ++iSide;
            } else if (sideNum == 2) {
                --kSide;
            } else if (sideNum == 3) {
                ++kSide;
            }
            if (this.blockBlocksFlow(world, iSide, jSide, kSide) || world.method_1779(iSide, jSide, kSide) == this.field_1900 && this.IsCementSourceBlock((class_14)world, iSide, jSide, kSide)) continue;
            this.tempClosestDownslopeToSideDist[sideNum] = !this.blockBlocksFlow(world, iSide, jSide - 1, kSide) ? 0 : this.RecursivelyCheckSideBlocksForDownSlope(world, iSide, jSide, kSide, 1, sideNum);
        }
        int minDistanceToDownslope = this.tempClosestDownslopeToSideDist[0];
        for (tempSide = 1; tempSide < 4; ++tempSide) {
            if (this.tempClosestDownslopeToSideDist[tempSide] >= minDistanceToDownslope) continue;
            minDistanceToDownslope = this.tempClosestDownslopeToSideDist[tempSide];
        }
        for (tempSide = 0; tempSide < 4; ++tempSide) {
            this.tempSpreadToSideFlags[tempSide] = this.tempClosestDownslopeToSideDist[tempSide] == minDistanceToDownslope;
        }
        return this.tempSpreadToSideFlags;
    }

    private int RecursivelyCheckSideBlocksForDownSlope(class_18 world, int i, int j, int k, int recursionCount, int originSideNum) {
        int closestDownslope = 1000;
        for (int tempSideNum = 0; tempSideNum < 4; ++tempSideNum) {
            int tempSideClosestDownslope;
            if (tempSideNum == 0 && originSideNum == 1 || tempSideNum == 1 && originSideNum == 0 || tempSideNum == 2 && originSideNum == 3 || tempSideNum == 3 && originSideNum == 2) continue;
            int tempi = i;
            int tempj = j;
            int tempk = k;
            if (tempSideNum == 0) {
                --tempi;
            } else if (tempSideNum == 1) {
                ++tempi;
            } else if (tempSideNum == 2) {
                --tempk;
            } else if (tempSideNum == 3) {
                ++tempk;
            }
            if (this.blockBlocksFlow(world, tempi, tempj, tempk) || this.GetCementSpreadDist((class_14)world, tempi, tempj, tempk) == 0) continue;
            if (!this.blockBlocksFlow(world, tempi, tempj - 1, tempk)) {
                return recursionCount;
            }
            if (recursionCount >= 4 || (tempSideClosestDownslope = this.RecursivelyCheckSideBlocksForDownSlope(world, tempi, tempj, tempk, recursionCount + 1, tempSideNum)) >= closestDownslope) continue;
            closestDownslope = tempSideClosestDownslope;
        }
        return closestDownslope;
    }

    private boolean blockBlocksFlow(class_18 world, int i, int j, int k) {
        int l = world.method_1776(i, j, k);
        if (l == class_17.field_1853.field_1915 || l == class_17.field_1860.field_1915 || l == class_17.field_1852.field_1915 || l == class_17.field_1854.field_1915 || l == class_17.field_1872.field_1915) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        class_15 new_material = class_17.field_1937[l].field_1900;
        if (new_material == this.field_1900) {
            return false;
        }
        return this.field_1900.method_905();
    }

    protected int CheckForLesserSpreadDist(class_18 world, int i, int j, int k, int sourceSpreadDist) {
        int targetSpreadDist = this.GetCementSpreadDist((class_14)world, i, j, k);
        if (targetSpreadDist < 0) {
            return sourceSpreadDist;
        }
        if (sourceSpreadDist < 0 || targetSpreadDist < sourceSpreadDist) {
            return targetSpreadDist;
        }
        return sourceSpreadDist;
    }

    private boolean IsBlockOpenToSpread(class_18 world, int i, int j, int k) {
        class_15 new_material = world.method_1779(i, j, k);
        if (new_material == this.field_1900) {
            return false;
        }
        return !this.blockBlocksFlow(world, i, j, k);
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        boolean flag = false;
        class_67 tessellator = class_67.field_2054;
        boolean flag1 = this.method_1618(tileView, x, y + 1, z, 1);
        boolean flag2 = this.method_1618(tileView, x, y - 1, z, 0);
        boolean[] aflag = new boolean[]{this.method_1618(tileView, x, y, z - 1, 2), this.method_1618(tileView, x, y, z + 1, 3), this.method_1618(tileView, x - 1, y, z, 4), this.method_1618(tileView, x + 1, y, z, 5)};
        if (!(flag1 || flag2 || aflag[0] || aflag[1] || aflag[2] || aflag[3])) {
            return false;
        }
        boolean flag3 = false;
        float f = 0.5f;
        float f1 = 1.0f;
        float f2 = 0.8f;
        float f3 = 0.6f;
        double d = 0.0;
        double d1 = 1.0;
        float f4 = this.RenderCementGetCornerHeightFromNeighbours(tileView, x, y, z);
        float f5 = this.RenderCementGetCornerHeightFromNeighbours(tileView, x, y, z + 1);
        float f6 = this.RenderCementGetCornerHeightFromNeighbours(tileView, x + 1, y, z + 1);
        float f7 = this.RenderCementGetCornerHeightFromNeighbours(tileView, x + 1, y, z);
        if (flag || flag1) {
            flag3 = true;
            int l = this.method_1626(tileView, x, y, z, 1);
            Atlas.Sprite atlasTX = Atlases.getTerrain().getTexture(l);
            double d2 = atlasTX.getStartU();
            double d3 = atlasTX.getEndU();
            double d4 = atlasTX.getStartV();
            double d5 = atlasTX.getEndV();
            float f13 = this.method_1604(tileView, x, y, z);
            tessellator.method_1689(f1 * f13, f1 * f13, f1 * f13);
            tessellator.method_1688((double)(x + 0), (double)((float)y + f4), (double)(z + 0), d2, d4);
            tessellator.method_1688((double)(x + 0), (double)((float)y + f5), (double)(z + 1), d2, d5);
            tessellator.method_1688((double)(x + 1), (double)((float)y + f6), (double)(z + 1), d3, d5);
            tessellator.method_1688((double)(x + 1), (double)((float)y + f7), (double)(z + 0), d3, d4);
        }
        if (flag || flag2) {
            float f8 = this.method_1604(tileView, x, y - 1, z);
            tessellator.method_1689(f * f8, f * f8, f * f8);
            tileRenderer.method_46((class_17)this, (double)x, (double)y, (double)z, this.method_1626(tileView, x, y, z, 0));
            flag3 = true;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            float f15;
            float f12;
            float f14;
            float f11;
            float f10;
            float f9;
            int k1 = x;
            int i2 = y;
            int j2 = z;
            if (i1 == 0) {
                --j2;
            } else if (i1 == 1) {
                ++j2;
            } else if (i1 == 2) {
                --k1;
            } else if (i1 == 3) {
                ++k1;
            }
            int k2 = this.method_1626(tileView, x, y, z, i1 + 2);
            Atlas.Sprite atlasTX2 = Atlases.getTerrain().getTexture(k2);
            if (!flag && !aflag[i1]) continue;
            if (i1 == 0) {
                f9 = f4;
                f10 = f7;
                f11 = x;
                f14 = x + 1;
                f12 = z;
                f15 = z;
            } else if (i1 == 1) {
                f9 = f6;
                f10 = f5;
                f11 = x + 1;
                f14 = x;
                f12 = z + 1;
                f15 = z + 1;
            } else if (i1 == 2) {
                f9 = f5;
                f10 = f4;
                f11 = x;
                f14 = x;
                f12 = z + 1;
                f15 = z;
            } else {
                f9 = f7;
                f10 = f6;
                f11 = x + 1;
                f14 = x + 1;
                f12 = z;
                f15 = z + 1;
            }
            flag3 = true;
            double d6 = atlasTX2.getStartU();
            double d7 = atlasTX2.getEndU();
            double d8 = atlasTX2.getStartV() + (double)((1.0f - f9) * 16.0f / 512.0f);
            double d9 = atlasTX2.getStartV() + (double)((1.0f - f10) * 16.0f / 512.0f);
            double d10 = atlasTX2.getEndV();
            float f16 = this.method_1604(tileView, k1, i2, j2);
            f16 = i1 < 2 ? (f16 *= f2) : (f16 *= f3);
            tessellator.method_1689(f1 * f16, f1 * f16, f1 * f16);
            tessellator.method_1688((double)f11, (double)((float)y + f9), (double)f12, d6, d8);
            tessellator.method_1688((double)f14, (double)((float)y + f10), (double)f15, d7, d9);
            tessellator.method_1688((double)f14, (double)(y + 0), (double)f15, d7, d10);
            tessellator.method_1688((double)f11, (double)(y + 0), (double)f12, d6, d10);
        }
        this.field_1921 = d;
        this.field_1924 = d1;
        return flag3;
    }

    public float RenderCementGetCornerHeightFromNeighbours(class_14 iblockaccess, int i, int j, int k) {
        int l = 0;
        float f = 0.0f;
        for (int i1 = 0; i1 < 4; ++i1) {
            int j1 = i - (i1 & 1);
            int k1 = j;
            int l1 = k - (i1 >> 1 & 1);
            if (iblockaccess.method_1779(j1, k1 + 1, l1) == BlockListener.fcCementMaterial) {
                return 1.0f;
            }
            class_15 material = iblockaccess.method_1779(j1, k1, l1);
            if (material == BlockListener.fcCementMaterial) {
                if (iblockaccess.method_1783(j1, k1 + 1, l1)) {
                    return 1.0f;
                }
                if (this.IsCementSourceBlock(iblockaccess, j1, k1, l1)) {
                    f += this.GetRenderHeight(iblockaccess, j1, k1, l1) * 10.0f;
                    l += 10;
                }
                f += this.GetRenderHeight(iblockaccess, j1, k1, l1);
                ++l;
                continue;
            }
            if (material.method_905()) continue;
            f += 0.6f;
            ++l;
        }
        if (l > 0) {
            return 1.0f - f / (float)l;
        }
        return 1.0f;
    }
}

