/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.itemblocks.PlanterBlockItem;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.SoilTemplate;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.modificationstation.stationapi.api.block.HasCustomBlockItemFactory;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@HasCustomBlockItemFactory(value=PlanterBlockItem.class)
@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class PlanterBlock
extends TemplateBlock
implements RotatableBlock,
SoilTemplate,
BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    public static final float m_fPlanterWidth = 0.75f;
    public static final float m_fPlanterHalfWidth = 0.375f;
    public static final float m_fPlanterBandHeight = 0.3125f;
    public static final float m_fPlanterBandHalfHeight = 0.15625f;
    private final int iPlanterDirtTextureIndex = 78;

    public PlanterBlock(Identifier iid) {
        super(iid, class_15.field_994);
        this.method_1587(0.6f);
        this.method_1580(field_1934);
        this.method_1584(true);
    }

    public int method_1607(int i) {
        return TextureListener.planter;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    protected int method_1629(int iMetaData) {
        return iMetaData & 1;
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        int iOldGrowthState = this.GetGrowthState((class_14)world, i, j, k);
        int iNewGrowthState = 0;
        if (world.method_234(i, j + 1, k) && world.method_255(i, j + 1, k) >= 8) {
            iNewGrowthState = iOldGrowthState;
            if (random.nextInt(50) == 0 && ++iNewGrowthState > 1) {
                iNewGrowthState = 0;
                if (random.nextInt(2) == 0) {
                    world.method_229(i, j + 1, k, class_17.field_1879.field_1915);
                } else {
                    world.method_229(i, j + 1, k, class_17.field_1878.field_1915);
                }
            }
        }
        if (iNewGrowthState != iOldGrowthState) {
            this.SetGrowthState(world, i, j, k, iNewGrowthState);
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public void Rotate(class_18 world1, int l, int i1, int j1, boolean flag) {
    }

    @Override
    public boolean CanPlantGrowOnBlock(class_18 world, int i, int j, int k, class_17 plantBlock) {
        return this.DoesPlanterContainSoil((class_14)world, i, j, k);
    }

    @Override
    public boolean IsBlockHydrated(class_18 world, int i, int j, int k) {
        return this.DoesPlanterContainSoil((class_14)world, i, j, k);
    }

    @Override
    public boolean IsBlockConsideredNeighbouringWater(class_18 world, int i, int j, int k) {
        return this.DoesPlanterContainSoil((class_14)world, i, j, k);
    }

    public boolean DoesPlanterContainSoil(class_14 iBlockAccess, int i, int j, int k) {
        int iMetaData = iBlockAccess.method_1778(i, j, k);
        return (iMetaData & 1) > 0;
    }

    public void SetDoesPlanterContainSoil(class_18 world, int i, int j, int k, boolean bContainsSoil) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFFE;
        if (bContainsSoil) {
            iMetaData |= 1;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    public int GetGrowthState(class_14 iBlockAccess, int i, int j, int k) {
        int iMetaData = iBlockAccess.method_1778(i, j, k);
        return (iMetaData & 6) >> 1;
    }

    public void SetGrowthState(class_18 world, int i, int j, int k, int iGrowthState) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFF9;
        world.method_215(i, j, k, iMetaData |= (iGrowthState & 3) << 1);
        world.method_243(i, j, k);
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        this.method_1578(0.125f, 0.0f, 0.125f, 0.25f, 0.6875f, 0.75f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.125f, 0.0f, 0.75f, 0.75f, 0.6875f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.75f, 0.0f, 0.25f, 0.875f, 0.6875f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.25f, 0.0f, 0.125f, 0.875f, 0.6875f, 0.25f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.25f, 0.0f, 0.25f, 0.75f, 0.125f, 0.75f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.6875f, 0.0f, 0.125f, 1.0f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.6875f, 0.875f, 0.875f, 1.0f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.875f, 0.6875f, 0.125f, 1.0f, 1.0f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.125f, 0.6875f, 0.0f, 1.0f, 1.0f, 0.125f);
        tileRenderer.method_76((class_17)this, x, y, z);
        if (this.DoesPlanterContainSoil(tileView, x, y, z)) {
            this.method_1578(0.125f, 0.9f, 0.125f, 0.875f, 1.0f, 0.875f);
            CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, TextureListener.planter_soil);
        }
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1578(0.125f, 0.0f, 0.125f, 0.25f, 0.6875f, 0.75f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.125f, 0.0f, 0.75f, 0.75f, 0.6875f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.75f, 0.0f, 0.25f, 0.875f, 0.6875f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.25f, 0.0f, 0.125f, 0.875f, 0.6875f, 0.25f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.25f, 0.0f, 0.25f, 0.75f, 0.125f, 0.75f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.0f, 0.6875f, 0.0f, 0.125f, 1.0f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.0f, 0.6875f, 0.875f, 0.875f, 1.0f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.875f, 0.6875f, 0.125f, 1.0f, 1.0f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        this.method_1578(0.125f, 0.6875f, 0.0f, 1.0f, 1.0f, 0.125f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter);
        if (meta > 0) {
            this.method_1578(0.125f, 0.9f, 0.125f, 0.875f, 1.0f, 0.875f);
            CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.planter_soil);
        }
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

