/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.entity.PulleyBlockEntity;
import net.kozibrodka.wolves.container.PulleyScreenHandler;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.ScreenPacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_69;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

public class PulleyBlock
extends TemplateBlockWithEntity
implements MechanicalDevice,
RotatableBlock {
    private final int iPulleyTopIndex = 62;
    private final int iPulleySideIndex = 63;
    private final int iPulleyBottomIndex = 64;
    private static int iPulleyTickRate = 10;

    public PulleyBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
    }

    public int method_1607(int iSide) {
        if (iSide == 0) {
            return TextureListener.pulley_bottom;
        }
        return iSide != 1 ? TextureListener.pulley_side : TextureListener.pulley_top;
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityplayer) {
        PulleyBlockEntity tileEntityPulley = (PulleyBlockEntity)world.method_1777(i, j, k);
        ScreenHandlerListener.TempGuiX = i;
        ScreenHandlerListener.TempGuiY = j;
        ScreenHandlerListener.TempGuiZ = k;
        if (world.field_180) {
            PacketHelper.send((class_169)new ScreenPacket("pulley", 0, i, j, k));
        }
        GuiHelper.openGUI((class_54)entityplayer, (Identifier)Identifier.of((String)"wolves:openPulley"), (class_134)tileEntityPulley, (class_71)new PulleyScreenHandler((class_134)entityplayer.field_519, tileEntityPulley));
        return true;
    }

    protected class_55 method_1251() {
        return new PulleyBlockEntity();
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        class_55 tileEntity = world.method_1777(i, j, k);
        if (tileEntity != null) {
            InventoryHandler.ejectInventoryContents(world, i, j, k, (class_134)tileEntity);
        }
        super.method_1630(world, i, j, k);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public int method_1565() {
        return iPulleyTickRate;
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingRedstone;
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsBlockOn((class_14)world, i, j, k);
        boolean bStateChanged = false;
        if (bOn != bReceivingPower) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
            }
            this.EmitPulleyParticles(world, i, j, k, random);
            this.SetBlockOn(world, i, j, k, bReceivingPower);
            bStateChanged = true;
        }
        boolean bRedstoneOn = this.IsRedstoneOn((class_14)world, i, j, k);
        boolean bl = bReceivingRedstone = world.method_263(i, j, k) || world.method_263(i, j + 1, k);
        if (bRedstoneOn != bReceivingRedstone) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
            }
            this.EmitPulleyParticles(world, i, j, k, random);
            this.SetRedstoneOn(world, i, j, k, bReceivingRedstone);
            bStateChanged = true;
        }
        if (bStateChanged) {
            ((PulleyBlockEntity)world.method_1777(i, j, k)).NotifyPulleyEntityOfBlockStateChange();
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        UnsortedUtils.DestroyHorizontallyAttachedAxles(world, i, j, k);
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            class_17 targetBlock;
            MechanicalDevice device;
            AxleBlock axleBlock;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (!(iTargetid == BlockListener.axleBlock.field_1915 ? (axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) && axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) > 0 : iTargetid == BlockListener.handCrank.field_1915 && (device = (MechanicalDevice)(targetBlock = class_17.field_1937[iTargetid])).IsOutputtingMechanicalPower(world, targetPos.i, targetPos.j, targetPos.k))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public boolean IsBlockOn(class_14 iBlockAccess, int i, int j, int k) {
        if (iBlockAccess == null) {
            return false;
        }
        return (iBlockAccess.method_1778(i, j, k) & 1) > 0;
    }

    public void SetBlockOn(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k);
        iMetaData = bOn ? (iMetaData |= 1) : (iMetaData &= 0xFFFFFFFE);
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    public boolean IsRedstoneOn(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 2) > 0;
    }

    public void SetRedstoneOn(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFFD;
        if (bOn) {
            iMetaData |= 2;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    void EmitPulleyParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }
}

