/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.CompanionCubeBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.mixin.LevelAccessor;
import net.kozibrodka.wolves.network.ParticlePacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.recipe.SawingRecipeRegistry;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class SawBlock
extends TemplateBlock
implements MechanicalDevice,
RotatableBlock,
BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    private static int iSawTickRate = 10;
    public static final float fSawBaseHeight = 0.75f;
    private final int iSawTopTextureIndex = 56;
    private final int iSawSideTextureIndex = 57;
    private final int iSawBladeTextureIndex = 58;

    public SawBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
        this.method_1584(true);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public int method_1626(class_14 blockAccess, int i, int j, int k, int iSide) {
        int iFacing = this.GetFacing(blockAccess, i, j, k);
        return iSide != iFacing ? TextureListener.saw_side : TextureListener.saw_face;
    }

    public int method_1607(int iSide) {
        return iSide != 1 ? TextureListener.saw_side : TextureListener.saw_face;
    }

    public int method_1565() {
        return iSawTickRate;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        this.SetFacing(world, i, j, k, UnsortedUtils.getOppositeFacing(iFacing));
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityLiving) {
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToBlockFacing(entityLiving);
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        switch (iFacing) {
            case 0: {
                return class_25.method_94((double)i, (double)((float)j + 1.0f - 0.75f), (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
            case 1: {
                return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 0.75f), (double)((float)k + 1.0f));
            }
            case 2: {
                return class_25.method_94((double)i, (double)j, (double)((float)k + 1.0f - 0.75f), (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
            case 3: {
                return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 0.75f));
            }
            case 4: {
                return class_25.method_94((double)((float)i + 1.0f - 0.75f), (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
            }
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 0.75f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
    }

    public void method_1616(class_14 iblockaccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iblockaccess, i, j, k);
        switch (iFacing) {
            case 0: {
                this.method_1578(0.0f, 0.25f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
                break;
            }
            case 2: {
                this.method_1578(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.75f);
                break;
            }
            case 4: {
                this.method_1578(0.25f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
            }
        }
    }

    public void method_1605() {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.75f, 1.0f);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        if (iid == BlockListener.axleBlock.field_1915 || iid == BlockListener.handCrank.field_1915) {
            world.method_216(i, j, k, this.field_1915, this.method_1565());
        } else {
            world.method_216(i, j, k, this.field_1915, this.method_1565() + world.field_214.nextInt(6));
        }
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsBlockOn((class_14)world, i, j, k);
        if (bOn != bReceivingPower) {
            world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
            if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
            }
            this.EmitSawParticles(world, i, j, k, random);
            this.SetBlockOn(world, i, j, k, bReceivingPower);
            if (bReceivingPower) {
                world.method_216(i, j, k, this.field_1915, this.method_1565() + random.nextInt(6));
            }
        } else if (bOn) {
            int iFacing = this.GetFacing((class_14)world, i, j, k);
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            if (!this.AttemptToSawBlock(world, targetPos.i, targetPos.j, targetPos.k, random, iFacing)) {
                this.BreakSaw(world, i, j, k);
            }
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.IsBlockOn((class_14)world, i, j, k)) {
            this.EmitSawParticles(world, i, j, k, random);
        }
    }

    public void method_1615(class_18 world, int i, int j, int k, class_57 entity) {
        if (this.IsBlockOn((class_14)world, i, j, k) && entity instanceof class_127) {
            int iFacing = this.GetFacing((class_14)world, i, j, k);
            float fHalfLength = 0.3125f;
            float fHalfWidth = 0.0078125f;
            float fBlockHeight = 0.25f;
            class_25 sawBox = switch (iFacing) {
                case 0 -> class_25.method_94((double)(0.5f - fHalfLength), (double)0.0, (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), (double)fBlockHeight, (double)(0.5f + fHalfWidth));
                case 1 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(1.0f - fBlockHeight), (double)(0.5f - fHalfWidth), (double)(0.5f + fHalfLength), (double)1.0, (double)(0.5f + fHalfWidth));
                case 2 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(0.5f - fHalfWidth), (double)0.0, (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), (double)fBlockHeight);
                case 3 -> class_25.method_94((double)(0.5f - fHalfLength), (double)(0.5f - fHalfWidth), (double)(1.0f - fBlockHeight), (double)(0.5f + fHalfLength), (double)(0.5f + fHalfWidth), (double)1.0);
                case 4 -> class_25.method_94((double)0.0, (double)(0.5f - fHalfWidth), (double)(0.5f - fHalfLength), (double)fBlockHeight, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
                default -> class_25.method_94((double)(1.0f - fBlockHeight), (double)(0.5f - fHalfWidth), (double)(0.5f - fHalfLength), (double)1.0, (double)(0.5f + fHalfWidth), (double)(0.5f + fHalfLength));
            };
            sawBox = sawBox.method_98((double)i, (double)j, (double)k);
            List collisionList = null;
            collisionList = world.method_175(class_127.class, sawBox);
            if (collisionList != null && collisionList.size() > 0) {
                for (int iTempListIndex = 0; iTempListIndex < collisionList.size(); ++iTempListIndex) {
                    class_127 tempTargetEntity = (class_127)collisionList.get(iTempListIndex);
                    if (!tempTargetEntity.method_1355(null, 4)) continue;
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
                    }
                    this.EmitBloodParticles(world, i, j, k, world.field_214);
                }
            }
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 7;
    }

    @Override
    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFF8;
        world.method_215(i, j, k, iMetaData |= iFacing);
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iBlockAccess, i, j, k);
        return iFacing != 0;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iBlockAccess, i, j, k);
        return iFacing != 0 && iFacing != 1;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            world.method_216(i, j, k, this.field_1915, this.method_1565());
            ((LevelAccessor)world).invokeBlockUpdate(i, j, k, this.field_1915);
        }
        UnsortedUtils.DestroyHorizontallyAttachedAxles(world, i, j, k);
    }

    public boolean IsBlockOn(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 8) > 0;
    }

    public void SetBlockOn(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k) & 7;
        if (bOn) {
            iMetaData |= 8;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    void EmitSawParticles(class_18 world, int i, int j, int k, Random random) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        float fBladeXPos = i;
        float fBladeYPos = j;
        float fBladeZPos = k;
        float fBladeXExtent = 0.0f;
        float fBladeZExtent = 0.0f;
        switch (iFacing) {
            case 0: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 1: {
                fBladeXPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeYPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 2: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 3: {
                fBladeXPos += 0.5f;
                fBladeYPos += 0.5f;
                fBladeZPos += 1.0f;
                fBladeXExtent = 1.0f;
                break;
            }
            case 4: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeZExtent = 1.0f;
                break;
            }
            default: {
                fBladeYPos += 0.5f;
                fBladeZPos += 0.5f;
                fBladeXPos += 1.0f;
                fBladeZExtent = 1.0f;
            }
        }
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = fBladeXPos + (random.nextFloat() - 0.5f) * fBladeXExtent;
            float smokeY = fBladeYPos + random.nextFloat() * 0.1f;
            float smokeZ = fBladeZPos + (random.nextFloat() - 0.5f) * fBladeZExtent;
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    void EmitBloodParticles(class_18 world, int i, int j, int k, Random random) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        BlockPosition iTargetPos = new BlockPosition(i, j, k);
        iTargetPos.AddFacingAsOffset(iFacing);
        for (int counter = 0; counter < 10; ++counter) {
            float smokeX = (float)iTargetPos.i + random.nextFloat();
            float smokeY = (float)iTargetPos.j + random.nextFloat();
            float smokeZ = (float)iTargetPos.k + random.nextFloat();
            world.method_178("reddust", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            if (FabricLoader.INSTANCE.getEnvironmentType() != EnvType.SERVER) continue;
            this.particlePacket(world, "reddust", smokeX, smokeY, smokeZ);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void particlePacket(class_18 world, String name, double x, double y, double z) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k1 = 0; k1 < list2.size(); ++k1) {
                class_69 player1 = (class_69)list2.get(k1);
                PacketHelper.sendTo((class_54)player1, (class_169)new ParticlePacket(name, x, y, z, 0.0, 0.0, 0.0));
            }
        }
    }

    boolean AttemptToSawBlock(class_18 world, int i, int j, int k, Random random, int iSawFacing) {
        if (!world.method_234(i, j, k)) {
            int targetId = world.method_1776(i, j, k);
            class_31 targetItem = new class_31(targetId, 1, world.method_1778(i, j, k));
            boolean sawedBlock = false;
            class_17 targetBlock = class_17.field_1937[targetId];
            boolean bRemoveOriginalBlockIfSawed = true;
            class_31 output = SawingRecipeRegistry.getInstance().getResult(targetItem);
            if (output != null) {
                if (output.field_751 == 0) {
                    output.field_751 = 1;
                }
                for (int iTempCount = 0; iTempCount < output.field_751; ++iTempCount) {
                    UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, output.field_753, output.method_722());
                }
                sawedBlock = true;
            } else if (targetId == BlockListener.companionCube.field_1915) {
                CompanionCubeBlock cubeBlock = (CompanionCubeBlock)BlockListener.companionCube;
                if (!cubeBlock.GetHalfCubeState((class_14)world, i, j, k)) {
                    if (iSawFacing == 0 || iSawFacing == 1) {
                        for (int iTempCount = 0; iTempCount < 2; ++iTempCount) {
                            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, BlockListener.companionCube.field_1915, 1);
                        }
                    } else {
                        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, BlockListener.companionCube.field_1915, 1);
                        cubeBlock.SetHalfCubeState(world, i, j, k, true);
                        world.method_202(i, j, k, i, j, k);
                        bRemoveOriginalBlockIfSawed = false;
                    }
                    BlockPosition bloodPos = new BlockPosition(i, j, k);
                    bloodPos.AddFacingAsOffset(UnsortedUtils.getOppositeFacing(iSawFacing));
                    this.EmitBloodParticles(world, bloodPos.i, bloodPos.j, bloodPos.k, world.field_214);
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "mob.wolf.hurt", 5.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, "mob.wolf.hurt", i, j, k, 5.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
                    }
                    sawedBlock = true;
                } else if (iSawFacing == 0 || iSawFacing == 1) {
                    UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, BlockListener.companionCube.field_1915, 1);
                    sawedBlock = true;
                }
            } else if (targetId == class_17.field_1832.field_1915 || targetId == class_17.field_1872.field_1915 || targetId == class_17.field_1848.field_1915 || targetId == BlockListener.hempCrop.field_1915) {
                targetBlock.method_1592(world, i, j, k, world.method_1778(i, j, k));
                sawedBlock = true;
            } else if (targetId != class_17.field_1875.field_1915 && targetBlock != null) {
                class_15 targetMaterial = targetBlock.field_1900;
                if (targetMaterial != class_15.field_982) {
                    if (targetMaterial.method_905()) {
                        return false;
                    }
                } else {
                    targetBlock.method_1592(world, i, j, k, world.method_1778(i, j, k));
                    sawedBlock = true;
                }
            }
            if (sawedBlock) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
                }
                this.EmitSawParticles(world, i, j, k, random);
                if (bRemoveOriginalBlockIfSawed) {
                    world.method_229(i, j, k, 0);
                }
            }
        }
        return true;
    }

    public void BreakSaw(class_18 world, int i, int j, int k) {
        int iTemp;
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.gear.field_461, 0);
        }
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_17.field_1949.field_1915, 0);
        }
        for (iTemp = 0; iTemp < 2; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_124.field_478.field_461, 0);
        }
        for (iTemp = 0; iTemp < 1; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.belt.field_461, 0);
        }
        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
        if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
        }
        world.method_229(i, j, k, 0);
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        int iSawFacing = this.GetFacing((class_14)world, i, j, k);
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            AxleBlock axleBlock;
            if (iFacing == iSawFacing) continue;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (iTargetid != BlockListener.axleBlock.field_1915 || !(axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) || axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        float f = 0.5f;
        float f1 = 0.5f;
        float f2 = 0.75f;
        int l = this.GetFacing(tileView, x, y, z);
        switch (l) {
            case 0: {
                this.method_1578(0.5f - f1, 1.0f - f2, 0.5f - f, 0.5f + f1, 1.0f, 0.5f + f);
                break;
            }
            case 1: {
                this.method_1578(0.5f - f1, 0.0f, 0.5f - f, 0.5f + f1, f2, 0.5f + f);
                break;
            }
            case 2: {
                this.method_1578(0.5f - f1, 0.5f - f, 1.0f - f2, 0.5f + f1, 0.5f + f, 1.0f);
                break;
            }
            case 3: {
                this.method_1578(0.5f - f1, 0.5f - f, 0.0f, 0.5f + f1, 0.5f + f, f2);
                break;
            }
            case 4: {
                this.method_1578(1.0f - f2, 0.5f - f1, 0.5f - f, 1.0f, 0.5f + f1, 0.5f + f);
                break;
            }
            default: {
                this.method_1578(0.0f, 0.5f - f1, 0.5f - f, f2, 0.5f + f1, 0.5f + f);
            }
        }
        tileRenderer.method_76((class_17)this, x, y, z);
        f = 0.3125f;
        f1 = 0.0078125f;
        f2 = 0.25f;
        switch (l) {
            case 0: {
                this.method_1578(0.5f - f, 0.0f, 0.5f - f1, 0.5f + f, 0.999f, 0.5f + f1);
                break;
            }
            case 1: {
                this.method_1578(0.5f - f, 0.001f, 0.5f - f1, 0.5f + f, 1.0f, 0.5f + f1);
                break;
            }
            case 2: {
                this.method_1578(0.5f - f, 0.5f - f1, 0.0f, 0.5f + f, 0.5f + f1, f2);
                break;
            }
            case 3: {
                this.method_1578(0.5f - f, 0.5f - f1, 1.0f - f2, 0.5f + f, 0.5f + f1, 1.0f);
                break;
            }
            case 4: {
                this.method_1578(0.0f, 0.5f - f1, 0.5f - f, f2, 0.5f + f1, 0.5f + f);
                break;
            }
            default: {
                this.method_1578(1.0f - f2, 0.5f - f1, 0.5f - f, 1.0f, 0.5f + f1, 0.5f + f);
            }
        }
        CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, TextureListener.saw_saw);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1605();
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 1);
        float f = 0.3125f;
        float f1 = 0.0078125f;
        this.method_1578(0.5f - f, 0.001f, 0.5f - f1, 0.5f + f, 1.0f, 0.5f + f1);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.saw_saw);
    }
}

