/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.Random;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.entity.TurntableBlockEntity;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

public class TurntableBlock
extends TemplateBlockWithEntity
implements MechanicalDevice,
RotatableBlock {
    private final int iTurntableTopTextureIndex = 65;
    private final int iTurntableSideTextureIndex = 66;
    private final int iTurntableBottomTextureIndex = 67;
    private final int iTurntableSwitchTextureIndex = 1;
    private static final int iTurntableTickRate = 10;
    private static boolean SETTING_TILE = false;
    public static final IntProperty CLICK = IntProperty.of((String)"click", (int)0, (int)3);
    public static final BooleanProperty POWER = BooleanProperty.of((String)"power");
    public static final BooleanProperty REDSTONE = BooleanProperty.of((String)"redstone");

    public TurntableBlock(Identifier iid) {
        super(iid, class_15.field_983);
        this.method_1587(2.0f);
        this.method_1580(field_1928);
        this.setDefaultState((BlockState)((BlockState)((BlockState)this.getDefaultState().with((Property)REDSTONE, (Comparable)Boolean.valueOf(false))).with((Property)POWER, (Comparable)Boolean.valueOf(false))).with((Property)CLICK, (Comparable)Integer.valueOf(0)));
    }

    public int method_1565() {
        return 10;
    }

    protected class_55 method_1251() {
        return new TurntableBlockEntity();
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, BlockListener.turntable.field_1915, this.method_1565());
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingMechanicalPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bMechanicalOn = this.IsBlockMechanicalOn(world, i, j, k);
        if (bMechanicalOn != bReceivingMechanicalPower) {
            this.EmitTurntableParticles(world, i, j, k, random);
            this.SetBlockMechanicalOn(world, i, j, k, bReceivingMechanicalPower);
        }
        boolean bReceivingRedstonePower = world.method_263(i, j, k);
        boolean bRedstoneOn = this.IsBlockRedstoneOn(world, i, j, k);
        if (bRedstoneOn != bReceivingRedstonePower) {
            this.SetBlockRedstoneOn(world, i, j, k, bReceivingRedstonePower);
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.IsBlockMechanicalOn(world, i, j, k)) {
            this.EmitTurntableParticles(world, i, j, k, random);
        }
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        if (world == null) {
            return true;
        }
        class_31 playerEquippedItem = entityPlayer.method_502();
        if (playerEquippedItem == null) {
            BlockState currentState = world.getBlockState(i, j, k);
            int iClick = (Integer)currentState.get((Property)CLICK);
            if (++iClick > 3) {
                iClick = 0;
            }
            world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)CLICK, (Comparable)Integer.valueOf(iClick)));
            this.canUseTile(world, i, j, k, iClick);
            return true;
        }
        return false;
    }

    public boolean canUseTile(class_18 world, int i, int j, int k, int click) {
        TurntableBlockEntity tileEntityTurntable = (TurntableBlockEntity)world.method_1777(i, j, k);
        tileEntityTurntable.switchSetting = click;
        world.method_202(i, j, k, i, j, k);
        world.method_243(i, j, k);
        return true;
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public void Rotate(class_18 world1, int l, int i1, int j1, boolean flag) {
    }

    public boolean IsBlockMechanicalOn(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.turntable.field_1915) {
            return (Boolean)world.getBlockState(i, j, k).get((Property)POWER);
        }
        return false;
    }

    public void SetBlockMechanicalOn(class_18 world, int i, int j, int k, boolean bOn) {
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)POWER, (Comparable)Boolean.valueOf(bOn)));
    }

    public boolean IsBlockRedstoneOn(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j, k) == BlockListener.turntable.field_1915) {
            return (Boolean)world.getBlockState(i, j, k).get((Property)REDSTONE);
        }
        return false;
    }

    public void SetBlockRedstoneOn(class_18 world, int i, int j, int k, boolean bOn) {
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)REDSTONE, (Comparable)Boolean.valueOf(bOn)));
    }

    void EmitTurntableParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        AxleBlock axleBlock;
        BlockPosition targetPos = new BlockPosition(i, j, k);
        targetPos.AddFacingAsOffset(0);
        int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
        return iTargetid == BlockListener.axleBlock.field_1915 && (axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, 0) && axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) > 0;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        builder.add(new Property[]{CLICK});
        builder.add(new Property[]{REDSTONE});
        builder.add(new Property[]{POWER});
    }
}

