/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block.entity;

import net.kozibrodka.wolves.block.CauldronBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.recipe.CauldronCraftingManager;
import net.kozibrodka.wolves.recipe.StokedCauldronCraftingManager;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_31;
import net.minecraft.class_44;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_554;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.registry.ItemRegistry;

public class CauldronBlockEntity
extends class_55
implements class_134 {
    private final int iCauldronInventorySize = 27;
    private final int iCauldronStackSizeLimit = 64;
    private final double dCauldronMaxPlayerInteractionDist = 64.0;
    private final int iPrimaryFireFactor = 5;
    private final int iSecondaryFireFactor = 1;
    private final int iRenderingTicksToCooldown = 20;
    private final int iHellfireDustRequiredToConcentrate = 8;
    private final int iCauldronTimeToCook = 1950;
    private class_31[] cauldronContents = new class_31[27];
    public int m_iCauldronCookCounter = 0;
    private int m_iRenderCooldownCounter = 0;
    private boolean m_bContainsValidIngrediantsForState = false;
    private boolean m_bForceValidateOnUpdate = false;
    private int m_iFireFactor = 0;
    static final boolean $assertionsDisabled = !CauldronBlockEntity.class.desiredAssertionStatus();

    public void method_1077(class_8 nbttagcompound) {
        super.method_1077(nbttagcompound);
        class_202 nbttaglist = nbttagcompound.method_1034("Items");
        this.cauldronContents = new class_31[this.method_948()];
        for (int i = 0; i < nbttaglist.method_1398(); ++i) {
            class_8 nbttagcompound1 = (class_8)nbttaglist.method_1396(i);
            int j = nbttagcompound1.method_1025("Slot") & 0xFF;
            if (j < 0 || j >= this.cauldronContents.length) continue;
            this.cauldronContents[j] = new class_31(nbttagcompound1);
        }
        if (nbttagcompound.method_1023("m_iCauldronCookCounter")) {
            this.m_iCauldronCookCounter = nbttagcompound.method_1027("m_iCauldronCookCounter");
        }
        if (nbttagcompound.method_1023("m_iRenderCooldownCounter")) {
            this.m_iRenderCooldownCounter = nbttagcompound.method_1027("m_iRenderCooldownCounter");
        }
        if (nbttagcompound.method_1023("m_bContainsValidIngrediantsForState")) {
            this.m_bContainsValidIngrediantsForState = nbttagcompound.method_1035("m_bContainsValidIngrediantsForState");
        } else {
            this.m_bForceValidateOnUpdate = true;
        }
        if (nbttagcompound.method_1023("m_iFireFactor")) {
            this.m_iFireFactor = nbttagcompound.method_1027("m_iFireFactor");
        } else {
            this.m_bForceValidateOnUpdate = true;
        }
    }

    public void method_1078(class_8 nbttagcompound) {
        super.method_1078(nbttagcompound);
        class_202 nbttaglist = new class_202();
        for (int i = 0; i < this.cauldronContents.length; ++i) {
            if (this.cauldronContents[i] == null) continue;
            class_8 nbttagcompound1 = new class_8();
            nbttagcompound1.method_1012("Slot", (byte)i);
            this.cauldronContents[i].method_706(nbttagcompound1);
            nbttaglist.method_1397((class_187)nbttagcompound1);
        }
        nbttagcompound.method_1017("Items", (class_187)nbttaglist);
        nbttagcompound.method_1015("m_iCauldronCookCounter", this.m_iCauldronCookCounter);
        nbttagcompound.method_1015("m_iRenderCooldownCounter", this.m_iRenderCooldownCounter);
    }

    public void method_1076() {
        if (this.field_1238.field_180) {
            return;
        }
        int iFireUnderState = ((CauldronBlock)BlockListener.cauldron).GetFireUnderState((class_14)this.field_1238, this.field_1239, this.field_1240, this.field_1241);
        if (iFireUnderState > 0) {
            if (this.m_bForceValidateOnUpdate) {
                this.ValidateContentsForState(iFireUnderState);
                this.m_bForceValidateOnUpdate = false;
            }
            this.ValidateFireFactor(iFireUnderState);
            if (iFireUnderState == 2) {
                if (this.m_iRenderCooldownCounter <= 0) {
                    this.m_iCauldronCookCounter = 0;
                }
                this.m_iRenderCooldownCounter = 20;
                this.PerformStokedFireUpdate();
            } else if (this.m_iRenderCooldownCounter > 0) {
                --this.m_iRenderCooldownCounter;
                if (this.m_iRenderCooldownCounter <= 0) {
                    this.m_iCauldronCookCounter = 0;
                }
            } else {
                this.PerformNormalFireUpdate();
            }
        } else {
            this.m_iCauldronCookCounter = 0;
        }
    }

    public int method_948() {
        return 27;
    }

    public class_31 method_954(int iSlot) {
        return this.cauldronContents[iSlot];
    }

    public class_31 method_949(int iSlot, int iAmount) {
        return InventoryHandler.decreaseStackSize(this, iSlot, iAmount);
    }

    public void method_950(int iSlot, class_31 ItemInstance) {
        this.cauldronContents[iSlot] = ItemInstance;
        if (ItemInstance != null && ItemInstance.field_751 > this.method_953()) {
            ItemInstance.field_751 = this.method_953();
        }
        this.method_947();
    }

    public String method_952() {
        return "Cauldron";
    }

    public int method_953() {
        return 64;
    }

    public void method_947() {
        if (this.field_1238 == null) {
            return;
        }
        int iFireUnderState = ((CauldronBlock)BlockListener.cauldron).GetFireUnderState((class_14)this.field_1238, this.field_1239, this.field_1240, this.field_1241);
        this.ValidateContentsForState(iFireUnderState);
    }

    public boolean method_951(class_54 entityPlayer) {
        if (this.field_1238.method_1777(this.field_1239, this.field_1240, this.field_1241) != this) {
            return false;
        }
        return entityPlayer.method_1347((double)this.field_1239 + 0.5, (double)this.field_1240 + 0.5, (double)this.field_1241 + 0.5) <= 64.0;
    }

    public void NotifyOfChangeInFireUnder(int iFireUnderState) {
        this.ValidateContentsForState(iFireUnderState);
        this.ValidateFireFactor(iFireUnderState);
    }

    public void ValidateContentsForState(int iFireUnderState) {
        this.m_bContainsValidIngrediantsForState = false;
        if (iFireUnderState == 1) {
            if (CauldronCraftingManager.getInstance().getCraftingResult(this) != null) {
                this.m_bContainsValidIngrediantsForState = true;
            } else if (this.GetUncookedItemInventoryIndex() >= 0) {
                this.m_bContainsValidIngrediantsForState = true;
            } else if (InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)ItemListener.dung)) >= 0 && this.ContainsFood()) {
                this.m_bContainsValidIngrediantsForState = true;
            }
        } else if (iFireUnderState == 2) {
            if (InventoryHandler.getFirstOccupiedStackOfItem(this, BlockRegistry.INSTANCE.getId((Object)class_17.field_1887)) >= 0) {
                this.m_bContainsValidIngrediantsForState = true;
            } else if (InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)class_124.field_386)) >= 0) {
                this.m_bContainsValidIngrediantsForState = true;
            } else if (InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)ItemListener.hellfireDust)) >= 0) {
                this.m_bContainsValidIngrediantsForState = true;
            } else if (StokedCauldronCraftingManager.getInstance().getCraftingResult(this) != null) {
                this.m_bContainsValidIngrediantsForState = true;
            }
        }
    }

    public void ValidateFireFactor(int iFireUnderState) {
        int iFireFactor = 0;
        if (iFireUnderState > 0) {
            iFireFactor = 5;
            int iidToTest = class_17.field_1892.field_1915;
            if (iFireUnderState == 2) {
                iidToTest = BlockListener.stokedFire.field_1915;
            }
            int tempY = this.field_1240 - 1;
            for (int tempX = this.field_1239 - 1; tempX <= this.field_1239 + 1; ++tempX) {
                for (int tempZ = this.field_1241 - 1; tempZ <= this.field_1241 + 1; ++tempZ) {
                    if (tempX == this.field_1239 && tempZ == this.field_1241 || this.field_1238.method_1776(tempX, tempY, tempZ) != iidToTest) continue;
                    ++iFireFactor;
                }
            }
        }
        this.m_iFireFactor = iFireFactor;
    }

    private void PerformNormalFireUpdate() {
        if (this.m_bContainsValidIngrediantsForState) {
            this.m_iCauldronCookCounter += this.m_iFireFactor;
            if (this.m_iCauldronCookCounter >= 1950) {
                int iDungIndex = InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)ItemListener.dung));
                if (iDungIndex >= 0 && this.DestroyAllFoodInInventory()) {
                    this.m_iCauldronCookCounter = 0;
                    return;
                }
                if (CauldronCraftingManager.getInstance().getCraftingResult(this) != null) {
                    class_31 cookedStack = CauldronCraftingManager.getInstance().consumeIngredientsAndReturnResult(this);
                    if (!$assertionsDisabled && cookedStack == null) {
                        throw new AssertionError();
                    }
                    if (!InventoryHandler.addItemInstanceToInventory(this, cookedStack)) {
                        UnsortedUtils.ejectStackWithRandomOffset(this.field_1238, this.field_1239, this.field_1240 + 1, this.field_1241, cookedStack);
                    }
                } else {
                    this.AttemptToCookFood();
                }
                this.m_iCauldronCookCounter = 0;
            }
        } else {
            this.m_iCauldronCookCounter = 0;
        }
    }

    private void PerformStokedFireUpdate() {
        if (this.m_bContainsValidIngrediantsForState) {
            this.m_iCauldronCookCounter += this.m_iFireFactor;
            if (this.m_iCauldronCookCounter >= 1950) {
                if (InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)ItemListener.hellfireDust)) >= 0 || InventoryHandler.getFirstOccupiedStackOfItem(this, BlockRegistry.INSTANCE.getId((Object)class_17.field_1887)) >= 0 || InventoryHandler.getFirstOccupiedStackOfItem(this, ItemRegistry.INSTANCE.getId((Object)class_124.field_386)) >= 0) {
                    this.BlowUpCauldron();
                } else if (StokedCauldronCraftingManager.getInstance().getCraftingResult(this) != null) {
                    class_31 cookedStack = StokedCauldronCraftingManager.getInstance().consumeIngredientsAndReturnResult(this);
                    if (!$assertionsDisabled && cookedStack == null) {
                        throw new AssertionError();
                    }
                    if (!InventoryHandler.addItemInstanceToInventory(this, cookedStack)) {
                        UnsortedUtils.ejectStackWithRandomOffset(this.field_1238, this.field_1239, this.field_1240 + 1, this.field_1241, cookedStack);
                    }
                }
                this.m_iCauldronCookCounter = 0;
            }
        } else {
            this.m_iCauldronCookCounter = 0;
        }
    }

    private void AttemptToCookFood() {
        int iUncookedFoodIndex = this.GetUncookedItemInventoryIndex();
        if (iUncookedFoodIndex >= 0) {
            class_31 tempStack = class_44.method_144().method_145(this.cauldronContents[iUncookedFoodIndex].method_694().field_461);
            class_31 cookedStack = tempStack.method_724();
            this.method_949(iUncookedFoodIndex, 1);
            if (!InventoryHandler.addItemInstanceToInventory(this, cookedStack)) {
                UnsortedUtils.ejectStackWithRandomOffset(this.field_1238, this.field_1239, this.field_1240 + 1, this.field_1241, cookedStack);
            }
        }
    }

    public int getCookProgressScaled(int iScale) {
        return this.m_iCauldronCookCounter * iScale / 1950;
    }

    public boolean IsCooking() {
        return this.m_iCauldronCookCounter > 0;
    }

    public int GetUncookedItemInventoryIndex() {
        for (int tempIndex = 0; tempIndex < 27; ++tempIndex) {
            class_124 tempItem;
            if (this.cauldronContents[tempIndex] == null || (tempItem = this.cauldronContents[tempIndex].method_694()) == null || !(tempItem instanceof class_554) || class_44.method_144().method_145(tempItem.field_461) == null) continue;
            return tempIndex;
        }
        return -1;
    }

    private boolean ContainsFood() {
        for (int tempIndex = 0; tempIndex < 27; ++tempIndex) {
            class_124 tempItem;
            if (this.cauldronContents[tempIndex] == null || (tempItem = this.cauldronContents[tempIndex].method_694()) == null || !(tempItem instanceof class_554)) continue;
            return true;
        }
        return false;
    }

    private boolean DestroyAllFoodInInventory() {
        boolean bFoodDestroyed = false;
        for (int tempIndex = 0; tempIndex < 27; ++tempIndex) {
            class_124 tempItem;
            if (this.cauldronContents[tempIndex] == null || (tempItem = this.cauldronContents[tempIndex].method_694()) == null || !(tempItem instanceof class_554)) continue;
            int stackSize = this.cauldronContents[tempIndex].field_751;
            this.cauldronContents[tempIndex] = null;
            class_31 spoiledStack = new class_31((class_124)ItemListener.foulFood, stackSize);
            this.method_950(tempIndex, spoiledStack);
            bFoodDestroyed = true;
        }
        return bFoodDestroyed;
    }

    private void BlowUpCauldron() {
        int iHellfireCount = InventoryHandler.itemCountInInventory(this, ItemRegistry.INSTANCE.getId((Object)ItemListener.hellfireDust), -1);
        float fExplosionSize = (float)iHellfireCount * 10.0f / 64.0f;
        fExplosionSize += (float)InventoryHandler.itemCountInInventory(this, ItemRegistry.INSTANCE.getId((Object)class_124.field_386), -1) * 10.0f / 64.0f;
        int iTNTCount = InventoryHandler.itemCountInInventory(this, BlockRegistry.INSTANCE.getId((Object)class_17.field_1887), -1);
        if (iTNTCount > 0) {
            if (fExplosionSize < 4.0f) {
                fExplosionSize = 4.0f;
            }
            fExplosionSize += (float)InventoryHandler.itemCountInInventory(this, BlockRegistry.INSTANCE.getId((Object)class_17.field_1887), -1);
        }
        if (fExplosionSize < 2.0f) {
            fExplosionSize = 2.0f;
        } else if (fExplosionSize > 10.0f) {
            fExplosionSize = 10.0f;
        }
        InventoryHandler.clearInventoryContents(this);
        this.field_1238.method_229(this.field_1239, this.field_1240, this.field_1241, 0);
        this.field_1238.method_187(null, (double)this.field_1239, (double)this.field_1240, (double)this.field_1241, fExplosionSize);
    }

    static Class _mthclass$(String s) {
        try {
            return Class.forName(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new NoClassDefFoundError(classnotfoundexception.getMessage());
        }
    }
}

