/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.entity;

import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.EntityListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_14;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_3;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.server.entity.EntitySpawnDataProvider;
import net.modificationstation.stationapi.api.server.entity.HasTrackingParameters;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.Namespace;

@HasTrackingParameters(trackingDistance=160, updatePeriod=2)
public class WindMillEntity
extends class_57
implements EntitySpawnDataProvider {
    public static final float fWindMillHeight = 12.8f;
    public static final float fWindMillWidth = 12.8f;
    public static final float fWindMillDepth = 0.8f;
    public static final int iWindMillMaxDamage = 40;
    public static final float fWindMillRotationPerTick = -0.125f;
    public static final float fWindMillRotationPerTickInStorm = -2.0f;
    public static final float fWindMillRotationPerTickInHell = -0.0675f;
    public static final int iWindMillTicksPerFullUpdate = 20;
    public static final int iWindMillUpdatesToOverpower = 30;
    public int iWindMillCurrentDamage = 0;
    public int iWindMillTimeSinceHit = 0;
    public int iWindMillRockDirection = 1;
    public float fWindMillCurrentRotationSpeed = 0.0f;
    public int iCurrentBladeColoringIndex = 0;
    public int iFullUpdateTickCount = 0;

    public WindMillEntity(class_18 world) {
        super(world);
        this.field_1593 = true;
        this.method_1321(0.5f, 0.5f);
        this.field_1631 = this.field_1633 / 2.0f;
    }

    public WindMillEntity(class_18 world, double x, double y, double z, boolean bIAligned) {
        this(world);
        this.method_1340(x, y, z);
        this.setAligned(bIAligned);
    }

    public WindMillEntity(class_18 level, Double aDouble, Double aDouble1, Double aDouble2) {
        this(level);
    }

    protected void method_1310() {
        this.field_1616.method_1502(16, (Object)0);
        this.field_1616.method_1502(17, (Object)0);
        this.field_1616.method_1502(18, (Object)0);
        this.field_1616.method_1502(19, (Object)0);
        this.field_1616.method_1502(20, (Object)0);
        this.field_1616.method_1502(21, (Object)0);
        this.field_1616.method_1502(22, (Object)0);
        this.field_1616.method_1502(23, (Object)0);
    }

    public void method_1368(class_8 nbttagcompound) {
        nbttagcompound.method_1021("bWindMillIAligned", this.getAligned());
        nbttagcompound.method_1014("fRotation", this.getMillRotation());
        nbttagcompound.method_1021("bProvidingPower", this.getProvidingPower());
        nbttagcompound.method_1015("iOverpowerTimer", this.getOverpowerTimer());
        nbttagcompound.method_1015("iBladeColors0", this.getBladeColor(0));
        nbttagcompound.method_1015("iBladeColors1", this.getBladeColor(1));
        nbttagcompound.method_1015("iBladeColors2", this.getBladeColor(2));
        nbttagcompound.method_1015("iBladeColors3", this.getBladeColor(3));
    }

    public void method_1363(class_8 nbttagcompound) {
        this.setAligned(nbttagcompound.method_1035("bWindMillIAligned"));
        this.setMillRotation(nbttagcompound.method_1029("fRotation"));
        this.setProvidingPower(nbttagcompound.method_1035("bProvidingPower"));
        this.setOverpowerTimer(nbttagcompound.method_1027("iOverpowerTimer"));
        this.setBladeColor(0, nbttagcompound.method_1027("iBladeColors0"));
        this.setBladeColor(1, nbttagcompound.method_1027("iBladeColors1"));
        this.setBladeColor(2, nbttagcompound.method_1027("iBladeColors2"));
        this.setBladeColor(3, nbttagcompound.method_1027("iBladeColors3"));
    }

    protected boolean method_1358() {
        return false;
    }

    public class_25 method_1379(class_57 entity) {
        return entity.field_1610;
    }

    public class_25 method_1381() {
        return this.field_1610;
    }

    public boolean method_1380() {
        return false;
    }

    public boolean method_1356() {
        return !this.field_1630;
    }

    public boolean method_1355(class_57 entity, int i) {
        if (this.field_1596.field_180 || this.field_1630) {
            return true;
        }
        this.iWindMillRockDirection = -this.iWindMillRockDirection;
        this.iWindMillTimeSinceHit = 10;
        this.method_1336();
        this.iWindMillCurrentDamage += i * 5;
        if (this.iWindMillCurrentDamage > 40) {
            this.DestroyWithDrop();
        }
        return true;
    }

    public void method_1312() {
        this.iWindMillRockDirection = -this.iWindMillRockDirection;
        this.iWindMillTimeSinceHit = 10;
        this.iWindMillCurrentDamage += this.iWindMillCurrentDamage * 5;
    }

    public void method_1386() {
        int zOffset;
        int xOffset;
        int centerX = (int)(this.field_1600 - 0.5);
        int centerY = (int)(this.field_1601 - 0.5);
        int centerZ = (int)(this.field_1602 - 0.5);
        int centerId = this.field_1596.method_1776(centerX, centerY, centerZ);
        if (centerId == BlockListener.nonCollidingAxleBlock.field_1915) {
            this.field_1596.method_201(centerX, centerY, centerZ, BlockListener.axleBlock.field_1915, this.field_1596.method_1778(centerX, centerY, centerZ));
        }
        if (this.getProvidingPower()) {
            if (centerId == BlockListener.axleBlock.field_1915) {
                ((AxleBlock)BlockListener.axleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            } else if (centerId == BlockListener.nonCollidingAxleBlock.field_1915) {
                ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            }
        }
        if (this.getAligned()) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -6; heightOffset <= 6; ++heightOffset) {
            for (int widthOffset = -6; widthOffset <= 6; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || this.field_1596.method_1776(tempX = centerX + xOffset * widthOffset, tempY = centerY + heightOffset, tempZ = centerZ + zOffset * widthOffset) != BlockListener.collisionBlock.field_1915 && this.field_1596.method_1776(tempX, tempY, tempZ) != BlockListener.obstructionBlock.field_1915) continue;
                this.field_1596.method_229(tempX, tempY, tempZ, 0);
            }
        }
        super.method_1386();
    }

    public void DestroyWithDrop() {
        if (!this.field_1630) {
            this.method_1325(ItemListener.windMillItem.field_461, 1, 0.0f);
            this.method_1386();
        }
    }

    public void method_1370() {
        if (this.field_1630 || this.field_1596.field_180) {
            return;
        }
        --this.iFullUpdateTickCount;
        if (this.iFullUpdateTickCount <= 0) {
            this.iFullUpdateTickCount = 20;
            int centerX = (int)(this.field_1600 - 0.5);
            int centerY = (int)(this.field_1601 - 0.5);
            int centerZ = (int)(this.field_1602 - 0.5);
            int centerId = this.field_1596.method_1776(centerX, centerY, centerZ);
            if (centerId == BlockListener.axleBlock.field_1915) {
                this.field_1596.method_201(centerX, centerY, centerZ, BlockListener.nonCollidingAxleBlock.field_1915, this.field_1596.method_1778(centerX, centerY, centerZ));
            }
            if (centerId != BlockListener.axleBlock.field_1915 && centerId != BlockListener.nonCollidingAxleBlock.field_1915) {
                this.DestroyWithDrop();
                return;
            }
            if (!WindMillEntity.validateArea(this.field_1596, centerX, centerY, centerZ, this.getAligned())) {
                this.DestroyWithDrop();
                return;
            }
            if (!this.getProvidingPower() && ((AxleBlock)BlockListener.axleBlock).GetPowerLevel((class_14)this.field_1596, centerX, centerY, centerZ) > 0) {
                this.DestroyWithDrop();
                return;
            }
            if (!this.getProvidingPower() && ((AxleBlock)BlockListener.nonCollidingAxleBlock).GetPowerLevel((class_14)this.field_1596, centerX, centerY, centerZ) > 0) {
                this.DestroyWithDrop();
                return;
            }
            this.fWindMillCurrentRotationSpeed = this.ComputeRotation(centerX, centerY, centerZ);
            if (this.fWindMillCurrentRotationSpeed > 0.01f || this.fWindMillCurrentRotationSpeed < -0.01f) {
                if (!this.getProvidingPower()) {
                    this.setProvidingPower(true);
                    ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 3);
                }
            } else if (this.getProvidingPower()) {
                this.setProvidingPower(false);
                ((AxleBlock)BlockListener.nonCollidingAxleBlock).SetPowerLevel(this.field_1596, centerX, centerY, centerZ, 0);
            }
            if (this.getOverpowerTimer() >= 0) {
                if (this.getOverpowerTimer() > 0) {
                    this.setOverpowerTimer(this.getOverpowerTimer() - 1);
                }
                if (this.getOverpowerTimer() <= 0) {
                    ((AxleBlock)BlockListener.nonCollidingAxleBlock).Overpower(this.field_1596, centerX, centerY, centerZ);
                }
            }
        }
        if (this.iWindMillTimeSinceHit > 0) {
            --this.iWindMillTimeSinceHit;
        }
        if (this.iWindMillCurrentDamage > 0) {
            --this.iWindMillCurrentDamage;
        }
        this.setMillRotation(this.getMillRotation() + this.fWindMillCurrentRotationSpeed);
        if (this.getMillRotation() > 360.0f) {
            this.setMillRotation(this.getMillRotation() - 360.0f);
        } else if (this.getMillRotation() < -360.0f) {
            this.setMillRotation(this.getMillRotation() + 360.0f);
        }
    }

    public float method_1366() {
        return 0.0f;
    }

    public boolean canPlayerUse(class_54 entityplayer) {
        if (this.field_1630) {
            return false;
        }
        return entityplayer.method_1352((class_57)this) <= 256.0;
    }

    public boolean method_1323(class_54 entityplayer) {
        class_31 ItemInstance = entityplayer.field_519.method_675();
        if (ItemInstance != null && (ItemInstance.field_753 == class_124.field_423.field_461 || ItemInstance.field_753 == ItemListener.dung.field_461)) {
            int iColor = 0;
            iColor = ItemInstance.field_753 == class_124.field_423.field_461 ? class_3.method_1((int)ItemInstance.method_722()) : 12;
            this.setBladeColor(this.iCurrentBladeColoringIndex, iColor);
            ++this.iCurrentBladeColoringIndex;
            if (this.iCurrentBladeColoringIndex >= 4) {
                this.iCurrentBladeColoringIndex = 0;
            }
            --ItemInstance.field_751;
            if (ItemInstance.field_751 == 0) {
                entityplayer.field_519.method_950(entityplayer.field_519.field_747, null);
            }
        }
        return true;
    }

    public void method_1371(double deltaX, double deltaY, double deltaZ) {
        if (!this.field_1630) {
            this.DestroyWithDrop();
        }
    }

    public static boolean validateArea(class_18 world, int x, int y, int z, boolean aligned) {
        int zOffset;
        int xOffset;
        if (y + 6 >= 128) {
            return false;
        }
        if (aligned) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -6; heightOffset <= 6; ++heightOffset) {
            for (int widthOffset = -6; widthOffset <= 6; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || WindMillEntity.isSuitableBlock(world, tempX = x + xOffset * widthOffset, tempY = y + heightOffset, tempZ = z + zOffset * widthOffset)) continue;
                return false;
            }
        }
        return true;
    }

    public static void placeCollisionBlocks(class_18 world, int x, int y, int z, boolean aligned) {
        int zOffset;
        int xOffset;
        if (y + 6 >= 128) {
            return;
        }
        if (aligned) {
            xOffset = 0;
            zOffset = 1;
        } else {
            xOffset = 1;
            zOffset = 0;
        }
        for (int heightOffset = -6; heightOffset <= 6; ++heightOffset) {
            for (int widthOffset = -6; widthOffset <= 6; ++widthOffset) {
                int tempZ;
                int tempY;
                int tempX;
                if (heightOffset == 0 && widthOffset == 0 || world.method_1776(tempX = x + xOffset * widthOffset, tempY = y + heightOffset, tempZ = z + zOffset * widthOffset) != 0) continue;
                world.method_229(tempX, tempY, tempZ, BlockListener.collisionBlock.field_1915);
            }
        }
    }

    public static boolean isSuitableBlock(class_18 world, int x, int y, int z) {
        return world.method_234(x, y, z) || world.method_1776(x, y, z) == BlockListener.collisionBlock.field_1915;
    }

    private float ComputeRotation(int iCenterI, int iCenterJ, int iCenterK) {
        float fRotationAmount = 0.0f;
        if (this.field_1596.field_216.field_2176) {
            fRotationAmount = -0.0675f;
            this.setOverpowerTimer(-1);
        } else if (this.field_1596.method_249(iCenterI, iCenterJ, iCenterK)) {
            if (UnsortedUtils.IsBlockBeingPrecipitatedOn(this.field_1596, iCenterI, 128, iCenterK)) {
                fRotationAmount = -2.0f;
                if (this.getOverpowerTimer() < 0) {
                    this.setOverpowerTimer(30);
                }
            } else {
                fRotationAmount = -0.125f;
                this.setOverpowerTimer(-1);
            }
        }
        return fRotationAmount;
    }

    public Identifier getHandlerIdentifier() {
        return Identifier.of((Namespace)EntityListener.MOD_ID, (String)"WindMill");
    }

    public boolean getAligned() {
        return (this.field_1616.method_1501(16) & 1) != 0;
    }

    public void setAligned(boolean flag) {
        if (flag) {
            this.field_1616.method_1509(16, (Object)1);
        } else {
            this.field_1616.method_1509(16, (Object)0);
        }
    }

    public float getMillRotation() {
        return Float.intBitsToFloat(this.field_1616.method_1508(17));
    }

    public void setMillRotation(float age) {
        this.field_1616.method_1509(17, (Object)Float.floatToRawIntBits(age));
    }

    public boolean getProvidingPower() {
        return (this.field_1616.method_1501(18) & 1) != 0;
    }

    public void setProvidingPower(boolean flag) {
        if (flag) {
            this.field_1616.method_1509(18, (Object)1);
        } else {
            this.field_1616.method_1509(18, (Object)0);
        }
    }

    public int getOverpowerTimer() {
        return this.field_1616.method_1501(19);
    }

    public void setOverpowerTimer(int i) {
        this.field_1616.method_1509(19, (Object)((byte)i));
    }

    public int getBladeColor(int blade) {
        return switch (blade) {
            case 0 -> this.field_1616.method_1501(20);
            case 1 -> this.field_1616.method_1501(21);
            case 2 -> this.field_1616.method_1501(22);
            case 3 -> this.field_1616.method_1501(23);
            default -> 15;
        };
    }

    public void setBladeColor(int blade, int color) {
        switch (blade) {
            case 0: {
                this.field_1616.method_1509(20, (Object)((byte)color));
                break;
            }
            case 1: {
                this.field_1616.method_1509(21, (Object)((byte)color));
                break;
            }
            case 2: {
                this.field_1616.method_1509(22, (Object)((byte)color));
                break;
            }
            case 3: {
                this.field_1616.method_1509(23, (Object)((byte)color));
            }
        }
    }

    public boolean syncTrackerAtSpawn() {
        return true;
    }
}

