/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.utils;

import java.util.List;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.SoilTemplate;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_142;
import net.minecraft.class_153;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_57;

public class UnsortedUtils {
    public static int getOppositeFacing(int iFacing) {
        return iFacing ^ 1;
    }

    public static int RotateFacingAroundJ(int iFacing, boolean bReverse) {
        if (iFacing >= 2) {
            switch (iFacing) {
                case 2: {
                    iFacing = 5;
                    break;
                }
                case 3: {
                    iFacing = 4;
                    break;
                }
                case 4: {
                    iFacing = 2;
                    break;
                }
                case 5: {
                    iFacing = 3;
                }
            }
            if (!bReverse) {
                iFacing = UnsortedUtils.getOppositeFacing(iFacing);
            }
        }
        return iFacing;
    }

    public static void ejectStackWithRandomOffset(class_18 world, int i, int j, int k, class_31 stack) {
        float xOffset = world.field_214.nextFloat() * 0.7f + 0.15f;
        float yOffset = world.field_214.nextFloat() * 0.2f + 0.1f;
        float zOffset = world.field_214.nextFloat() * 0.7f + 0.15f;
        class_142 entityitem = new class_142(world, (double)((float)i + xOffset), (double)((float)j + yOffset), (double)((float)k + zOffset), stack);
        float velocityFactor = 0.05f;
        entityitem.field_1603 = (float)world.field_214.nextGaussian() * velocityFactor;
        entityitem.field_1604 = (float)world.field_214.nextGaussian() * velocityFactor + 0.2f;
        entityitem.field_1605 = (float)world.field_214.nextGaussian() * velocityFactor;
        entityitem.field_566 = 10;
        world.method_210((class_57)entityitem);
    }

    public static void EjectSingleItemWithRandomOffset(class_18 world, int i, int j, int k, int iShiftedItemIndex, int iDamage) {
        class_31 ItemInstance = new class_31(iShiftedItemIndex, 1, iDamage);
        UnsortedUtils.ejectStackWithRandomOffset(world, i, j, k, ItemInstance);
    }

    public static void DropStackAsIfBlockHarvested(class_18 world, int i, int j, int k, class_31 stack) {
        float f1 = 0.7f;
        double d = (double)(world.field_214.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d1 = (double)(world.field_214.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        double d2 = (double)(world.field_214.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
        class_142 entityitem = new class_142(world, (double)i + d, (double)j + d1, (double)k + d2, stack);
        entityitem.field_566 = 10;
        world.method_210((class_57)entityitem);
    }

    public static void DropSingleItemAsIfBlockHarvested(class_18 world, int i, int j, int k, int iShiftedItemIndex, int iDamage) {
        class_31 ItemInstance = new class_31(iShiftedItemIndex, 1, iDamage);
        UnsortedUtils.DropStackAsIfBlockHarvested(world, i, j, k, ItemInstance);
    }

    public static int ConvertPlacingEntityOrientationToBlockFacing(class_127 entityLiving) {
        float pitch = entityLiving.field_1607;
        if (pitch > 60.0f) {
            return 1;
        }
        if (pitch < -60.0f) {
            return 0;
        }
        return UnsortedUtils.ConvertPlacingEntityOrientationToFlatBlockFacing(entityLiving);
    }

    public static int ConvertPlacingEntityOrientationToFlatBlockFacing(class_127 entityLiving) {
        float pitch = entityLiving.field_1607;
        int l = class_189.method_645((double)((double)(entityLiving.field_1606 * 4.0f / 360.0f) + 0.5)) & 3;
        int iFacing = l == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : 4));
        return iFacing;
    }

    public static int ConvertPlacingEntityOrientationToBlockFlatFacing(class_127 entityLiving) {
        int l = class_189.method_645((double)((double)(entityLiving.field_1606 * 4.0f / 360.0f) + 0.5)) & 3;
        int iFacing = l == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : 4));
        return iFacing;
    }

    public static boolean IsBlockBeingPrecipitatedOn(class_18 world, int i, int j, int k) {
        if (!world.method_270()) {
            return false;
        }
        if (!world.method_249(i, j, k)) {
            return false;
        }
        if (world.method_228(i, k) > j) {
            return false;
        }
        class_153 biomegenbase = world.method_1781().method_1787(i, k);
        if (biomegenbase.method_793()) {
            return true;
        }
        return biomegenbase.method_794();
    }

    public static void PositionAllMoveableEntitiesOutsideOfLocation(class_18 world, int i, int j, int k) {
        List list = world.method_211((class_57)null, class_25.method_94((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0)));
        if (list != null && list.size() > 0) {
            for (int listIndex = 0; listIndex < list.size(); ++listIndex) {
                class_57 entity = (class_57)list.get(listIndex);
                if (!entity.method_1380() && !(entity instanceof class_142)) continue;
                UnsortedUtils.PositionEntityOutsideOfLocation(world, entity, i, j, k);
            }
        }
    }

    private static void PositionEntityOutsideOfLocation(class_18 world, class_57 entity, int i, int j, int k) {
        double minPosX = i;
        double minPosY = j;
        double minPosZ = k;
        double maxPosX = i + 1;
        double maxPosY = j + 1;
        double maxPosZ = k + 1;
        boolean xOverlap = false;
        boolean yOverlap = false;
        boolean zOverlap = false;
        double xOffset = 0.0;
        double yOffset = 0.0;
        double zOffset = 0.0;
        if (entity.field_1610.field_129 <= maxPosX && entity.field_1610.field_132 >= minPosX) {
            xOverlap = true;
            xOffset = Math.abs(maxPosX - entity.field_1610.field_129) < Math.abs(minPosX - entity.field_1610.field_132) ? maxPosX - entity.field_1610.field_129 + 0.01 : minPosX - entity.field_1610.field_132 - 0.01;
        }
        if (entity.field_1610.field_130 <= maxPosY && entity.field_1610.field_133 >= minPosY) {
            yOverlap = true;
            yOffset = Math.abs(maxPosY - entity.field_1610.field_130) < Math.abs(minPosY - entity.field_1610.field_133) ? maxPosY - entity.field_1610.field_130 + 0.01 : minPosY - entity.field_1610.field_133 - 0.01;
        }
        if (entity.field_1610.field_131 <= maxPosZ && entity.field_1610.field_134 >= minPosZ) {
            zOverlap = true;
            zOffset = Math.abs(maxPosZ - entity.field_1610.field_131) < Math.abs(minPosZ - entity.field_1610.field_134) ? maxPosZ - entity.field_1610.field_131 + 0.01 : minPosZ - entity.field_1610.field_134 - 0.01;
        }
        double entityX = entity.field_1600;
        double entityY = entity.field_1601;
        double entityZ = entity.field_1602;
        if (xOverlap && Math.abs(xOffset) < 0.2 && (!yOverlap || Math.abs(xOffset) < Math.abs(yOffset)) && (!zOverlap || Math.abs(xOffset) < Math.abs(zOffset))) {
            entityX += xOffset;
        } else if (yOverlap && Math.abs(yOffset) < 0.2 && (!zOverlap || Math.abs(yOffset) < Math.abs(zOffset))) {
            entityY += yOffset;
        } else if (zOverlap && Math.abs(zOffset) < 0.2) {
            entityZ += zOffset;
        }
        entity.method_1340(entityX, entityY, entityZ);
    }

    public static void DestroyHorizontallyAttachedAxles(class_18 world, int i, int j, int k) {
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            AxleBlock axleBlock;
            BlockPosition tempPos = new BlockPosition(i, j, k);
            tempPos.AddFacingAsOffset(iFacing);
            if (world.method_1776(tempPos.i, tempPos.j, tempPos.k) != BlockListener.axleBlock.field_1915 || !(axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, tempPos.i, tempPos.j, tempPos.k, iFacing)) continue;
            axleBlock.BreakAxle(world, tempPos.i, tempPos.j, tempPos.k);
        }
    }

    public static boolean CanPlantGrowOnBlock(class_18 world, int i, int j, int k, class_17 plantBlock) {
        int iTargetid = world.method_1776(i, j, k);
        class_17 block = class_17.field_1937[iTargetid];
        if (block != null && block instanceof SoilTemplate) {
            return ((SoilTemplate)block).CanPlantGrowOnBlock(world, i, j, k, plantBlock);
        }
        return false;
    }
}

