/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.kozibrodka.wolves.container.AnvilScreenHandler;
import net.kozibrodka.wolves.entity.FallingAnvilEntity;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_127;
import net.minecraft.class_13;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class AnvilBlock
extends TemplateBlock
implements RotatableBlock,
BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    public static boolean fallInstantly = false;
    public static final float m_fAnvilBaseHeight = 0.125f;
    public static final float m_fAnvilBaseWidth = 0.5f;
    public static final float m_fAnvilHalfBaseWidth = 0.25f;
    public static final float m_fAnvilShaftHeight = 0.4375f;
    public static final float m_fAnvilShaftWidth = 0.25f;
    public static final float m_fAnvilHalfShaftWidth = 0.125f;
    public static final float m_fAnvilTopHeight = 0.4375f;
    public static final float m_fAnvilTopWidth = 0.375f;
    public static final float m_fAnvilTopHalfWidth = 0.1875f;

    public AnvilBlock(Identifier iid) {
        super(iid, class_15.field_984);
        this.method_1587(3.5f);
        this.method_1580(field_1933);
    }

    public int method_1607(int iSide) {
        return TextureListener.anvil;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        iFacing = iFacing < 2 ? 2 : UnsortedUtils.getOppositeFacing(iFacing);
        this.SetFacing(world, i, j, k, iFacing);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityLiving) {
        world.method_150((double)i, (double)j, (double)k, "wolves:anvil_place", 1.0f, 1.2f);
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToFlatBlockFacing(entityLiving);
        this.SetFacing(world, i, j, k, iFacing);
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityplayer) {
        ScreenHandlerListener.TempAnvilX = i;
        ScreenHandlerListener.TempAnvilY = j;
        ScreenHandlerListener.TempAnvilZ = k;
        GuiHelper.openGUI((class_54)entityplayer, (Identifier)Identifier.of((String)"wolves:openAnvil"), (class_134)entityplayer.field_519, (class_71)new AnvilScreenHandler(entityplayer.field_519, world, i, j, k));
        return true;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        if (iFacing == 2 || iFacing == 3) {
            return class_25.method_94((double)((float)i + 0.5f - 0.25f), (double)j, (double)k, (double)((float)i + 0.5f + 0.25f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
        }
        return class_25.method_94((double)i, (double)j, (double)((float)k + 0.5f - 0.25f), (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 0.5f + 0.25f));
    }

    public void method_1616(class_14 iblockaccess, int i, int j, int k) {
        int iFacing = this.GetFacing(iblockaccess, i, j, k);
        if (iFacing == 2 || iFacing == 3) {
            this.method_1578(0.25f, 0.0f, 0.0f, 0.75f, 1.0f, 1.0f);
        } else {
            this.method_1578(0.0f, 0.0f, 0.25f, 1.0f, 1.0f, 0.75f);
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k);
    }

    @Override
    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        world.method_215(i, j, k, iFacing);
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            world.method_216(i, j, k, this.field_1915, this.method_1565());
            world.method_235(i, j, j, this.field_1915);
        }
    }

    public void SetBlockBoundsRotatedAboutJToFacing(float x1, float y1, float z1, float x2, float y2, float z2, int iFacing) {
        float rotatedZ2;
        float rotatedX2;
        float rotatedZ1;
        float rotatedX1;
        if (iFacing == 4) {
            rotatedX1 = 1.0f - x2;
            rotatedZ1 = 1.0f - z2;
            rotatedX2 = 1.0f - x1;
            rotatedZ2 = 1.0f - z1;
        } else if (iFacing == 3) {
            rotatedX1 = z1;
            rotatedZ1 = x1;
            rotatedX2 = z2;
            rotatedZ2 = x2;
        } else if (iFacing == 2) {
            rotatedX1 = 1.0f - z2;
            rotatedZ1 = 1.0f - x2;
            rotatedX2 = 1.0f - z1;
            rotatedZ2 = 1.0f - x1;
        } else {
            rotatedX1 = x1;
            rotatedZ1 = z1;
            rotatedX2 = x2;
            rotatedZ2 = z2;
        }
        this.method_1578(rotatedX1, y1, rotatedZ1, rotatedX2, y2, rotatedZ2);
    }

    public void method_1609(class_18 arg, int i, int j, int k, int l) {
        arg.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1602(class_18 arg, int i, int j, int k, Random random) {
        this.method_436(arg, i, j, k);
    }

    private void method_436(class_18 arg, int i, int j, int k) {
        if (AnvilBlock.method_435(arg, i, j - 1, k) && j >= 0) {
            int facing = arg.method_1778(i, j, k);
            int var8 = 32;
            if (!fallInstantly && arg.method_155(i - var8, j - var8, k - var8, i + var8, j + var8, k + var8)) {
                FallingAnvilEntity var9 = new FallingAnvilEntity(arg, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, this.field_1915, facing);
                arg.method_210((class_57)var9);
            } else {
                arg.method_229(i, j, k, 0);
                while (AnvilBlock.method_435(arg, i, j - 1, k) && j > 0) {
                    --j;
                }
                if (j > 0) {
                    arg.method_201(i, j, k, this.field_1915, facing);
                }
            }
        }
    }

    public static boolean method_435(class_18 arg, int i, int j, int k) {
        int var4 = arg.method_1776(i, j, k);
        if (var4 == 0) {
            return true;
        }
        if (var4 == class_17.field_1892.field_1915) {
            return true;
        }
        class_15 var5 = class_17.field_1937[var4].field_1900;
        if (var5 == class_15.field_985) {
            return true;
        }
        return var5 == class_15.field_986;
    }

    public int method_1565() {
        return 3;
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        int l = this.GetFacing(tileView, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.0f, 0.0f, 0.25f, 1.0f, 0.125f, 0.75f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.375f, 0.125f, 0.375f, 0.625f, 0.5625f, 0.625f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.3125f, 0.5625f, 0.3125f, 0.6875f, 1.0f, 0.6875f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.6875f, 0.75f, 0.3125f, 0.75f, 1.0f, 0.6875f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.75f, 0.9375f, 0.3125f, 1.0f, 1.0f, 0.6875f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.25f, 0.75f, 0.3125f, 0.3125f, 1.0f, 0.6875f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.125f, 0.8125f, 0.375f, 0.25f, 1.0f, 0.625f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.SetBlockBoundsRotatedAboutJToFacing(0.0f, 0.875f, 0.4375f, 0.125f, 1.0f, 0.5625f, l);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1578(0.0f, 0.0f, 0.25f, 1.0f, 0.125f, 0.75f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.375f, 0.125f, 0.375f, 0.625f, 0.5625f, 0.625f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.3125f, 0.5625f, 0.3125f, 0.6875f, 1.0f, 0.6875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.6875f, 0.75f, 0.3125f, 0.75f, 1.0f, 0.6875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.75f, 0.9375f, 0.3125f, 1.0f, 1.0f, 0.6875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.25f, 0.75f, 0.3125f, 0.3125f, 1.0f, 0.6875f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.125f, 0.8125f, 0.375f, 0.25f, 1.0f, 0.625f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.0f, 0.875f, 0.4375f, 0.125f, 1.0f, 0.5625f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.anvil);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

