/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.entity.CauldronBlockEntity;
import net.kozibrodka.wolves.container.CauldronScreenHandler;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.ScreenPacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_142;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

public class CauldronBlock
extends TemplateBlockWithEntity
implements RotatableBlock {
    public final int cauldronTopTextureIndex = 17;
    public final int cauldronSideTextureIndex = 18;
    public final int cauldronBottomTextureIndex = 19;
    public static final double dCauldronCollisionBoxHeight = (double)0.99f;

    public CauldronBlock(Identifier iid) {
        super(iid, class_15.field_984);
        this.method_1584(true);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, this.field_1915, this.method_1565());
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        InventoryHandler.ejectInventoryContents(world, i, j, k, (class_134)world.method_1777(i, j, k));
        super.method_1630(world, i, j, k);
    }

    public int method_1607(int side) {
        if (side == 1) {
            return TextureListener.cauldron_top;
        }
        if (side == 0) {
            return TextureListener.cauldron_bottom;
        }
        return TextureListener.cauldron_side;
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        CauldronBlockEntity tileentitycauldron = (CauldronBlockEntity)world.method_1777(i, j, k);
        ScreenHandlerListener.TempGuiX = i;
        ScreenHandlerListener.TempGuiY = j;
        ScreenHandlerListener.TempGuiZ = k;
        if (world.field_180) {
            PacketHelper.send((class_169)new ScreenPacket("cauldron", 0, i, j, k));
        }
        GuiHelper.openGUI((class_54)entityPlayer, (Identifier)Identifier.of((String)"wolves:openCauldron"), (class_134)tileentitycauldron, (class_71)new CauldronScreenHandler((class_134)entityPlayer.field_519, tileentitycauldron));
        return true;
    }

    protected class_55 method_1251() {
        return new CauldronBlockEntity();
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)((double)j + (double)0.99f), (double)((double)k + 1.0));
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.GetFireUnderState((class_14)world, i, j, k) > 0) {
            for (int counter = 0; counter < 5; ++counter) {
                float smokeX = (float)i + random.nextFloat();
                float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
                float smokeZ = (float)k + random.nextFloat();
                world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void method_1615(class_18 world, int i, int j, int k, class_57 entity) {
        List collisionList = null;
        collisionList = world.method_175(class_142.class, class_25.method_94((double)i, (double)((double)j + (double)0.99f), (double)k, (double)(i + 1), (double)((double)j + (double)0.99f + (double)0.05f), (double)(k + 1)));
        if (collisionList != null && collisionList.size() > 0) {
            CauldronBlockEntity tileEntityCauldron = (CauldronBlockEntity)world.method_1777(i, j, k);
            for (int listIndex = 0; listIndex < collisionList.size(); ++listIndex) {
                double fFullBoxTop;
                class_142 targetEntityItem = (class_142)collisionList.get(listIndex);
                if (targetEntityItem.field_1630) continue;
                if (InventoryHandler.addItemInstanceToInventory(tileEntityCauldron, targetEntityItem.field_564)) {
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.pop", 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, "random.pop", i, j, k, 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    }
                    targetEntityItem.method_1386();
                    continue;
                }
                int iBlockAboveID = world.method_1776(i, j + 1, k);
                if (iBlockAboveID != class_17.field_1822.field_1915 && iBlockAboveID != class_17.field_1823.field_1915 || !(targetEntityItem.field_1610.field_130 < (fFullBoxTop = (double)j + 1.05))) continue;
                double offset = fFullBoxTop - targetEntityItem.field_1610.field_130;
                targetEntityItem.method_1340(targetEntityItem.field_1600, targetEntityItem.field_1601 + offset, targetEntityItem.field_1602);
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        this.ValidateFireUnderState(world, i, j, k);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        this.ValidateFireUnderState(world, i, j, k);
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world1, int l, int i1, int j1, boolean flag) {
    }

    public int GetFireUnderState(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 3;
    }

    private void SetFireUnderState(class_18 world, int i, int j, int k, int iState) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFFC;
        world.method_215(i, j, k, iMetaData |= iState & 3);
        world.method_243(i, j, k);
    }

    private void ValidateFireUnderState(class_18 world, int i, int j, int k) {
        int iOldState = this.GetFireUnderState((class_14)world, i, j, k);
        int iNewState = 0;
        if (world.method_1776(i, j - 1, k) == class_17.field_1892.field_1915) {
            iNewState = 1;
        } else if (world.method_1776(i, j - 1, k) == BlockListener.stokedFire.field_1915) {
            iNewState = 2;
        }
        if (iNewState != iOldState) {
            this.SetFireUnderState(world, i, j, k, iNewState);
            CauldronBlockEntity tileEntityCauldron = (CauldronBlockEntity)world.method_1777(i, j, k);
            tileEntityCauldron.NotifyOfChangeInFireUnder(iNewState);
        }
    }
}

