/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.itemblocks.CompanionCubeBlockItem;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_127;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.block.HasCustomBlockItemFactory;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@HasCustomBlockItemFactory(value=CompanionCubeBlockItem.class)
@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)
public class CompanionCubeBlock
extends TemplateBlock
implements RotatableBlock,
BlockWithInventoryRenderer {
    public final int m_iCubeTextureIDFront = 21;
    public final int m_iCubeGutsTextureID = 22;

    public CompanionCubeBlock(Identifier iid) {
        super(iid, class_15.field_990);
        this.field_1914 = 20;
    }

    public int method_1629(int iMetaData) {
        return (iMetaData & 8) <= 0 ? 0 : 1;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return true;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        if (this.GetHalfCubeState((class_14)world, i, j, k)) {
            return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 0.5f), (double)(k + 1));
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public class_25 method_1622(class_18 world, int i, int j, int k) {
        if (this.GetHalfCubeState((class_14)world, i, j, k)) {
            return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)((float)j + 0.5f), (double)(k + 1));
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
    }

    public void method_1616(class_14 iblockaccess, int i, int j, int k) {
        if (this.GetHalfCubeState(iblockaccess, i, j, k)) {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        } else {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public int method_1626(class_14 iblockaccess, int i, int j, int k, int iSide) {
        int iFacing = this.GetFacing(iblockaccess, i, j, k);
        if (this.GetHalfCubeState(iblockaccess, i, j, k)) {
            if (iSide == 1) {
                return TextureListener.companion_meat;
            }
        } else if (iSide == iFacing) {
            return TextureListener.companion_face;
        }
        return TextureListener.companion_side;
    }

    public int method_1607(int i) {
        if (i == 3) {
            return TextureListener.companion_face;
        }
        return TextureListener.companion_side;
    }

    public int method_1627(int iSide, int iMetaData) {
        if (iMetaData > 0) {
            if (iSide == 1) {
                return TextureListener.companion_meat;
            }
        } else if (iSide == 3) {
            return TextureListener.companion_face;
        }
        return TextureListener.companion_side;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        this.SetFacing(world, i, j, k, UnsortedUtils.getOppositeFacing(iFacing));
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityliving) {
        if (!this.GetHalfCubeState((class_14)world, i, j, k)) {
            CompanionCubeBlock.SpawnHearts(world, i, j, k);
        }
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToBlockFacing(entityliving);
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        if (!this.GetHalfCubeState((class_14)world, i, j, k)) {
            world.method_150((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "mob.wolf.whine", 0.5f, 2.6f + (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.8f);
        }
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        int iBlockBelowID = world.method_1776(i, j - 1, k);
        if (iBlockBelowID == this.field_1915) {
            if (this.GetHalfCubeState((class_14)world, i, j - 1, k)) {
                this.SetHalfCubeState(world, i, j - 1, k, false);
                world.method_229(i, j, k, 0);
                CompanionCubeBlock.SpawnHearts(world, i, j - 1, k);
            } else {
                super.method_1611(world, i, j, k);
            }
        } else {
            super.method_1611(world, i, j, k);
        }
    }

    public boolean canSuffocate(class_18 world, int i, int j, int k) {
        return !this.GetHalfCubeState((class_14)world, i, j, k);
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 0xFFFFFFF7;
    }

    @Override
    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iMetaData = world.method_1778(i, j, k) & 8;
        world.method_215(i, j, k, iMetaData |= iFacing);
        world.method_243(i, j, k);
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            if (world.field_214.nextInt(12) == 0) {
                world.method_150((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "mob.wolf.whine", 0.5f, 2.6f + (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.8f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "mob.wolf.whine", i, j, k, 0.5f, 2.6f + (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.8f);
                }
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    public boolean GetHalfCubeState(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 8) > 0;
    }

    public void SetHalfCubeState(class_18 world, int i, int j, int k, boolean bState) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFF7;
        if (bState) {
            iMetaData |= 8;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    public static void SpawnHearts(class_18 world, int i, int j, int k) {
        String s = "heart";
        for (int tempCount = 0; tempCount < 7; ++tempCount) {
            double d = world.field_214.nextGaussian() * 0.02;
            double d1 = world.field_214.nextGaussian() * 0.02;
            double d2 = world.field_214.nextGaussian() * 0.02;
            world.method_178(s, (double)i + (double)world.field_214.nextFloat(), (double)(j + 1) + (double)world.field_214.nextFloat(), (double)k + (double)world.field_214.nextFloat(), d, d1, d2);
        }
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        int byte0 = 0;
        if (meta > 0) {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            byte0 = 8;
        } else {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, byte0);
    }
}

