/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.entity.CrucibleBlockEntity;
import net.kozibrodka.wolves.container.CrucibleScreenHandler;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.ScreenPacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.minecraft.class_13;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_142;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.IntProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)
public class CrucibleBlock
extends TemplateBlockWithEntity
implements RotatableBlock,
BlockWithInventoryRenderer {
    public static final float m_fCrucibleHeight = 1.0f;
    public static final float m_fCrucibleWidth = 0.875f;
    public static final float m_fCrucibleHalfWidth = 0.4375f;
    public static final float m_fCrucibleBandHeight = 0.75f;
    public static final float m_fCrucibleBandHalfHeight = 0.375f;
    private final int m_iCrucibleTopTextureID = 42;
    private final int m_iCrucibleSideTextureID = 43;
    private final int m_iCrucibleBottomTextureID = 44;
    private final int m_iCrucibleContentsTextureID = 45;
    public static final double m_dCrucibleCollisionBoxHeight = (double)0.99f;
    private static boolean SETTING_TILE = false;
    public static final BooleanProperty LAVA = BooleanProperty.of((String)"lava");
    public static final IntProperty FULL = IntProperty.of((String)"full", (int)0, (int)27);

    public CrucibleBlock(Identifier iid) {
        super(iid, class_15.field_994);
        this.method_1587(0.6f);
        this.method_1580(field_1934);
        this.setDefaultState((BlockState)((BlockState)this.getDefaultState().with((Property)LAVA, (Comparable)Boolean.valueOf(false))).with((Property)FULL, (Comparable)Integer.valueOf(0)));
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public int method_1607(int i) {
        if (i == 0) {
            return TextureListener.crucible_bottom;
        }
        return i != 1 ? TextureListener.crucible_side : TextureListener.crucible_top;
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityPlayer) {
        CrucibleBlockEntity tileEntityCrucible = (CrucibleBlockEntity)world.method_1777(i, j, k);
        ScreenHandlerListener.TempGuiX = i;
        ScreenHandlerListener.TempGuiY = j;
        ScreenHandlerListener.TempGuiZ = k;
        if (world.field_180) {
            PacketHelper.send((class_169)new ScreenPacket("crucible", 0, i, j, k));
        }
        GuiHelper.openGUI((class_54)entityPlayer, (Identifier)Identifier.of((String)"wolves:openCrucible"), (class_134)tileEntityCrucible, (class_71)new CrucibleScreenHandler((class_134)entityPlayer.field_519, tileEntityCrucible));
        return true;
    }

    protected class_55 method_1251() {
        return new CrucibleBlockEntity();
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        if (!SETTING_TILE) {
            InventoryHandler.ejectInventoryContents(world, i, j, k, (class_134)world.method_1777(i, j, k));
        }
        super.method_1630(world, i, j, k);
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        return class_25.method_94((double)i, (double)j, (double)k, (double)(i + 1), (double)((double)j + (double)0.99f), (double)((double)k + 1.0));
    }

    public void method_1615(class_18 world, int i, int j, int k, class_57 entity) {
        List collisionList = null;
        collisionList = world.method_175(class_142.class, class_25.method_94((double)i, (double)((double)j + (double)0.99f), (double)k, (double)(i + 1), (double)((double)j + (double)0.99f + (double)0.05f), (double)(k + 1)));
        if (collisionList != null && collisionList.size() > 0) {
            CrucibleBlockEntity tileEntityCrucible = (CrucibleBlockEntity)world.method_1777(i, j, k);
            for (int listIndex = 0; listIndex < collisionList.size(); ++listIndex) {
                double fFullBoxTop;
                class_142 targetEntityItem = (class_142)collisionList.get(listIndex);
                if (targetEntityItem.field_1630) continue;
                if (InventoryHandler.addItemInstanceToInventory(tileEntityCrucible, targetEntityItem.field_564)) {
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.pop", 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, "random.pop", i, j, k, 0.25f, ((world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    }
                    targetEntityItem.method_1386();
                    continue;
                }
                int iBlockAboveID = world.method_1776(i, j + 1, k);
                if (iBlockAboveID != class_17.field_1822.field_1915 && iBlockAboveID != class_17.field_1823.field_1915 || !(targetEntityItem.field_1610.field_130 < (fFullBoxTop = (double)j + 1.05))) continue;
                double offset = fFullBoxTop - targetEntityItem.field_1610.field_130;
                targetEntityItem.method_1340(targetEntityItem.field_1600, targetEntityItem.field_1601 + offset, targetEntityItem.field_1602);
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public void Rotate(class_18 world1, int l, int i1, int j1, boolean flag) {
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        this.method_1578(0.0625f, 0.0f, 0.0625f, 0.1875f, 1.0f, 0.8125f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0625f, 0.0f, 0.8125f, 0.8125f, 1.0f, 0.9375f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.8125f, 0.0f, 0.1875f, 0.9375f, 1.0f, 0.9375f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.1875f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.1875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.125f, 0.8125f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.125f, 0.0f, 0.125f, 0.875f, 0.875f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.125f, 0.875f, 0.875f, 0.875f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.875f, 0.125f, 0.125f, 1.0f, 0.875f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.125f, 0.125f, 0.0f, 1.0f, 0.875f, 0.125f);
        tileRenderer.method_76((class_17)this, x, y, z);
        CrucibleBlockEntity fctileentitycrucible = (CrucibleBlockEntity)tileView.method_1777(x, y, z);
        int l = InventoryHandler.getOccupiedStacksCount(fctileentitycrucible);
        if (l > 0) {
            float f = (float)l / 27.0f;
            float f1 = 0.125f;
            float f2 = f1 + 0.0625f + (0.875f - (f1 + 0.0625f)) * f;
            this.method_1578(0.125f, f1, 0.125f, 0.875f, f2, 0.875f);
            if (fctileentitycrucible.overStokedFire) {
                CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, 237);
            } else {
                CustomBlockRendering.renderStandardBlockWithTexture(tileRenderer, (class_17)this, x, y, z, TextureListener.filler);
            }
        }
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.99f, 1.0f);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1578(0.0625f, 0.0f, 0.0625f, 0.1875f, 1.0f, 0.8125f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0625f, 0.0f, 0.8125f, 0.8125f, 1.0f, 0.9375f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.8125f, 0.0f, 0.1875f, 0.9375f, 1.0f, 0.9375f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.1875f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.1875f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.125f, 0.8125f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0f, 0.125f, 0.0f, 0.125f, 0.875f, 0.875f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0f, 0.125f, 0.875f, 0.875f, 0.875f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.875f, 0.125f, 0.125f, 1.0f, 0.875f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.125f, 0.125f, 0.0f, 1.0f, 0.875f, 0.125f);
        CustomBlockRendering.RenderInvBlockWithMetaData(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, 0);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void SetHasFull(class_18 world, int i, int j, int k, int slots) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)FULL, (Comparable)Integer.valueOf(slots)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    public void SetHasLava(class_18 world, int i, int j, int k, boolean bOn) {
        class_55 tileEntityBase = world.method_1777(i, j, k);
        if (tileEntityBase == null) {
            return;
        }
        SETTING_TILE = true;
        BlockState currentState = world.getBlockState(i, j, k);
        world.setBlockStateWithNotify(i, j, k, (BlockState)currentState.with((Property)LAVA, (Comparable)Boolean.valueOf(bOn)));
        SETTING_TILE = false;
        tileEntityBase.method_1073();
        world.method_157(i, j, k, tileEntityBase);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        builder.add(new Property[]{LAVA});
        builder.add(new Property[]{FULL});
    }
}

