/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ConfigListener;
import net.kozibrodka.wolves.events.ItemListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_124;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class GearboxBlock
extends TemplateBlock
implements MechanicalDevice,
RotatableBlock {
    public GearboxBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
        this.method_1584(true);
    }

    public int method_1626(class_14 iblockaccess, int i, int j, int k, int iSide) {
        int iFacing = this.GetFacing(iblockaccess, i, j, k);
        if (iSide == iFacing) {
            return TextureListener.gearbox_front;
        }
        BlockPosition sideBlockPos = new BlockPosition(i, j, k);
        sideBlockPos.AddFacingAsOffset(iSide);
        if (iblockaccess.method_1776(sideBlockPos.i, sideBlockPos.j, sideBlockPos.k) == BlockListener.axleBlock.field_1915 && ((AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing(iblockaccess, sideBlockPos.i, sideBlockPos.j, sideBlockPos.k, iSide) || iblockaccess.method_1776(sideBlockPos.i, sideBlockPos.j, sideBlockPos.k) == BlockListener.nonCollidingAxleBlock.field_1915 && ((AxleBlock)BlockListener.nonCollidingAxleBlock).IsAxleOrientedTowardsFacing(iblockaccess, sideBlockPos.i, sideBlockPos.j, sideBlockPos.k, iSide)) {
            return TextureListener.gearbox_output;
        }
        return TextureListener.gearbox_side;
    }

    public int method_1607(int iSide) {
        if (iSide == 3) {
            return TextureListener.gearbox_front;
        }
        return TextureListener.gearbox_side;
    }

    public int method_1565() {
        return 10;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        this.SetFacing(world, i, j, k, UnsortedUtils.getOppositeFacing(iFacing));
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityLiving) {
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToBlockFacing(entityLiving);
        if (ConfigListener.wolvesGlass.small_tweaks.faceGearBoxAwayFromPlayer.booleanValue()) {
            iFacing = UnsortedUtils.getOppositeFacing(iFacing);
        }
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, BlockListener.gearBox.field_1915, this.method_1565());
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        if (this.IsGearBoxOn((class_14)world, i, j, k)) {
            this.SetGearBoxOnState(world, i, j, k, false);
            this.ValidateOutputs(world, i, j, k, false);
        }
        super.method_1630(world, i, j, k);
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        world.method_216(i, j, k, BlockListener.gearBox.field_1915, this.method_1565());
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bIsRedstonePowered;
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsGearBoxOn((class_14)world, i, j, k);
        boolean bl = bIsRedstonePowered = world.method_263(i, j, k) || world.method_263(i, j + 1, k);
        if (bIsRedstonePowered) {
            bReceivingPower = false;
        }
        if (bOn != bReceivingPower) {
            if (bOn) {
                this.SetGearBoxOnState(world, i, j, k, false);
                this.ValidateOutputs(world, i, j, k, false);
            } else {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.05f, 1.0f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "random.explode", i, j, k, 0.05f, 1.0f);
                }
                this.EmitGearBoxParticles(world, i, j, k, random);
                this.SetGearBoxOnState(world, i, j, k, true);
                this.ValidateOutputs(world, i, j, k, true);
            }
        } else {
            this.ValidateOutputs(world, i, j, k, false);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.IsGearBoxOn((class_14)world, i, j, k)) {
            this.EmitGearBoxParticles(world, i, j, k, random);
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return iBlockAccess.method_1778(i, j, k) & 7;
    }

    @Override
    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iMetaData = world.method_1778(i, j, k) & 8;
        world.method_215(i, j, k, iMetaData |= iFacing);
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        System.out.println("METODA ROTATE W GEARBOX");
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            world.method_216(i, j, k, BlockListener.gearBox.field_1915, this.method_1565());
            world.method_235(i, j, k, BlockListener.gearBox.field_1915);
        }
        UnsortedUtils.DestroyHorizontallyAttachedAxles(world, i, j, k);
    }

    public boolean IsGearBoxOn(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 8) > 0;
    }

    public void SetGearBoxOnState(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k) & 7;
        if (bOn) {
            iMetaData |= 8;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    void EmitGearBoxParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    private void ValidateOutputs(class_18 world, int i, int j, int k, boolean bDestroyIfAlreadyPowered) {
        int blockFacing = this.GetFacing((class_14)world, i, j, k);
        boolean isOn = this.IsGearBoxOn((class_14)world, i, j, k);
        for (int facing = 0; facing <= 5; ++facing) {
            if (facing == blockFacing) continue;
            BlockPosition tempPos = new BlockPosition(i, j, k);
            tempPos.AddFacingAsOffset(facing);
            if (world.method_1776(tempPos.i, tempPos.j, tempPos.k) != BlockListener.axleBlock.field_1915 && world.method_1776(tempPos.i, tempPos.j, tempPos.k) != BlockListener.nonCollidingAxleBlock.field_1915) continue;
            AxleBlock axleBlock = (AxleBlock)BlockListener.axleBlock;
            if (world.method_1776(tempPos.i, tempPos.j, tempPos.k) == BlockListener.nonCollidingAxleBlock.field_1915) {
                axleBlock = (AxleBlock)BlockListener.nonCollidingAxleBlock;
            }
            if (!axleBlock.IsAxleOrientedTowardsFacing((class_14)world, tempPos.i, tempPos.j, tempPos.k, facing)) continue;
            int tempPowerLevel = axleBlock.GetPowerLevel((class_14)world, tempPos.i, tempPos.j, tempPos.k);
            if (tempPowerLevel > 0 && bDestroyIfAlreadyPowered) {
                axleBlock.BreakAxle(world, tempPos.i, tempPos.j, tempPos.k);
                continue;
            }
            if (isOn) {
                if (tempPowerLevel == 3) continue;
                axleBlock.SetPowerLevel(world, tempPos.i, tempPos.j, tempPos.k, 3);
                continue;
            }
            if (tempPowerLevel == 0) continue;
            axleBlock.SetPowerLevel(world, tempPos.i, tempPos.j, tempPos.k, 0);
        }
    }

    public void Overpower(class_18 world, int i, int j, int k) {
        boolean bIsRedstonePowered;
        boolean bl = bIsRedstonePowered = world.method_263(i, j, k) || world.method_263(i, j + 1, k);
        if (!bIsRedstonePowered) {
            this.BreakGearBox(world, i, j, k);
        }
    }

    public void BreakGearBox(class_18 world, int i, int j, int k) {
        int iTemp;
        for (iTemp = 0; iTemp < 4; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_17.field_1949.asItem().field_461, 0);
        }
        for (iTemp = 0; iTemp < 3; ++iTemp) {
            UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, ItemListener.gear.field_461, 0);
        }
        UnsortedUtils.EjectSingleItemWithRandomOffset(world, i, j, k, class_124.field_403.field_461, 0);
        world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
        if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(world, "random.explode", i, j, k, 0.05f, 1.0f);
        }
        world.method_229(i, j, k, 0);
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        BlockPosition targetBlockPos = new BlockPosition(i, j, k);
        targetBlockPos.AddFacingAsOffset(iFacing);
        int iTargetid = world.method_1776(targetBlockPos.i, targetBlockPos.j, targetBlockPos.k);
        return iTargetid == BlockListener.axleBlock.field_1915 && ((AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetBlockPos.i, targetBlockPos.j, targetBlockPos.k, iFacing) && ((AxleBlock)BlockListener.axleBlock).GetPowerLevel((class_14)world, targetBlockPos.i, targetBlockPos.j, targetBlockPos.k) > 0 || iTargetid == BlockListener.nonCollidingAxleBlock.field_1915 && ((AxleBlock)BlockListener.nonCollidingAxleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetBlockPos.i, targetBlockPos.j, targetBlockPos.k, iFacing) && ((AxleBlock)BlockListener.nonCollidingAxleBlock).GetPowerLevel((class_14)world, targetBlockPos.i, targetBlockPos.j, targetBlockPos.k) > 0;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int k) {
        return this.IsGearBoxOn((class_14)world, i, j, k);
    }
}

