/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.block.entity.MillStoneBlockEntity;
import net.kozibrodka.wolves.container.MillStoneScreenHandler;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.ScreenHandlerListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.ScreenPacket;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.InventoryHandler;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.minecraft.class_134;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.minecraft.class_55;
import net.minecraft.class_69;
import net.minecraft.class_71;
import net.modificationstation.stationapi.api.gui.screen.container.GuiHelper;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlockWithEntity;
import net.modificationstation.stationapi.api.util.Identifier;

public class MillStoneBlock
extends TemplateBlockWithEntity
implements MechanicalDevice {
    private static final int iMillStoneTickRate = 10;

    public MillStoneBlock(Identifier iid) {
        super(iid, class_15.field_983);
        this.method_1587(3.5f);
        this.method_1580(field_1928);
        this.method_1584(true);
    }

    public int method_1565() {
        return 10;
    }

    public int method_1607(int side) {
        if (side == 1) {
            return TextureListener.millstone_top;
        }
        if (side == 0) {
            return TextureListener.millstone_bottom;
        }
        return TextureListener.millstone_side;
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, BlockListener.millStone.field_1915, this.method_1565());
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        if (this.IsBlockOn(world, i, j, k) != bReceivingPower) {
            world.method_216(i, j, k, BlockListener.millStone.field_1915, this.method_1565());
        }
    }

    public boolean method_1608(class_18 world, int i, int j, int k, class_54 entityplayer) {
        MillStoneBlockEntity tileEntityMillStone = (MillStoneBlockEntity)world.method_1777(i, j, k);
        ScreenHandlerListener.TempGuiX = i;
        ScreenHandlerListener.TempGuiY = j;
        ScreenHandlerListener.TempGuiZ = k;
        if (world.field_180) {
            PacketHelper.send((class_169)new ScreenPacket("mill", 0, i, j, k));
        }
        GuiHelper.openGUI((class_54)entityplayer, (Identifier)Identifier.of((String)"wolves:openMillStone"), (class_134)tileEntityMillStone, (class_71)new MillStoneScreenHandler((class_134)entityplayer.field_519, tileEntityMillStone));
        return true;
    }

    protected class_55 method_1251() {
        return new MillStoneBlockEntity();
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bOn = this.IsBlockOn(world, i, j, k);
        if (bOn != bReceivingPower) {
            if (bOn) {
                this.SetBlockOn(world, i, j, k, false);
            } else {
                MillStoneBlockEntity tileEntityMillStone = (MillStoneBlockEntity)world.method_1777(i, j, k);
                if (tileEntityMillStone.IsWholeCompanionCubeNextToBeProcessed()) {
                    world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "mob.wolf.hurt", 5.0f, (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.2f + 1.0f);
                    if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                        this.voicePacket(world, "mob.wolf.hurt", i, j, k, 5.0f, (world.field_214.nextFloat() - world.field_214.nextFloat()) * 0.2f + 1.0f);
                    }
                }
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.2f, 1.25f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "random.explode", i, j, k, 0.2f, 1.25f);
                }
                this.EmitMillingParticles(world, i, j, k, random);
                this.SetBlockOn(world, i, j, k, true);
            }
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    public void method_1617(class_18 world, int i, int j, int k, Random random) {
        if (this.IsBlockOn(world, i, j, k)) {
            this.EmitMillingParticles(world, i, j, k, random);
            if (random.nextInt(5) == 0) {
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.explode", 0.1f + random.nextFloat() * 0.1f, 1.25f + random.nextFloat() * 0.1f);
            }
        }
    }

    public void method_1630(class_18 world, int i, int j, int k) {
        InventoryHandler.ejectInventoryContents(world, i, j, k, (class_134)world.method_1777(i, j, k));
        super.method_1630(world, i, j, k);
    }

    public boolean IsBlockOn(class_18 world, int i, int j, int k) {
        return world.method_1778(i, j, k) > 0;
    }

    public void SetBlockOn(class_18 world, int i, int j, int k, boolean bOn) {
        if (bOn) {
            world.method_215(i, j, k, 1);
            world.method_243(i, j, k);
        } else {
            world.method_215(i, j, k, 0);
            world.method_243(i, j, k);
        }
    }

    void EmitMillingParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 5; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f + 1.0f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        int blockId;
        BlockPosition targetPos;
        int iFacing;
        for (iFacing = 0; iFacing <= 1; ++iFacing) {
            AxleBlock axleBlock;
            targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            blockId = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (blockId != BlockListener.axleBlock.field_1915 || !(axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) || axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) <= 0) continue;
            return true;
        }
        for (iFacing = 2; iFacing <= 5; ++iFacing) {
            class_17 targetBlock;
            MechanicalDevice device;
            targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            blockId = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (blockId != BlockListener.handCrank.field_1915 || !(device = (MechanicalDevice)(targetBlock = class_17.field_1937[blockId])).IsOutputtingMechanicalPower(world, targetPos.i, targetPos.j, targetPos.k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }
}

