/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kozibrodka.wolves.recipe.TurntableInput;
import net.kozibrodka.wolves.recipe.TurntableRecipe;
import net.kozibrodka.wolves.recipe.TurntableResult;

public class TurntableRecipeRegistry {
    private static final TurntableRecipeRegistry INSTANCE = new TurntableRecipeRegistry();
    private final ArrayList<TurntableRecipe> recipes = new ArrayList();
    private final Map<Integer, Integer[][]> rotations = new HashMap<Integer, Integer[][]>();

    public static TurntableRecipeRegistry getInstance() {
        return INSTANCE;
    }

    public void addRotation(int blockId, Integer[][] values) {
        this.rotations.put(blockId, values);
    }

    public Integer[][] getRotationValue(int blockId) {
        return this.rotations.get(blockId);
    }

    public void addTurntableRecipe(TurntableRecipe turntableRecipe) {
        this.recipes.add(turntableRecipe);
    }

    public TurntableResult getResult(TurntableInput turntableInput) {
        if (turntableInput == null) {
            return null;
        }
        for (TurntableRecipe turntableRecipe : this.recipes) {
            if (!turntableInput.equals(turntableRecipe.turntableInput())) continue;
            return turntableRecipe.turntableResult();
        }
        return null;
    }

    public ArrayList<TurntableRecipe> getRecipes() {
        return this.recipes;
    }
}

