/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.FabricLoader;
import net.kozibrodka.wolves.api.AffectedByBellows;
import net.kozibrodka.wolves.api.MechanicalPowerConsumer;
import net.kozibrodka.wolves.block.AxleBlock;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.network.SoundPacket;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.MechanicalDevice;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.kozibrodka.wolves.utils.UnsortedUtils;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_142;
import net.minecraft.class_15;
import net.minecraft.class_169;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class BellowsBlock
extends TemplateBlock
implements MechanicalDevice,
RotatableBlock,
MechanicalPowerConsumer {
    private static final int m_iBellowsTickRate = 10;

    public BellowsBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
        this.method_1584(true);
    }

    public int method_1626(class_14 blockAccess, int i, int j, int k, int iSide) {
        int iFacing = this.GetFacing(blockAccess, i, j, k);
        if (iSide == iFacing) {
            return TextureListener.bellows_front;
        }
        if (iSide == 1) {
            return TextureListener.bellows_top;
        }
        return iSide != 0 ? TextureListener.bellows_side : TextureListener.bellows_top;
    }

    public int method_1607(int iSide) {
        if (iSide == 3) {
            return TextureListener.bellows_front;
        }
        if (iSide == 1) {
            return TextureListener.bellows_top;
        }
        return iSide != 0 ? TextureListener.bellows_side : TextureListener.bellows_top;
    }

    public void method_1605() {
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.6875f, 1.0f);
    }

    public int method_1565() {
        return 10;
    }

    public void method_1606(class_18 world, int i, int j, int k, int iFacing) {
        if (iFacing < 2) {
            iFacing = 2;
        }
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1614(class_18 world, int i, int j, int k, class_127 entityLiving) {
        int iFacing = UnsortedUtils.ConvertPlacingEntityOrientationToFlatBlockFacing(entityLiving);
        this.SetFacing(world, i, j, k, iFacing);
    }

    public void method_1611(class_18 world, int i, int j, int k) {
        super.method_1611(world, i, j, k);
        world.method_216(i, j, k, BlockListener.bellows.field_1915, this.method_1565());
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public class_25 method_1624(class_18 world, int i, int j, int k) {
        if (this.IsBlockMechanicalOn((class_14)world, i, j, k)) {
            return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 0.6875f), (double)((float)k + 1.0f));
        }
        return class_25.method_94((double)i, (double)j, (double)k, (double)((float)i + 1.0f), (double)((float)j + 1.0f), (double)((float)k + 1.0f));
    }

    public void method_1616(class_14 iBlockAccess, int i, int j, int k) {
        if (this.IsBlockMechanicalOn(iBlockAccess, i, j, k)) {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.6875f, 1.0f);
        } else {
            this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void method_1609(class_18 world, int i, int j, int k, int iid) {
        world.method_216(i, j, k, BlockListener.bellows.field_1915, this.method_1565());
    }

    public void method_1602(class_18 world, int i, int j, int k, Random random) {
        boolean bReceivingMechanicalPower = this.IsInputtingMechanicalPower(world, i, j, k);
        boolean bMechanicalOn = this.IsBlockMechanicalOn((class_14)world, i, j, k);
        if (bMechanicalOn != bReceivingMechanicalPower) {
            if (bReceivingMechanicalPower) {
                this.blow(world, i, j, k);
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "fire.ignite", 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "fire.ignite", i, j, k, 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
                }
            } else {
                this.LiftCollidingEntities(world, i, j, k);
                world.method_150((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "fire.ignite", 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
                if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
                    this.voicePacket(world, "fire.ignite", i, j, k, 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
                }
            }
            this.SetBlockMechanicalOn(world, i, j, k, bReceivingMechanicalPower);
            world.method_202(i, j, k, i, j, k);
        }
    }

    @Environment(value=EnvType.SERVER)
    public void voicePacket(class_18 world, String name, int x, int y, int z, float g, float h) {
        List list2 = world.field_200;
        if (list2.size() != 0) {
            for (int k = 0; k < list2.size(); ++k) {
                class_69 player1 = (class_69)list2.get(k);
                PacketHelper.sendTo((class_54)player1, (class_169)new SoundPacket(name, x, y, z, g, h));
            }
        }
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 3) + 2;
    }

    @Override
    public void SetFacing(class_18 world, int i, int j, int k, int iFacing) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFFC;
        iFacing = iFacing >= 2 ? (iFacing -= 2) : 0;
        world.method_215(i, j, k, iMetaData |= iFacing);
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public void Rotate(class_18 world, int i, int j, int k, boolean bReverse) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iNewFacing = UnsortedUtils.RotateFacingAroundJ(iFacing, bReverse);
        if (iNewFacing != iFacing) {
            this.SetFacing(world, i, j, k, iNewFacing);
            world.method_202(i, j, k, i, j, k);
            world.method_216(i, j, k, BlockListener.bellows.field_1915, this.method_1565());
            world.method_235(i, j, k, BlockListener.bellows.field_1915);
        }
        UnsortedUtils.DestroyHorizontallyAttachedAxles(world, i, j, k);
    }

    @Override
    public boolean CanOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean CanInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean IsInputtingMechanicalPower(class_18 world, int i, int j, int k) {
        for (int iFacing = 2; iFacing <= 5; ++iFacing) {
            class_17 targetBlock;
            MechanicalDevice device;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (iTargetid != BlockListener.handCrank.field_1915 || !(device = (MechanicalDevice)(targetBlock = class_17.field_1937[iTargetid])).IsOutputtingMechanicalPower(world, targetPos.i, targetPos.j, targetPos.k)) continue;
            return true;
        }
        int iSawFacing = this.GetFacing((class_14)world, i, j, k);
        for (int iFacing = 0; iFacing <= 5; ++iFacing) {
            AxleBlock axleBlock;
            if (iFacing == iSawFacing || iFacing == 1) continue;
            BlockPosition targetPos = new BlockPosition(i, j, k);
            targetPos.AddFacingAsOffset(iFacing);
            int iTargetid = world.method_1776(targetPos.i, targetPos.j, targetPos.k);
            if (iTargetid != BlockListener.axleBlock.field_1915 || !(axleBlock = (AxleBlock)BlockListener.axleBlock).IsAxleOrientedTowardsFacing((class_14)world, targetPos.i, targetPos.j, targetPos.k, iFacing) || axleBlock.GetPowerLevel((class_14)world, targetPos.i, targetPos.j, targetPos.k) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean IsOutputtingMechanicalPower(class_18 world, int i, int j, int l) {
        return false;
    }

    public boolean IsBlockMechanicalOn(class_14 iBlockAccess, int i, int j, int k) {
        return (iBlockAccess.method_1778(i, j, k) & 4) > 0;
    }

    public void SetBlockMechanicalOn(class_18 world, int i, int j, int k, boolean bOn) {
        int iMetaData = world.method_1778(i, j, k) & 0xFFFFFFFB;
        if (bOn) {
            iMetaData |= 4;
        }
        world.method_215(i, j, k, iMetaData);
        world.method_243(i, j, k);
    }

    private void EmitBellowsParticles(class_18 world, int i, int j, int k, Random random) {
        for (int counter = 0; counter < 10; ++counter) {
            float smokeX = (float)i + random.nextFloat();
            float smokeY = (float)j + random.nextFloat() * 0.5f;
            float smokeZ = (float)k + random.nextFloat();
            world.method_178("smoke", (double)smokeX, (double)smokeY, (double)smokeZ, 0.0, 0.0, 0.0);
        }
    }

    private void blow(class_18 world, int i, int j, int k) {
        int iFacing = this.GetFacing((class_14)world, i, j, k);
        int iFacingSide1 = UnsortedUtils.RotateFacingAroundJ(iFacing, false);
        int iFacingSide2 = UnsortedUtils.RotateFacingAroundJ(iFacing, true);
        BlockPosition particlePos = new BlockPosition(i, j, k);
        particlePos.AddFacingAsOffset(iFacing);
        this.EmitBellowsParticles(world, particlePos.i, particlePos.j, particlePos.k, world.field_214);
        BlockPosition tempTargetPos = new BlockPosition(i, j, k);
        for (int iTempCount = 0; iTempCount < 3; ++iTempCount) {
            tempTargetPos.AddFacingAsOffset(iFacing);
            int tempid = world.method_1776(tempTargetPos.i, tempTargetPos.j, tempTargetPos.k);
            class_17 blockWithInterface = class_17.field_1937[tempid];
            if (blockWithInterface != null && blockWithInterface instanceof AffectedByBellows) {
                ((AffectedByBellows)blockWithInterface).affectBlock(world, tempTargetPos.i, tempTargetPos.j, tempTargetPos.k, tempTargetPos, iFacing);
                continue;
            }
            if (tempid == class_17.field_1892.field_1915 || tempid == BlockListener.stokedFire.field_1915) {
                this.StokeFire(world, tempTargetPos.i, tempTargetPos.j, tempTargetPos.k);
            } else if (!world.method_234(tempTargetPos.i, tempTargetPos.j, tempTargetPos.k)) break;
            BlockPosition tempSidePos1 = new BlockPosition(tempTargetPos.i, tempTargetPos.j, tempTargetPos.k);
            tempSidePos1.AddFacingAsOffset(iFacingSide1);
            tempid = world.method_1776(tempSidePos1.i, tempSidePos1.j, tempSidePos1.k);
            if (tempid == class_17.field_1892.field_1915 || tempid == BlockListener.stokedFire.field_1915) {
                this.StokeFire(world, tempSidePos1.i, tempSidePos1.j, tempSidePos1.k);
            }
            BlockPosition tempSidePos2 = new BlockPosition(tempTargetPos.i, tempTargetPos.j, tempTargetPos.k);
            tempSidePos2.AddFacingAsOffset(iFacingSide2);
            tempid = world.method_1776(tempSidePos2.i, tempSidePos2.j, tempSidePos2.k);
            if (tempid != class_17.field_1892.field_1915 && tempid != BlockListener.stokedFire.field_1915) continue;
            this.StokeFire(world, tempSidePos2.i, tempSidePos2.j, tempSidePos2.k);
        }
    }

    private void StokeFire(class_18 world, int i, int j, int k) {
        if (world.method_1776(i, j - 1, k) == BlockListener.hibachi.field_1915) {
            if (world.method_1776(i, j, k) == BlockListener.stokedFire.field_1915) {
                world.method_215(i, j, k, 0);
                world.method_243(i, j, k);
            } else {
                world.method_229(i, j, k, BlockListener.stokedFire.field_1915);
                world.method_243(i, j, k);
            }
            if (world.method_234(i, j + 1, k)) {
                world.method_229(i, j + 1, k, BlockListener.stokedFire.field_1915);
                world.method_243(i, j, k);
            }
            if (world.method_1776(i, j + 1, k) == BlockListener.stokedFire.field_1915) {
                world.method_215(i, j + 1, k, 0);
                world.method_243(i, j, k);
            }
        } else {
            world.method_229(i, j, k, 0);
            world.method_243(i, j, k);
        }
    }

    private void LiftCollidingEntities(class_18 world, int i, int j, int k) {
        List list = world.method_211(null, class_25.method_94((double)i, (double)((float)j + 0.6875f), (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1)));
        float extendedMaxY = j + 1;
        if (list != null && list.size() > 0) {
            for (int j1 = 0; j1 < list.size(); ++j1) {
                double tempEntityMinY;
                class_57 tempEntity = (class_57)list.get(j1);
                if (tempEntity.field_1630 || !tempEntity.method_1380() && !(tempEntity instanceof class_142) || !((tempEntityMinY = tempEntity.field_1610.field_130) < (double)extendedMaxY)) continue;
                double entityYOffset = (double)extendedMaxY - tempEntityMinY;
                tempEntity.method_1340(tempEntity.field_1600, tempEntity.field_1601 + entityYOffset, tempEntity.field_1602);
            }
        }
    }

    @Override
    public void receivePower(class_18 world, int x, int y, int z, int side) {
        this.blow(world, x, y, z);
        world.method_150((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
        if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(world, "fire.ignite", x, y, z, 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
        }
        this.SetBlockMechanicalOn(world, x, y, z, true);
        world.method_202(x, y, z, x, y, z);
    }

    @Override
    public void stopReceivingPower(class_18 world, int x, int y, int z, int side) {
        this.LiftCollidingEntities(world, x, y, z);
        world.method_150((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
        if (FabricLoader.INSTANCE.getEnvironmentType() == EnvType.SERVER) {
            this.voicePacket(world, "fire.ignite", x, y, z, 0.5f, world.field_214.nextFloat() * 0.4f + 2.0f);
        }
        this.SetBlockMechanicalOn(world, x, y, z, false);
        world.method_202(x, y, z, x, y, z);
    }
}

