/*
 * Decompiled with CFR 0.152.
 */
package net.kozibrodka.wolves.block;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.EnvironmentInterface;
import net.fabricmc.api.EnvironmentInterfaces;
import net.kozibrodka.wolves.block.AnchorBlock;
import net.kozibrodka.wolves.entity.LiftedBlockEntity;
import net.kozibrodka.wolves.entity.MovingAnchorEntity;
import net.kozibrodka.wolves.entity.MovingPlatformEntity;
import net.kozibrodka.wolves.events.BlockListener;
import net.kozibrodka.wolves.events.TextureListener;
import net.kozibrodka.wolves.utils.BlockPosition;
import net.kozibrodka.wolves.utils.CustomBlockRendering;
import net.kozibrodka.wolves.utils.RotatableBlock;
import net.minecraft.class_13;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.client.model.block.BlockWithInventoryRenderer;
import net.modificationstation.stationapi.api.client.model.block.BlockWithWorldRenderer;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

@EnvironmentInterfaces(value={@EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithWorldRenderer.class), @EnvironmentInterface(value=EnvType.CLIENT, itf=BlockWithInventoryRenderer.class)})
public class PlatformBlock
extends TemplateBlock
implements RotatableBlock,
BlockWithWorldRenderer,
BlockWithInventoryRenderer {
    private final int iPlatformTopTextureIndex = 72;
    private final int iPlatformSideTextureIndex = 73;
    private final int iPlatformBottomTextureIndex = 74;
    private final boolean[][][] bPlatformAlreadyConsideredForEntityConversion;
    private final boolean[][][] bPlatformAlreadyConsideredForConnectedTest;

    public PlatformBlock(Identifier iid) {
        super(iid, class_15.field_982);
        this.method_1587(2.0f);
        this.method_1580(field_1929);
        this.bPlatformAlreadyConsideredForEntityConversion = new boolean[5][5][5];
        this.bPlatformAlreadyConsideredForConnectedTest = new boolean[5][5][5];
        this.ResetPlatformConsideredForEntityConversionArray();
        this.ResetPlatformConsideredForConnectedTestArray();
    }

    public int method_1607(int iSide) {
        if (iSide == 1) {
            return TextureListener.platform_top;
        }
        return iSide != 0 ? TextureListener.platform_side : TextureListener.platform_top;
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return true;
    }

    public boolean canSuffocate(class_18 world, int i, int j, int l) {
        return true;
    }

    @Override
    public int GetFacing(class_14 iBlockAccess, int i, int j, int l) {
        return 0;
    }

    @Override
    public void SetFacing(class_18 world1, int l, int i1, int j1, int k1) {
    }

    @Override
    public boolean CanRotate(class_14 iBlockAccess, int i, int j, int l) {
        return false;
    }

    @Override
    public boolean CanTransmitRotation(class_14 iBlockAccess, int i, int j, int l) {
        return true;
    }

    @Override
    public void Rotate(class_18 world1, int l, int i1, int j1, boolean flag) {
    }

    private void ConvertToEntity(class_18 world, int i, int j, int k, MovingAnchorEntity associatedAnchorEntity) {
        MovingPlatformEntity entityPlatform = new MovingPlatformEntity(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, associatedAnchorEntity);
        world.method_210((class_57)entityPlatform);
        this.AttemptToLiftBlockWithPlatform(world, i, j + 1, k);
        world.method_229(i, j, k, 0);
    }

    private void AttemptToLiftBlockWithPlatform(class_18 world, int i, int j, int k) {
        if (LiftedBlockEntity.CanBlockBeConvertedToEntity(world, i, j, k)) {
            new LiftedBlockEntity(world, i, j, k);
        }
    }

    private int GetDistToClosestConnectedAnchorPoint(class_18 world, int i, int j, int k) {
        int iClosestDist = -1;
        for (int tempI = i - 2; tempI <= i + 2; ++tempI) {
            for (int tempJ = j - 2; tempJ <= j + 2; ++tempJ) {
                for (int tempK = k - 2; tempK <= k + 2; ++tempK) {
                    int iUpwardsid;
                    int iTempid = world.method_1776(tempI, tempJ, tempK);
                    if (iTempid != this.field_1915 || (iUpwardsid = world.method_1776(tempI, tempJ + 1, tempK)) != BlockListener.anchor.field_1915 || ((AnchorBlock)BlockListener.anchor).getAnchorFacing((class_14)world, tempI, tempJ + 1, tempK) != 1 || !this.IsPlatformConnectedToAnchorPoint(world, i, j, k, tempI, tempJ, tempK)) continue;
                    int iTempDist = Math.abs(tempI - i) + Math.abs(tempJ - j) + Math.abs(tempK - k);
                    if (iClosestDist != -1 && iTempDist >= iClosestDist) continue;
                    iClosestDist = iTempDist;
                }
            }
        }
        return iClosestDist;
    }

    private boolean IsPlatformConnectedToAnchorPoint(class_18 world, int platformI, int platformJ, int platformK, int anchorPointI, int anchorPointJ, int anchorPointK) {
        this.ResetPlatformConsideredForConnectedTestArray();
        if (platformI == anchorPointI && platformJ == anchorPointJ && platformK == anchorPointK) {
            return true;
        }
        return this.PropogateTestForConnected(world, anchorPointI, anchorPointJ, anchorPointK, anchorPointI, anchorPointJ, anchorPointK, platformI, platformJ, platformK);
    }

    private boolean PropogateTestForConnected(class_18 world, int i, int j, int k, int sourceI, int sourceJ, int sourceK, int targetI, int targetJ, int targetK) {
        int iDeltaI = i - sourceI;
        int iDeltaJ = j - sourceJ;
        int iDeltaK = k - sourceK;
        if (this.bPlatformAlreadyConsideredForConnectedTest[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2]) {
            return false;
        }
        this.bPlatformAlreadyConsideredForConnectedTest[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2] = true;
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPosition tempPos = new BlockPosition(i, j, k);
            tempPos.AddFacingAsOffset(iFacing);
            if (tempPos.i == targetI && tempPos.j == targetJ && tempPos.k == targetK) {
                return true;
            }
            int iTempid = world.method_1776(tempPos.i, tempPos.j, tempPos.k);
            if (iTempid != this.field_1915) continue;
            int tempDistI = Math.abs(sourceI - tempPos.i);
            int tempDistJ = Math.abs(sourceJ - tempPos.j);
            int tempDistK = Math.abs(sourceK - tempPos.k);
            if (tempDistI > 2 || tempDistJ > 2 || tempDistK > 2 || !this.PropogateTestForConnected(world, tempPos.i, tempPos.j, tempPos.k, sourceI, sourceJ, sourceK, targetI, targetJ, targetK)) continue;
            return true;
        }
        return false;
    }

    void ResetPlatformConsideredForEntityConversionArray() {
        for (int tempI = 0; tempI < 5; ++tempI) {
            for (int tempJ = 0; tempJ < 5; ++tempJ) {
                for (int tempK = 0; tempK < 5; ++tempK) {
                    this.bPlatformAlreadyConsideredForEntityConversion[tempI][tempJ][tempK] = false;
                }
            }
        }
    }

    void ResetPlatformConsideredForConnectedTestArray() {
        for (int tempI = 0; tempI < 5; ++tempI) {
            for (int tempJ = 0; tempJ < 5; ++tempJ) {
                for (int tempK = 0; tempK < 5; ++tempK) {
                    this.bPlatformAlreadyConsideredForConnectedTest[tempI][tempJ][tempK] = false;
                }
            }
        }
    }

    public void covertToEntitiesFromThisPlatform(class_18 world, int i, int j, int k, MovingAnchorEntity associatedAnchorEntity) {
        this.ResetPlatformConsideredForEntityConversionArray();
        this.PropogateCovertToEntity(world, i, j, k, associatedAnchorEntity, i, j, k);
    }

    private void PropogateCovertToEntity(class_18 world, int i, int j, int k, MovingAnchorEntity associatedAnchorEntity, int sourceI, int sourceJ, int sourceK) {
        int iDeltaI = i - sourceI;
        int iDeltaJ = j - sourceJ;
        int iDeltaK = k - sourceK;
        if (this.bPlatformAlreadyConsideredForEntityConversion[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2]) {
            return;
        }
        this.bPlatformAlreadyConsideredForEntityConversion[iDeltaI + 2][iDeltaJ + 2][iDeltaK + 2] = true;
        int distToSource = Math.abs(iDeltaI) + Math.abs(iDeltaJ) + Math.abs(iDeltaK);
        int closestAnchorDist = this.GetDistToClosestConnectedAnchorPoint(world, i, j, k);
        if (closestAnchorDist != -1 && distToSource > closestAnchorDist) {
            return;
        }
        this.ConvertToEntity(world, i, j, k, associatedAnchorEntity);
        for (int iFacing = 0; iFacing < 6; ++iFacing) {
            BlockPosition tempPos = new BlockPosition(i, j, k);
            tempPos.AddFacingAsOffset(iFacing);
            int iTempid = world.method_1776(tempPos.i, tempPos.j, tempPos.k);
            if (iTempid != this.field_1915) continue;
            int tempDistI = Math.abs(sourceI - tempPos.i);
            int tempDistJ = Math.abs(sourceJ - tempPos.j);
            int tempDistK = Math.abs(sourceK - tempPos.k);
            if (tempDistI > 2 || tempDistJ > 2 || tempDistK > 2) continue;
            this.PropogateCovertToEntity(world, tempPos.i, tempPos.j, tempPos.k, associatedAnchorEntity, sourceI, sourceJ, sourceK);
        }
    }

    public boolean renderWorld(class_13 tileRenderer, class_14 tileView, int x, int y, int z) {
        if (tileView.method_1776(x - 1, y, z) != this.field_1915) {
            this.method_1578(1.0E-4f, 0.0625f, 1.0E-4f, 0.0625f, 0.9375f, 0.9999f);
            tileRenderer.method_76((class_17)this, x, y, z);
        }
        if (tileView.method_1776(x, y, z + 1) != this.field_1915) {
            this.method_1578(0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f, 1.0f);
            tileRenderer.method_76((class_17)this, x, y, z);
        }
        if (tileView.method_1776(x + 1, y, z) != this.field_1915) {
            this.method_1578(0.9375f, 0.0625f, 1.0E-4f, 0.9999f, 0.9375f, 0.9999f);
            tileRenderer.method_76((class_17)this, x, y, z);
        }
        if (tileView.method_1776(x, y, z - 1) != this.field_1915) {
            this.method_1578(0.0f, 0.0625f, 0.0f, 1.0f, 0.9375f, 0.0625f);
            tileRenderer.method_76((class_17)this, x, y, z);
        }
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.9375f, 0.0f, 1.0f, 1.0f, 1.0f);
        tileRenderer.method_76((class_17)this, x, y, z);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return true;
    }

    public void renderInventory(class_13 tileRenderer, int meta) {
        this.method_1578(1.0E-5f, 1.0E-5f, 1.0E-5f, 0.0625f, 0.99999f, 0.99999f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_side);
        this.method_1578(0.0f, 0.0f, 0.9375f, 1.0f, 1.0f, 1.0f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_side);
        this.method_1578(0.9375f, 1.0E-5f, 1.0E-5f, 0.99999f, 0.99999f, 0.99999f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_side);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0625f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_side);
        this.method_1578(1.0E-4f, 0.001f, 1.0E-4f, 0.9999f, 0.0625f, 0.9999f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_top);
        this.method_1578(1.0E-4f, 0.9375f, 1.0E-4f, 0.9999f, 0.999f, 0.9999f);
        CustomBlockRendering.RenderInvBlockWithTexture(tileRenderer, (class_17)this, -0.5f, -0.5f, -0.5f, TextureListener.platform_top);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

