/*
 * Decompiled with CFR 0.152.
 */
package xyz.hajsori.simplemacro.websocket;

import com.google.gson.JsonObject;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import java.net.InetSocketAddress;
import net.minecraft.Util;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import xyz.hajsori.simplemacro.Constants;
import xyz.hajsori.simplemacro.config.ClientConfig;
import xyz.hajsori.simplemacro.websocket.ActionManager;

public class SimpleWebSocketServer
extends WebSocketServer {
    private static Logger LOGGER;
    private static ClientConfig CLIENT_CONFIG;

    public SimpleWebSocketServer() {
        super(new InetSocketAddress(0));
        LOGGER = Constants.LOGGER;
        CLIENT_CONFIG = Constants.CLIENT_CONFIG;
    }

    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        if (((Boolean)SimpleWebSocketServer.CLIENT_CONFIG.logMessages.get()).booleanValue()) {
            LOGGER.info("Connected to WebSocket Client with Port {}", (Object)this.getPort());
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        JsonObject object = new JsonObject();
        object.addProperty("isDisabled", Boolean.valueOf(manager.isDisabled()));
        object.addProperty("isHidden", (Boolean)VoicechatClient.CLIENT_CONFIG.hideIcons.get());
        object.addProperty("isMuted", Boolean.valueOf(manager.isMuted()));
        object.addProperty("isRecording", Boolean.valueOf(client != null && client.getRecorder() != null));
        webSocket.send(object.toString());
    }

    public void onClose(WebSocket webSocket, int i, String s, boolean b) {
        if (((Boolean)SimpleWebSocketServer.CLIENT_CONFIG.logMessages.get()).booleanValue()) {
            LOGGER.info("Disconnected from WebSocket Client with Port {}", (Object)this.getPort());
        }
    }

    public void onMessage(WebSocket webSocket, String message) {
        if (((Boolean)SimpleWebSocketServer.CLIENT_CONFIG.logMessages.get()).booleanValue()) {
            LOGGER.info("Received message from WebSocket Client with Port {}: {}", (Object)this.getPort(), (Object)message);
        }
        new ActionManager(message, webSocket);
    }

    public void onError(WebSocket webSocket, Exception e) {
    }

    public void onStart() {
        Util.getPlatform().openUri("streamdeck://plugins/message/xyz.hajsori.simplemacro.streamdeck/wss?streamdeck=hidden&port=" + this.getPort());
    }
}

