/*
 * Decompiled with CFR 0.152.
 */
package xyz.hajsori.simplemacro.websocket;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreen;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.java_websocket.WebSocket;
import xyz.hajsori.simplemacro.config.ConsumeKeys;

public class ActionManager {
    public ActionManager(String message, WebSocket ws) {
        String action;
        ClientVoicechat client = ClientManager.getClient();
        Minecraft minecraft = Minecraft.getInstance();
        ClientPlayerStateManager playerStates = ClientManager.getPlayerStateManager();
        JsonObject data = (JsonObject)new Gson().fromJson(message, JsonObject.class);
        block7 : switch (action = data.get("action").getAsString()) {
            case "toggle": {
                String target;
                switch (target = data.get("target").getAsString()) {
                    case "microphone": {
                        boolean muted = !playerStates.isMuted();
                        playerStates.setMuted(muted);
                        ws.send("{\"isMuted\":" + muted + "}");
                        break;
                    }
                    case "voiceChat": {
                        boolean disabled = !playerStates.isDisabled();
                        playerStates.setDisabled(disabled);
                        ws.send("{\"isDisabled\":" + disabled + "}");
                        break;
                    }
                    case "icons": {
                        boolean hidden = (Boolean)VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
                        VoicechatClient.CLIENT_CONFIG.hideIcons.set((Object)hidden);
                        ws.send("{\"isHidden\":" + hidden + "}");
                        break;
                    }
                    case "recording": {
                        if (client == null) break;
                        client.toggleRecording();
                        ws.send("{\"isRecording\":" + (client.getRecorder() != null) + "}");
                    }
                }
                break;
            }
            case "setScreen": {
                String target;
                switch (target = data.get("target").getAsString()) {
                    case "adjustVolumes": {
                        minecraft.execute(() -> minecraft.setScreen((Screen)new AdjustVolumesScreen()));
                        break;
                    }
                    case "groupManagement": {
                        if (client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled()) {
                            ClientGroup group = playerStates.getGroup();
                            minecraft.execute(() -> {
                                if (group != null) {
                                    minecraft.setScreen((Screen)new GroupScreen(group));
                                } else {
                                    minecraft.setScreen((Screen)new JoinGroupScreen());
                                }
                            });
                            break;
                        }
                        LocalPlayer player = minecraft.player;
                        if (player == null) break block7;
                        player.sendSystemMessage((Component)Component.translatable((String)"message.voicechat.groups_disabled"));
                        break;
                    }
                    case "voiceChat": {
                        minecraft.execute(() -> minecraft.setScreen((Screen)new VoiceChatScreen()));
                        break;
                    }
                    case "settings": {
                        minecraft.execute(() -> minecraft.setScreen((Screen)new VoiceChatSettingsScreen()));
                    }
                }
                break;
            }
            case "activate": {
                String target;
                switch (target = data.get("target").getAsString()) {
                    case "pushToTalk": {
                        ConsumeKeys.pttKeyDown = true;
                        break;
                    }
                    case "whisper": {
                        ConsumeKeys.whisperKeyDown = true;
                    }
                }
                break;
            }
            case "deactivate": {
                String target;
                switch (target = data.get("target").getAsString()) {
                    case "pushToTalk": {
                        ConsumeKeys.pttKeyDown = false;
                        break;
                    }
                    case "whisper": {
                        ConsumeKeys.whisperKeyDown = false;
                    }
                }
                break;
            }
            case "getData": {
                JsonArray targets = data.get("targets").getAsJsonArray();
                JsonObject answer = new JsonObject();
                for (JsonElement targetElem : targets) {
                    String target;
                    switch (target = targetElem.getAsString()) {
                        case "isMuted": {
                            answer.addProperty("isMuted", Boolean.valueOf(playerStates.isMuted()));
                            break;
                        }
                        case "isDisabled": {
                            answer.addProperty("iisDisabled", Boolean.valueOf(playerStates.isDisabled()));
                            break;
                        }
                        case "isHidden": {
                            answer.addProperty("isHidden", (Boolean)VoicechatClient.CLIENT_CONFIG.hideIcons.get());
                            break;
                        }
                        case "isRecording": {
                            if (client == null) break;
                            answer.addProperty("isRecording", Boolean.valueOf(client.getRecorder() != null));
                        }
                    }
                }
                ws.send(answer.toString());
            }
        }
    }
}

