package archives.tater.kitchenprojectiles;

import net.fabricmc.yarn.constants.MiningLevels;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class KitchenProjectilesSounds {
    private static class_3414 of(class_2960 id) {
        return class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
    }

    private static class_3414 of(String path) {
        return of(new class_2960(KitchenProjectiles.MOD_ID, path));
    }

    public static final class_3414 KNIFE_THROW_LIGHT = of("entity.kitchenprojectiles.knife.light.throw");
    public static final class_3414 KNIFE_HIT_LIGHT = of("entity.kitchenprojectiles.knife.light.hit");
    public static final class_3414 KNIFE_GROUND_LIGHT = of("entity.kitchenprojectiles.knife.light.hit_ground");
    public static final class_3414 KNIFE_RETURN_LIGHT = of("entity.kitchenprojectiles.knife.light.return");
    public static final class_3414 KNIFE_THROW_HEAVY = of("entity.kitchenprojectiles.knife.heavy.throw");
    public static final class_3414 KNIFE_HIT_HEAVY = of("entity.kitchenprojectiles.knife.heavy.hit");
    public static final class_3414 KNIFE_GROUND_HEAVY = of("entity.kitchenprojectiles.knife.heavy.hit_ground");
    public static final class_3414 KNIFE_RETURN_HEAVY = of("entity.kitchenprojectiles.knife.heavy.return");

    public static boolean isKnifeHeavy(class_1799 knifeStack) {
        return knifeStack.method_7909() instanceof class_1831 toolItem && toolItem.method_8022().method_8024() >= MiningLevels.DIAMOND;
    }

    public static class_3414 throwing(class_1799 knifeStack) {
        return isKnifeHeavy(knifeStack) ? KNIFE_THROW_HEAVY : KNIFE_THROW_LIGHT;
    }

    public static class_3414 hit(class_1799 knifeStack) {
        return isKnifeHeavy(knifeStack) ? KNIFE_HIT_HEAVY : KNIFE_HIT_LIGHT;
    }

    public static class_3414 hitGround(class_1799 knifeStack) {
        return isKnifeHeavy(knifeStack) ? KNIFE_GROUND_HEAVY : KNIFE_GROUND_LIGHT;
    }

    public static class_3414 returning(class_1799 knifeStack) {
        return isKnifeHeavy(knifeStack) ? KNIFE_RETURN_HEAVY : KNIFE_RETURN_LIGHT;
    }

    public static void init() {}
}
