package archives.tater.kitchenprojectiles;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment;
import vectorwing.farmersdelight.common.registry.ModEnchantments;
import vectorwing.farmersdelight.common.registry.ModItems;

public class KnifeEntity extends class_1665 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(KnifeEntity.class, class_2943.field_13319);
    private static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(KnifeEntity.class, class_2943.field_13323);
    private static final class_2940<class_1799> KNIFE_STACK = class_2945.method_12791(KnifeEntity.class, class_2943.field_13322);
    private static final class_2940<Boolean> SIMULATED = class_2945.method_12791(KnifeEntity.class, class_2943.field_13323);
    private boolean dealtDamage;
    private int slot = -1;
    public int returnTimer;

    protected KnifeEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public KnifeEntity(class_1937 world, class_1309 owner, class_1799 stack, boolean simulated) {
        super(KitchenProjectiles.KNIFE_ENTITY, owner, world);
        field_6011.method_12778(KNIFE_STACK, stack);
        field_6011.method_12778(LOYALTY, (byte) class_1890.method_8206(stack));
        field_6011.method_12778(ENCHANTED, stack.method_7958());
        field_6011.method_12778(SIMULATED, simulated);
        if (owner instanceof class_1657 playerEntity) {
            var inventory = playerEntity.method_31548();
            var size = inventory.method_5439();
            for (int iSlot = 0; iSlot < size; iSlot++)
                if (inventory.method_5438(iSlot) == stack) {
                    slot = iSlot;
                    break;
                }
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        field_6011.method_12784(LOYALTY, (byte)0);
        field_6011.method_12784(ENCHANTED, false);
        field_6011.method_12784(KNIFE_STACK, ModItems.IRON_KNIFE.get().method_7854());
        field_6011.method_12784(SIMULATED, false);
    }

    @Override
    public void method_5773() {
        if (field_7576 > 4) {
            dealtDamage = true;
        }

        class_1297 entity = method_24921();
        var loyaltyLevel = field_6011.method_12789(LOYALTY);
        if (loyaltyLevel > 0 && !field_6011.method_12789(SIMULATED) && (dealtDamage || method_7441()) && entity != null) {
            if (!isOwnerAlive()) {
                if (!method_37908().field_9236 && field_7572 == class_1665.class_1666.field_7593) {
                    method_5699(method_7445(), 0.1F);
                }

                method_31472();
            } else {
                method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(method_19538());
                method_23327(method_23317(), method_23318() + vec3d.field_1351 * 0.015 * (double) loyaltyLevel, method_23321());
                if (method_37908().field_9236) {
                    field_5971 = method_23318();
                }

                double d = 0.05 * (double) loyaltyLevel;
                method_18799(method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (returnTimer == 0) {
                    method_5783(KitchenProjectilesSounds.returning(getKnifeStack()), 10.0F, 1.0F);
                    method_18800(0, 0, 0);
                }

                returnTimer++;
            }
        }

        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 owner = method_24921();
        return owner != null && owner.method_5805() && (!(owner instanceof class_3222) || !owner.method_7325());
    }

    public class_1799 getKnifeStack() {
        return field_6011.method_12789(KNIFE_STACK);
    }

    protected void setKnifeStack(class_1799 stack) {
        field_6011.method_12778(KNIFE_STACK, stack);
    }

    public boolean isSimulated() {
        return field_6011.method_12789(SIMULATED);
    }

    @Override
    protected class_1799 method_7445() {
        return getKnifeStack().method_7972();
    }

    @Nullable
    @Override
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        var entity = entityHitResult.method_17782();
        float damage = (1
                + (getKnifeStack().method_7909() instanceof KnifeItem knifeItem ? knifeItem.method_26366() : 0)
                + (entity instanceof class_1309 livingEntity ? class_1890.method_8218(getKnifeStack(), livingEntity.method_6046()) : 0));

        var backstabbingLevel = class_1890.method_8225(ModEnchantments.BACKSTABBING.get(), getKnifeStack());
        if (backstabbingLevel > 0 && entity instanceof class_1309 livingEntity && BackstabbingEnchantment.isLookingBehindTarget(livingEntity, method_19538())) {
            damage = BackstabbingEnchantment.getBackstabbingDamagePerLevel(damage, backstabbingLevel);
        }

        var owner = method_24921();
        var damageSource = method_48923().method_48797(KitchenProjectiles.KNIFE_DAMAGE, this, owner == null ? this : owner);
        dealtDamage = true;
        if (entity.method_5643(damageSource, damage)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }

            if (entity instanceof class_1309 livingEntity2) {
                if (owner instanceof class_1309) {
                    class_1890.method_8210(livingEntity2, owner);
                    class_1890.method_8213((class_1309) owner, livingEntity2);
                }

                method_7450(livingEntity2);
            }
        }

        method_18799(method_18798().method_18805(-0.01, -0.1, -0.01));

        method_5783(KitchenProjectilesSounds.hit(getKnifeStack()), 1.0F, 1.0F);
    }

    @Override
    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
    }

    @Override
    protected boolean method_34713(class_1657 player) {
        var inventory = player.method_31548();
        var stack = method_7445();
        return switch (this.field_7572) {
            case field_7593 -> insertStack(inventory, slot, stack);
            case field_7594 -> player.method_31549().field_7477;
            default -> false;
        } || method_7441() && method_34714(player) && insertStack(inventory, slot, stack);
    }

    private static boolean insertStack(class_1661 playerInventory, int slot, class_1799 stack) {
        if (slot >= 0 && playerInventory.method_5438(slot).method_7960()) {
            playerInventory.method_5447(slot, stack);
            return true;
        }
        return playerInventory.method_7394(stack);
    }

    @Override
    protected class_3414 method_7440() {
        return KitchenProjectilesSounds.hitGround(getKnifeStack());
    }

    @Override
    public void method_5694(class_1657 player) {
        if (method_34714(player) || method_24921() == null) {
            super.method_5694(player);
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("Knife", class_2520.field_33260)) {
            setKnifeStack(class_1799.method_7915(nbt.method_10562("Knife")));
        }

        dealtDamage = nbt.method_10577("DealtDamage");
        field_6011.method_12778(SIMULATED, nbt.method_10577("Simulated"));
        field_6011.method_12778(LOYALTY, (byte)class_1890.method_8206(getKnifeStack()));
        slot = nbt.method_10550("Slot");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10566("Knife", getKnifeStack().method_7953(new class_2487()));
        nbt.method_10556("DealtDamage", dealtDamage);
        nbt.method_10556("Simulated", field_6011.method_12789(SIMULATED));
        nbt.method_10569("Slot", slot);
    }

    @Override
    public void method_7446() {
        if (field_7572 != class_1665.class_1666.field_7593) {
            super.method_7446();
        }
    }

    @Override
    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    @Override
    public class_2561 method_5477() {
        return getKnifeStack().method_7964();
    }

    @Override
    protected void method_5825() {
        if (field_6011.method_12789(LOYALTY) <= 0) super.method_5825();
        if (!dealtDamage) {
            dealtDamage = true;
            method_18800(0, 0, 0);
        }
    }
}
