package archives.tater.kitchenprojectiles;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ExtraModelKey;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.SimpleUnbakedExtraModel;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_10430;
import net.minecraft.class_10437;
import net.minecraft.class_10468;
import net.minecraft.class_2960;
import net.minecraft.class_5619;
import net.minecraft.class_7923;
import vectorwing.farmersdelight.common.registry.ModItems;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KitchenProjectilesClient implements ClientModInitializer {
	public static final class_2960 THROWING_PREDICATE = KitchenProjectiles.id("throwing");

	@Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
		class_5619.method_32173(KitchenProjectiles.KNIFE_ENTITY, KnifeEntityRenderer::new);

		var knives = Stream.of(
                ModItems.FLINT_KNIFE.get(),
                ModItems.COPPER_KNIFE.get(),
                ModItems.IRON_KNIFE.get(),
                ModItems.GOLDEN_KNIFE.get(),
                ModItems.DIAMOND_KNIFE.get(),
                ModItems.NETHERITE_KNIFE.get()
		).map(class_7923.field_41178::method_10221).collect(Collectors.toMap(
				itemId -> itemId,
				itemId -> KitchenProjectiles.id("item/" + itemId.method_12832() + "_throwing")
		));

		ModelLoadingPlugin.register(context -> {
            for (var modelId : knives.values()) {
                context.addModel(ExtraModelKey.create(), SimpleUnbakedExtraModel.blockStateModel(modelId));
            }

            context.modifyItemModelBeforeBake().register((unbaked, context1) -> {
                for (var pair : knives.entrySet()) {
                    var itemId = pair.getKey();
                    var modelId = pair.getValue();

                    if (!itemId.equals(context1.itemId())) continue;

                    return new class_10437.class_10438(new class_10468(), new class_10430.class_10431(modelId, List.of()), unbaked);
                }
                return unbaked;
            });
		});
	}
}
