package archives.tater.kitchenprojectiles.mixin;

import archives.tater.kitchenprojectiles.KitchenProjectiles;
import archives.tater.kitchenprojectiles.KitchenProjectilesSounds;
import archives.tater.kitchenprojectiles.KnifeEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_3959;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.joml.Quaternionf;
import vectorwing.farmersdelight.common.item.KnifeItem;
import vectorwing.farmersdelight.common.registry.ModBlocks;

@Mixin(KnifeItem.class)
public abstract class KnifeItemMixin extends class_1792 {

    public KnifeItemMixin(class_1793 settings) {
        super(settings);
    }


    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        var stack = user.method_5998(hand);
        if (stack.method_7936() - stack.method_7919() <= 1 || world.method_8320(method_7872(world, user, class_3959.class_242.field_1348).method_17777()).method_27852(ModBlocks.CUTTING_BOARD.get()))
            return class_1269.field_5811;
        user.method_6019(hand);
        return class_1269.field_21466;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    @Override
    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!(user instanceof class_1657 playerEntity)) return false;
        if (user.method_6048() < KitchenProjectiles.MIN_USE_DURATION) return false;

        if (!(world instanceof class_3218 serverWorld)) return true;

        stack.method_71012(1, user, user.method_6058());

        var multishot = class_1890.method_60119(serverWorld, stack, user, 1);
        var spread = class_1890.method_60118(serverWorld, stack, user, 0f);

        for (var i = 0; i < multishot; i++) {
            var projectileStack = i == 0 ? stack : stack.method_7972();
            if (i != 0)
                projectileStack.method_57379(class_9334.field_49642, class_3902.field_17274);

            var knifeEntity = new KnifeEntity(world, playerEntity, projectileStack);

            var spreadIndex = (2 * (i % 2) - 1) * (i + 1) / 2; // 0, 1, -1, 2, -2, etc.

            var yaw = spread * spreadIndex;

            var opposite = user.method_18864(1f);
            var quaternion = new Quaternionf().setAngleAxis(yaw * class_3532.field_29847, opposite.field_1352, opposite.field_1351, opposite.field_1350);
            var rotation = user.method_5828(1f);
            var velocity = rotation.method_46409().rotate(quaternion);

            knifeEntity.method_7485(velocity.x, velocity.y, velocity.z, 1.5f, 1f);

            if (playerEntity.method_31549().field_7477 || i != 0) {
                knifeEntity.field_7572 = class_1665.class_1666.field_7594;
            }

            world.method_8649(knifeEntity);
            if (i == 0)
                world.method_43129(null, knifeEntity, KitchenProjectilesSounds.throwing(stack), class_3419.field_15248, 1.0F, 1.0F);
        }

        if (!playerEntity.method_31549().field_7477)
            stack.method_7934(1);

        playerEntity.method_7259(class_3468.field_15372.method_14956(this));
        return true;
    }
}
