package archives.tater.kitchenprojectiles.mixin;

import archives.tater.kitchenprojectiles.KnifeEntity;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1665.class)
public abstract class PersistentProjectileEntityMixin extends class_1676 {
    public PersistentProjectileEntityMixin(class_1299<? extends class_1676> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Shadow
    public abstract boolean isNoClip();

    @SuppressWarnings("ConstantValue")
    @ModifyVariable(
            method = "tick",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/projectile/PersistentProjectileEntity;isCritical()Z")
    )
    private boolean hideNoClip(boolean value) {
        return value || (Object) this instanceof KnifeEntity knifeEntity && !knifeEntity.hasDealtDamage();
    }

    @ModifyVariable(
            method = "tick",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/projectile/PersistentProjectileEntity;isTouchingWater()Z", ordinal = 1)
    )
    private boolean restoreNoClip(boolean value) {
        return !isNoClip();
    }

    @SuppressWarnings("ConstantValue")
    @Inject(
            method = "applyCollision",
            at = @At(value = "INVOKE", target = "Ljava/util/Objects;requireNonNullElse(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"),
            cancellable = true
    )
    private void cancelCollision(class_3965 blockHitResult, CallbackInfo ci, @Local class_3966 entityHitResult) {
        if ((Object) this instanceof KnifeEntity knifeEntity && !knifeEntity.hasDealtDamage() && entityHitResult == null && isNoClip()) {
            method_33574(method_73189().method_1019(method_18798()));
            ci.cancel();
        }
    }

    @SuppressWarnings("ConstantValue")
    @ModifyExpressionValue(
            method = "applyCollision",
            at = @At(value = "FIELD", target = "Lnet/minecraft/entity/projectile/PersistentProjectileEntity;noClip:Z")
    )
    private boolean allowCollision(boolean original, @Local class_3966 entityHitResult) {
        return original && entityHitResult != null && (!((Object) this instanceof KnifeEntity knifeEntity) || knifeEntity.hasDealtDamage());
    }
}
