/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.kitchenprojectiles;

import archives.tater.kitchenprojectiles.KitchenProjectiles;
import archives.tater.kitchenprojectiles.KitchenProjectilesSounds;
import archives.tater.kitchenprojectiles.KitchenProjectilesUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment;
import vectorwing.farmersdelight.common.registry.ModDataComponents;
import vectorwing.farmersdelight.common.registry.ModItems;

public class KnifeEntity
extends class_1665 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(KnifeEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<class_1799> TRACKED_STACK = class_2945.method_12791(KnifeEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> DEALT_DAMAGE = class_2945.method_12791(KnifeEntity.class, (class_2941)class_2943.field_13323);
    private boolean hasHit;
    private int slot = -1;
    public int returnTimer;

    protected KnifeEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public KnifeEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(KitchenProjectiles.KNIFE_ENTITY, owner, world, stack, null);
        this.field_6011.method_12778(TRACKED_STACK, (Object)this.method_54759());
        this.updateLoyalty();
        if (owner instanceof class_1657) {
            class_1657 playerEntity = (class_1657)owner;
            class_1661 inventory = playerEntity.method_31548();
            int size = inventory.method_5439();
            for (int iSlot = 0; iSlot < size; ++iSlot) {
                if (inventory.method_5438(iSlot) != stack) continue;
                this.slot = iSlot;
                break;
            }
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(TRACKED_STACK, (Object)this.method_57314());
        builder.method_56912(DEALT_DAMAGE, (Object)false);
    }

    public void method_5674(class_2940<?> data) {
        if (data == TRACKED_STACK) {
            this.method_7444(this.method_7440());
        }
    }

    public boolean hasDealtDamage() {
        return (Boolean)this.field_6011.method_12789(DEALT_DAMAGE);
    }

    private void setDealtDamage(boolean dealtDamage) {
        this.field_6011.method_12778(DEALT_DAMAGE, (Object)dealtDamage);
    }

    private void updateLoyalty() {
        byte by;
        class_1937 class_19372;
        class_1297 owner = this.method_24921();
        if (owner != null && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            by = (byte)class_1890.method_60169((class_3218)serverWorld, (class_1799)this.method_54759(), (class_1297)owner);
        } else {
            by = 0;
        }
        this.field_6011.method_12778(LOYALTY, (Object)by);
    }

    private int getLoyalty() {
        return ((Byte)this.field_6011.method_12789(LOYALTY)).byteValue();
    }

    public boolean isIntangible() {
        return this.getStackClient().method_57826(class_9334.field_49642);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.hasHit = true;
            if (!class_1890.method_60142((class_1799)this.getStackClient(), (class_9331)((class_9331)ModDataComponents.BACKSTABBING.get()))) {
                this.setDealtDamage(true);
            }
        }
        class_1297 entity = this.method_24921();
        int loyaltyLevel = this.getLoyalty();
        if (loyaltyLevel > 0 && !this.isIntangible() && (this.hasHit || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                class_1937 class_19372 = this.method_73183();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    if (this.field_7572 == class_1665.class_1666.field_7593) {
                        this.method_5699(serverWorld, this.method_7445(), 0.1f);
                    }
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(this.method_73189());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)loyaltyLevel, this.method_23321());
                if (this.method_73183().method_8608()) {
                    this.field_5971 = this.method_23318();
                }
                double d = 0.05 * (double)loyaltyLevel;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(KitchenProjectilesSounds.returning(this.method_54759()), 10.0f, 1.0f);
                    this.method_18800(0.0, 0.0, 0.0);
                }
                ++this.returnTimer;
            }
        }
        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 owner = this.method_24921();
        return owner != null && owner.method_5805() && (!(owner instanceof class_3222) || !owner.method_7325());
    }

    protected class_1799 method_57314() {
        return ((class_1792)ModItems.IRON_KNIFE.get()).method_7854();
    }

    public class_1799 getStackClient() {
        return (class_1799)this.field_6011.method_12789(TRACKED_STACK);
    }

    protected void method_57313(class_1799 stack) {
        super.method_57313(stack);
        this.field_6011.method_12778(TRACKED_STACK, (Object)stack);
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && (entity != this.method_24921() || !this.field_5960);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.hasDealtDamage() ? null : super.method_7434(currentPosition, nextPosition);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1937 class_19372;
        class_1309 livingEntity;
        class_1297 entity = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        class_1799 stack = this.method_54759();
        class_1282 damageSource = this.method_48923().method_48797(KitchenProjectiles.KNIFE_DAMAGE, (class_1297)this, (class_1297)(owner == null ? this : owner));
        float damage = KitchenProjectilesUtil.getDamage(stack, damageSource, this.method_73183(), entity);
        if (entity instanceof class_1309 && BackstabbingEnchantment.isLookingBehindTarget((class_1309)(livingEntity = (class_1309)entity), (class_243)this.method_73189()) && (class_19372 = this.method_73183()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            MutableFloat dmg = new MutableFloat(damage);
            class_1890.method_8220((class_1799)this.method_54759(), (enchantment, powerLevel) -> ((class_1887)enchantment.comp_349()).method_60035((class_9331)ModDataComponents.BACKSTABBING.get(), serverLevel, powerLevel, stack, (class_1297)this, damageSource, dmg));
            if (damage != dmg.getValue().floatValue()) {
                damage = dmg.getValue().floatValue();
                serverLevel.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15016, class_3419.field_15245, 1.0f, 1.0f);
            }
        }
        this.hasHit = true;
        this.setDealtDamage(true);
        if (entity.method_64420(damageSource, damage)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }
            if (entity instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)entity;
                if (owner instanceof class_1309 && (class_19372 = this.method_73183()) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    class_1890.method_60619((class_3218)serverWorld, (class_1297)entity, (class_1282)damageSource, (class_1799)stack);
                }
                this.method_7450(livingEntity2);
            }
        }
        this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        this.method_5783(KitchenProjectilesSounds.hit(this.method_54759()), 1.0f, 1.0f);
    }

    protected void method_59956(class_3218 world, class_3965 blockHitResult, class_1799 weaponStack) {
        class_1309 livingEntity;
        class_1297 class_12972 = this.method_24921();
        class_1890.method_60124((class_3218)world, (class_1799)weaponStack, (class_1309)(class_12972 instanceof class_1309 ? (livingEntity = (class_1309)class_12972) : null), (class_1297)this, null, (class_243)blockHitResult.method_17777().method_60913(blockHitResult.method_17784()), (class_2680)world.method_8320(blockHitResult.method_17777()), item -> this.method_5768(world));
    }

    public class_1799 method_59958() {
        return this.method_54759();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean method_34713(class_1657 player) {
        class_1661 inventory = player.method_31548();
        class_1799 stack = this.method_7445();
        switch (this.field_7572) {
            case field_7593: {
                if (!KnifeEntity.insertStack(inventory, this.slot, stack)) break;
                return true;
            }
            case field_7594: {
                if (player.method_31549().field_7477) return true;
            }
        }
        if (!this.method_7441()) return false;
        if (!this.method_34714((class_1297)player)) return false;
        if (!KnifeEntity.insertStack(inventory, this.slot, stack)) return false;
        return true;
    }

    private static boolean insertStack(class_1661 playerInventory, int slot, class_1799 stack) {
        if (slot >= 0 && playerInventory.method_5438(slot).method_7960()) {
            playerInventory.method_5447(slot, stack);
            return true;
        }
        return playerInventory.method_7394(stack);
    }

    protected class_3414 method_7440() {
        return KitchenProjectilesSounds.hitGround(this.getStackClient());
    }

    public void method_5694(class_1657 player) {
        if (this.method_34714((class_1297)player) || this.method_24921() == null) {
            super.method_5694(player);
        }
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.hasHit = view.method_71433("HasHit", false);
        this.setDealtDamage(view.method_71433("DealtDamage", false));
        this.updateLoyalty();
        this.slot = view.method_71424("Slot", -1);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71472("HasHit", this.hasHit);
        view.method_71472("DealtDamage", this.hasDealtDamage());
        view.method_71465("Slot", this.slot);
    }

    public void method_7446() {
        if (this.field_7572 != class_1665.class_1666.field_7593) {
            super.method_7446();
        }
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public class_2561 method_5477() {
        return this.getStackClient().method_7964();
    }

    protected void method_5825() {
        if (this.getLoyalty() <= 0) {
            super.method_5825();
        }
        if (!this.hasHit) {
            this.hasHit = true;
            this.method_18800(0.0, 0.0, 0.0);
        }
    }
}

