/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.kitchenprojectiles;

import archives.tater.kitchenprojectiles.KitchenProjectiles;
import archives.tater.kitchenprojectiles.client.KnifeEntityRenderer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@Mod(value="kitchenprojectiles", dist={Dist.CLIENT})
@EventBusSubscriber(modid="kitchenprojectiles", value={Dist.CLIENT})
public class KitchenProjectilesClient {
    public static final ResourceLocation THROWING_PREDICATE = KitchenProjectiles.id("throwing");

    public KitchenProjectilesClient(ModContainer container) {
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)KitchenProjectiles.KNIFE_ENTITY.get(), KnifeEntityRenderer::new);
    }

    @SubscribeEvent
    private static void onClientSetup(FMLClientSetupEvent event) {
        ItemProperties.registerGeneric((ResourceLocation)THROWING_PREDICATE, (stack, level, entity, seed) -> entity != null && entity.isUsingItem() && entity.getUseItem() == stack ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    private static void commonSetup(FMLCommonSetupEvent event) {
        Map<ModelResourceLocation, ResourceLocation> knives = Stream.of("flint", "iron", "diamond", "golden", "netherite").collect(Collectors.toMap(prefix -> new ModelResourceLocation(ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)(prefix + "_knife")), "inventory"), prefix -> KitchenProjectiles.id("item/" + prefix + "_knife_throwing")));
        ModelLoadingPlugin.register(context -> {
            context.addModels(knives.values());
            context.modifyModelBeforeBake().register((unbakedModel, context1) -> {
                for (ModelResourceLocation modelId : knives.keySet()) {
                    if (!modelId.equals((Object)context1.topLevelId())) continue;
                    if (!(unbakedModel instanceof BlockModel)) break;
                    BlockModel jsonUnbakedModel = (BlockModel)unbakedModel;
                    jsonUnbakedModel.getOverrides().add(new ItemOverride((ResourceLocation)knives.get(modelId), List.of(new ItemOverride.Predicate(THROWING_PREDICATE, 1.0f))));
                    break;
                }
                return unbakedModel;
            });
        });
    }
}

