package archives.tater.kitchenprojectiles;

import archives.tater.kitchenprojectiles.client.KnifeEntityRenderer;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1091;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_793;
import net.minecraft.class_799;
import vectorwing.farmersdelight.FarmersDelight;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KitchenProjectilesClient implements ClientModInitializer {
	public static final class_2960 THROWING_PREDICATE = KitchenProjectiles.id("throwing");

	@Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
		EntityRendererRegistry.register(KitchenProjectiles.KNIFE_ENTITY, KnifeEntityRenderer::new);

		class_5272.method_27881(THROWING_PREDICATE, (stack, level, entity, seed) ->
				entity != null && entity.method_6115() && entity.method_6030() == stack ? 1.0F : 0.0F
		);

		var knives = Stream.of(
				"flint",
				"iron",
				"diamond",
				"golden",
				"netherite"
		).collect(Collectors.toMap(
				prefix -> new class_1091(class_2960.method_60655(FarmersDelight.MODID, prefix + "_knife"), "inventory"),
				prefix -> KitchenProjectiles.id("item/" + prefix + "_knife_throwing")
		));

		ModelLoadingPlugin.register(context -> {
			context.addModels(knives.values());

			context.modifyModelBeforeBake().register((unbakedModel, context1) -> {
				for (var modelId : knives.keySet()) {
					if (!modelId.equals(context1.topLevelId())) continue;
					if (!(unbakedModel instanceof class_793 jsonUnbakedModel)) break;

					jsonUnbakedModel.method_3434().add(new class_799(
							knives.get(modelId),
							List.of(new class_799.class_5826(THROWING_PREDICATE, 1))));

					break;
				}
				return unbakedModel;
			});
		});
	}
}
