package archives.tater.kitchenprojectiles;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment;
import vectorwing.farmersdelight.common.registry.ModDataComponents;
import vectorwing.farmersdelight.common.registry.ModItems;

public class KnifeEntity extends class_1665 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(KnifeEntity.class, class_2943.field_13319);
    private static final class_2940<class_1799> TRACKED_STACK = class_2945.method_12791(KnifeEntity.class, class_2943.field_13322);
    private static final class_2940<Boolean> DEALT_DAMAGE = class_2945.method_12791(KnifeEntity.class, class_2943.field_13323);
    private boolean hasHit;
    private int slot = -1;
    public int returnTimer;

    protected KnifeEntity(class_1299<? extends class_1665> entityType, class_1937 level) {
        super(entityType, level);
    }

    public KnifeEntity(class_1937 level, class_1309 owner, class_1799 stack) {
        super(KitchenProjectiles.KNIFE_ENTITY, owner, level, stack, null);
        field_6011.method_12778(TRACKED_STACK, method_54759()); // minecraft:intangible_projectile is removed from instance but not copy
        updateLoyalty();
        if (owner instanceof class_1657 playerEntity) {
            var inventory = playerEntity.method_31548();
            var size = inventory.method_5439();
            for (int iSlot = 0; iSlot < size; iSlot++)
                if (inventory.method_5438(iSlot) == stack) {
                    slot = iSlot;
                    break;
                }
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (byte)0);
        builder.method_56912(TRACKED_STACK, method_57314());
        builder.method_56912(DEALT_DAMAGE, false);
    }

    @Override
    public void method_5674(class_2940<?> data) {
        if (data == TRACKED_STACK)
            method_7444(method_7440());
    }

    public boolean hasDealtDamage() {
        return field_6011.method_12789(DEALT_DAMAGE);
    }

    private void setDealtDamage(boolean dealtDamage) {
        field_6011.method_12778(DEALT_DAMAGE, dealtDamage);
    }

    private void updateLoyalty() {
        var owner = method_24921();
        field_6011.method_12778(LOYALTY, owner != null && method_37908() instanceof class_3218 serverLevel ? (byte) class_1890.method_60169(serverLevel, method_54759(), owner) : 0);
    }

    private int getLoyalty() {
        return field_6011.method_12789(LOYALTY);
    }

    public boolean isIntangible() {
        // Called on both sides
        return getStackClient().method_57826(class_9334.field_49642);
    }

    @Override
    public void method_5773() {
        if (field_7576 > 4) {
            hasHit = true;
            if (!class_1890.method_60142(getStackClient(), ModDataComponents.BACKSTABBING.get()))
                setDealtDamage(true);
        }

        class_1297 entity = method_24921();
        var loyaltyLevel = getLoyalty();
        if (loyaltyLevel > 0 && !isIntangible() && (hasHit || method_7441()) && entity != null) {
            if (!isOwnerAlive()) {
                if (!method_37908().field_9236 && field_7572 == class_1665.class_1666.field_7593) {
                    method_5699(method_7445(), 0.1F);
                }

                method_31472();
            } else {
                method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(method_19538());
                method_23327(method_23317(), method_23318() + vec3d.field_1351 * 0.015 * (double) loyaltyLevel, method_23321());
                if (method_37908().field_9236) {
                    field_5971 = method_23318();
                }

                double d = 0.05 * (double) loyaltyLevel;
                method_18799(method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (returnTimer == 0) {
                    method_5783(KitchenProjectilesSounds.returning(method_54759()), 10.0F, 1.0F);
                    method_18800(0, 0, 0);
                }

                returnTimer++;
            }
        }

        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 owner = method_24921();
        return owner != null && owner.method_5805() && (!(owner instanceof class_3222) || !owner.method_7325());
    }

    @Override
    protected @NotNull class_1799 method_57314() {
        return ModItems.IRON_KNIFE.get().method_7854();
    }

    public class_1799 getStackClient() {
        return field_6011.method_12789(TRACKED_STACK);
    }

    @Override
    protected void method_57313(class_1799 stack) {
        super.method_57313(stack);
        field_6011.method_12778(TRACKED_STACK, stack);
    }

    @Override
    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && (entity != method_24921() || !field_5960);
    }

    @Nullable
    @Override
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return hasDealtDamage() ? null : super.method_7434(currentPosition, nextPosition);
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        var entity = entityHitResult.method_17782();
        var owner = method_24921();
        var stack = method_54759();
        var damageSource = method_48923().method_48797(KitchenProjectiles.KNIFE_DAMAGE, this, owner == null ? this : owner);

        var damage = KitchenProjectilesUtil.getDamage(stack, damageSource, method_37908(), entity);

        if (entity instanceof class_1309 livingEntity && BackstabbingEnchantment.isLookingBehindTarget(livingEntity, method_19538()) && method_37908() instanceof class_3218 serverLevel) {
            var dmg = new MutableFloat(damage);
            class_1890.method_8220(method_54759(), (enchantment, powerLevel) ->
                    enchantment.comp_349().method_60035(ModDataComponents.BACKSTABBING.get(), serverLevel, powerLevel, stack, this, damageSource, dmg)
            );

            if (damage != dmg.getValue()) {
                damage = dmg.getValue();
                serverLevel.method_43128(null, method_23317(), method_23318(), method_23321(), class_3417.field_15016, class_3419.field_15245, 1.0F, 1.0F);
            }
        }

        hasHit = true;
        setDealtDamage(true);
        if (entity.method_5643(damageSource, damage)) {
            if (entity.method_5864() == class_1299.field_6091) {
                return;
            }

            if (entity instanceof class_1309 livingEntity2) {
                if (owner instanceof class_1309 && method_37908() instanceof class_3218 serverLevel) {
                    class_1890.method_60619(serverLevel, entity, damageSource, stack);
                }

                method_7450(livingEntity2);
            }
        }

        method_18799(method_18798().method_18805(-0.01, -0.1, -0.01));

        method_5783(KitchenProjectilesSounds.hit(method_54759()), 1.0F, 1.0F);
    }

    @Override
    protected void method_59956(class_3218 level, class_3965 blockHitResult, class_1799 weaponStack) {
        class_1890.method_60124(level,
                weaponStack,
                this.method_24921() instanceof class_1309 livingEntity ? livingEntity : null,
                this,
                null,
                blockHitResult.method_17777().method_60913(blockHitResult.method_17784()),
                level.method_8320(blockHitResult.method_17777()),
                item -> method_5768());
    }

    @Override
    protected boolean method_34713(class_1657 player) {
        var inventory = player.method_31548();
        var stack = method_7445();
        return switch (this.field_7572) {
            case field_7593 -> insertStack(inventory, slot, stack);
            case field_7594 -> player.method_31549().field_7477;
            default -> false;
        } || method_7441() && method_34714(player) && insertStack(inventory, slot, stack);
    }

    private static boolean insertStack(class_1661 playerInventory, int slot, class_1799 stack) {
        if (slot >= 0 && playerInventory.method_5438(slot).method_7960()) {
            playerInventory.method_5447(slot, stack);
            return true;
        }
        return playerInventory.method_7394(stack);
    }

    @Override
    protected @NotNull class_3414 method_7440() {
        return KitchenProjectilesSounds.hitGround(getStackClient());
    }

    @Override
    public void method_5694(class_1657 player) {
        if (method_34714(player) || method_24921() == null) {
            super.method_5694(player);
        }
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        hasHit = nbt.method_10577("HasHit");
        setDealtDamage(nbt.method_10577("DealtDamage"));
        updateLoyalty();
        slot = nbt.method_10550("Slot");
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("HasHit", hasHit);
        nbt.method_10556("DealtDamage", hasDealtDamage());
        nbt.method_10569("Slot", slot);
    }

    @Override
    public void method_7446() {
        if (field_7572 != class_1665.class_1666.field_7593) {
            super.method_7446();
        }
    }

    @Override
    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    @Override
    public @NotNull class_2561 method_5477() {
        return getStackClient().method_7964();
    }

    @Override
    protected void method_5825() {
        if (getLoyalty() <= 0) super.method_5825();
        if (!hasHit) {
            hasHit = true;
            method_18800(0, 0, 0);
        }
    }
}
