/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.kitchenprojectiles;

import archives.tater.kitchenprojectiles.KitchenProjectiles;
import archives.tater.kitchenprojectiles.KitchenProjectilesSounds;
import archives.tater.kitchenprojectiles.KitchenProjectilesUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.enchantment.BackstabbingEnchantment;
import vectorwing.farmersdelight.common.registry.ModDataComponents;
import vectorwing.farmersdelight.common.registry.ModItems;

public class KnifeEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> LOYALTY = SynchedEntityData.defineId(KnifeEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<ItemStack> TRACKED_STACK = SynchedEntityData.defineId(KnifeEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Boolean> DEALT_DAMAGE = SynchedEntityData.defineId(KnifeEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private boolean hasHit;
    private int slot = -1;
    public int returnTimer;

    protected KnifeEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public KnifeEntity(Level level, LivingEntity owner, ItemStack stack) {
        super((EntityType)KitchenProjectiles.KNIFE_ENTITY.get(), owner, level, stack, null);
        this.entityData.set(TRACKED_STACK, (Object)this.getPickupItemStackOrigin());
        this.updateLoyalty();
        if (owner instanceof Player) {
            Player playerEntity = (Player)owner;
            Inventory inventory = playerEntity.getInventory();
            int size = inventory.getContainerSize();
            for (int iSlot = 0; iSlot < size; ++iSlot) {
                if (inventory.getItem(iSlot) != stack) continue;
                this.slot = iSlot;
                break;
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOYALTY, (Object)0);
        builder.define(TRACKED_STACK, (Object)this.getDefaultPickupItem());
        builder.define(DEALT_DAMAGE, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        if (data == TRACKED_STACK) {
            this.setSoundEvent(this.getDefaultHitGroundSoundEvent());
        }
    }

    public boolean hasDealtDamage() {
        return (Boolean)this.entityData.get(DEALT_DAMAGE);
    }

    private void setDealtDamage(boolean dealtDamage) {
        this.entityData.set(DEALT_DAMAGE, (Object)dealtDamage);
    }

    private void updateLoyalty() {
        byte by;
        Level level;
        Entity owner = this.getOwner();
        if (owner != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            by = (byte)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverLevel, (ItemStack)this.getPickupItemStackOrigin(), (Entity)owner);
        } else {
            by = 0;
        }
        this.entityData.set(LOYALTY, (Object)by);
    }

    private int getLoyalty() {
        return ((Byte)this.entityData.get(LOYALTY)).byteValue();
    }

    public boolean isIntangible() {
        return this.getStackClient().has(DataComponents.INTANGIBLE_PROJECTILE);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.hasHit = true;
            if (!EnchantmentHelper.has((ItemStack)this.getStackClient(), (DataComponentType)((DataComponentType)ModDataComponents.BACKSTABBING.get()))) {
                this.setDealtDamage(true);
            }
        }
        Entity entity = this.getOwner();
        int loyaltyLevel = this.getLoyalty();
        if (loyaltyLevel > 0 && !this.isIntangible() && (this.hasHit || this.isNoPhysics()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3d = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3d.y * 0.015 * (double)loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                double d = 0.05 * (double)loyaltyLevel;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d.normalize().scale(d)));
                if (this.returnTimer == 0) {
                    this.playSound(KitchenProjectilesSounds.returning(this.getPickupItemStackOrigin()), 10.0f, 1.0f);
                    this.setDeltaMovement(0.0, 0.0, 0.0);
                }
                ++this.returnTimer;
            }
        }
        super.tick();
    }

    private boolean isOwnerAlive() {
        Entity owner = this.getOwner();
        return owner != null && owner.isAlive() && (!(owner instanceof ServerPlayer) || !owner.isSpectator());
    }

    @NotNull
    protected ItemStack getDefaultPickupItem() {
        return ((Item)ModItems.IRON_KNIFE.get()).getDefaultInstance();
    }

    public ItemStack getStackClient() {
        return (ItemStack)this.entityData.get(TRACKED_STACK);
    }

    protected void setPickupItemStack(ItemStack stack) {
        super.setPickupItemStack(stack);
        this.entityData.set(TRACKED_STACK, (Object)stack);
    }

    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && (entity != this.getOwner() || !this.noPhysics);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 currentPosition, Vec3 nextPosition) {
        return this.hasDealtDamage() ? null : super.findHitEntity(currentPosition, nextPosition);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        ServerLevel serverLevel;
        Level level;
        LivingEntity livingEntity;
        Entity entity = entityHitResult.getEntity();
        Entity owner = this.getOwner();
        ItemStack stack = this.getPickupItemStackOrigin();
        DamageSource damageSource = this.damageSources().source(KitchenProjectiles.KNIFE_DAMAGE, (Entity)this, (Entity)(owner == null ? this : owner));
        float damage = KitchenProjectilesUtil.getDamage(stack, damageSource, this.level(), entity);
        if (entity instanceof LivingEntity && BackstabbingEnchantment.isLookingBehindTarget((LivingEntity)(livingEntity = (LivingEntity)entity), (Vec3)this.position()) && (level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            MutableFloat dmg = new MutableFloat(damage);
            EnchantmentHelper.runIterationOnItem((ItemStack)this.getPickupItemStackOrigin(), (enchantment, powerLevel) -> ((Enchantment)enchantment.value()).modifyDamageFilteredValue((DataComponentType)ModDataComponents.BACKSTABBING.get(), serverLevel, powerLevel, stack, (Entity)this, damageSource, dmg));
            if (damage != dmg.getValue().floatValue()) {
                damage = dmg.getValue().floatValue();
                serverLevel.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        this.hasHit = true;
        this.setDealtDamage(true);
        if (entity.hurt(damageSource, damage)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (owner instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource, (ItemStack)stack);
                }
                this.doPostHurtEffects(livingEntity2);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(KitchenProjectilesSounds.hit(this.getPickupItemStackOrigin()), 1.0f, 1.0f);
    }

    protected void hitBlockEnchantmentEffects(ServerLevel level, BlockHitResult blockHitResult, ItemStack weaponStack) {
        LivingEntity livingEntity;
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)level, (ItemStack)weaponStack, (LivingEntity)(entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)blockHitResult.getBlockPos().clampLocationWithin(blockHitResult.getLocation()), (BlockState)level.getBlockState(blockHitResult.getBlockPos()), item -> this.kill());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean tryPickup(Player player) {
        Inventory inventory = player.getInventory();
        ItemStack stack = this.getPickupItem();
        switch (this.pickup) {
            case ALLOWED: {
                if (!KnifeEntity.insertStack(inventory, this.slot, stack)) break;
                return true;
            }
            case CREATIVE_ONLY: {
                if (player.getAbilities().instabuild) return true;
            }
        }
        if (!this.isNoPhysics()) return false;
        if (!this.ownedBy((Entity)player)) return false;
        if (!KnifeEntity.insertStack(inventory, this.slot, stack)) return false;
        return true;
    }

    private static boolean insertStack(Inventory playerInventory, int slot, ItemStack stack) {
        if (slot >= 0 && playerInventory.getItem(slot).isEmpty()) {
            playerInventory.setItem(slot, stack);
            return true;
        }
        return playerInventory.add(stack);
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return KitchenProjectilesSounds.hitGround(this.getStackClient());
    }

    public void playerTouch(Player player) {
        if (this.ownedBy((Entity)player) || this.getOwner() == null) {
            super.playerTouch(player);
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.hasHit = nbt.getBoolean("HasHit");
        this.setDealtDamage(nbt.getBoolean("DealtDamage"));
        this.updateLoyalty();
        this.slot = nbt.getInt("Slot");
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("HasHit", this.hasHit);
        nbt.putBoolean("DealtDamage", this.hasDealtDamage());
        nbt.putInt("Slot", this.slot);
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    public boolean shouldRender(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    @NotNull
    public Component getName() {
        return this.getStackClient().getHoverName();
    }

    protected void onBelowWorld() {
        if (this.getLoyalty() <= 0) {
            super.onBelowWorld();
        }
        if (!this.hasHit) {
            this.hasHit = true;
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
    }
}

